/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LogUtils {
    private static String _CLASSTAG = LogUtils.class.getSimpleName();

    public static Map<String, Object> initLogMap(Map<String, Object> logMap) {
        logMap.put("_id", UUID.randomUUID());
        return logMap;
    }

    public static Map<String, Object> filterEventContextMap(Map<String, String> contextDataMap, List<String> tracerKeysList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator<String> var3 = contextDataMap.keySet().iterator();
        while (var3.hasNext()) {
            String contextKey = var3.next();
            if (tracerKeysList != null && (tracerKeysList == null || !tracerKeysList.contains(contextKey))) continue;
            result.put(contextKey, contextDataMap.get(contextKey));
        }
        return result;
    }

    public static Map<String, Object> afterLogMap(Map<String, Object> logMap) {
        logMap.putIfAbsent("server", LogUtils.getLocalHostIpName());
        return logMap;
    }

    public static String getLocalHostIpName() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException var4) {
            System.out.println(_CLASSTAG + " UnknownHostException:" + var4.getLocalizedMessage());
        }
        String ip = addr.getHostAddress().toString();
        String hostName = addr.getHostName().toString();
        String result = hostName != null && hostName != "" ? hostName : ip;
        return result;
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }
}

