/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolUtil {
    private static volatile ThreadPoolExecutor threadPoolExecutor;
    private static final int BLOCK_QUEUE_SIZE = 8;
    private static final int CORE_POOL_SIZE = 4;
    private static final int MAX_POOL_SIZE = 8;
    private static final int KEEP_ALIVE_TIME = 5;
    private static final TimeUnit timeUnit;
    private static final BlockingQueue<Runnable> workQueue;
    private static final RejectedExecutionHandler handler;

    private ThreadPoolUtil() {
    }

    public static void executor(Runnable runnable) {
        ThreadPoolUtil.getInstance().execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return ThreadPoolUtil.getInstance().submit(callable);
    }

    public static void shutdown() {
        ThreadPoolUtil.getInstance().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ThreadPoolExecutor getInstance() {
        if (threadPoolExecutor != null) return threadPoolExecutor;
        Class<ThreadPoolUtil> clazz = ThreadPoolUtil.class;
        synchronized (ThreadPoolUtil.class) {
            if (threadPoolExecutor != null) return threadPoolExecutor;
            threadPoolExecutor = new ThreadPoolExecutor(4, 8, 5L, timeUnit, workQueue, new NamedThreadFactory("dap-logback-persistence-log-executor-"), handler);
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadPoolExecutor;
        }
    }

    static {
        timeUnit = TimeUnit.SECONDS;
        workQueue = new LinkedBlockingQueue<Runnable>(8);
        handler = new ThreadPoolExecutor.DiscardPolicy();
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private final String prefix;
        private final AtomicInteger counter = new AtomicInteger(0);

        public NamedThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(this.prefix + "-" + this.counter.incrementAndGet());
            return t;
        }
    }
}

