package com.digiwin.dap.middleware.lmc.common.auth;

import com.digiwin.dap.middleware.lmc.util.JwtUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Default implementation of {@link AuthCache}.
 *
 * @author chenzhuang
 * @date 2021/4/20
 */
public class BasicAuthCache implements AuthCache {

    private final Map<String, String> tokenMap = new ConcurrentHashMap<>();

    @Override
    public void put(String endpoint, String token) {
        tokenMap.put(endpoint, token);
    }

    @Override
    public String get(String endpoint) {
        String token = tokenMap.get(endpoint);
        if (JwtUtil.isExpires(token)) {
            return null;
        }
        return token;
    }

    @Override
    public void remove(String endpoint) {
        tokenMap.remove(endpoint);
    }

    @Override
    public void clear() {
        tokenMap.clear();
    }
}
