package com.digiwin.dap.middleware.lmc.exception;


import com.digiwin.dap.middleware.lmc.http.client.ServiceException;

/**
 * The LMCException is thrown upon error when accessing LMC.
 *
 * @author chenzhuang
 * @date 2021/4/23
 */
public class LMCException extends ServiceException {

    private static final long serialVersionUID = -1979779664334663173L;
    private int httpCode = -1;
    private String resourceType;
    private String header;
    private String method;

    public LMCException() {
        super();
    }

    public LMCException(String errorMessage) {
        super(errorMessage);
    }

    public LMCException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
    }

    public LMCException(String errorMessage, String errorCode) {
        super(errorMessage, errorCode, null, null);
    }

    public LMCException(String errorMessage, String errorCode, String requestId) {
        this(errorMessage, errorCode, requestId, null, null, null, null, null, null);
    }

    public LMCException(String errorMessage, String errorCode, String requestId, Throwable cause ) {
        this(errorMessage, errorCode, requestId, null, null, null, null, null, cause);
    }
    public LMCException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                        String resourceType, String method) {
        this(errorMessage, errorCode, requestId, hostId, header, resourceType, method, null, null);
    }

    public LMCException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                        String resourceType, String method, Throwable cause) {
        this(errorMessage, errorCode, requestId, hostId, header, resourceType, method, null, cause);
    }

    public LMCException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                        String resourceType, String method, String rawResponseError) {
        this(errorMessage, errorCode, requestId, hostId, header, resourceType, method, rawResponseError, null);
    }

    public LMCException(String errorMessage, String errorCode, String requestId, String hostId, String header,
                        String resourceType, String method, String rawResponseError, Throwable cause) {
        super(errorMessage, errorCode, requestId, hostId, rawResponseError, cause);
        this.resourceType = resourceType;
        this.header = header;
        this.method = method;
    }

    /**
     * Construct LogException
     *
     * @param httpCode     http code, -1 the error is happened in the client
     * @param errorCode    error code
     * @param errorMessage error message
     * @param requestId    request id from sls server, if the error is happened in the
     *                     client, the request id is empty
     */
    public LMCException(int httpCode, String errorCode, String errorMessage, String requestId) {
        this(errorMessage, errorCode, requestId);
        this.httpCode = httpCode;
    }

    public String getResourceType() {
        return resourceType;
    }

    public String getHeader() {
        return header;
    }

    public String getMethod() {
        return method;
    }

    public int getHttpCode() {
        return httpCode;
    }

    public void setHttpCode(int httpCode) {
        this.httpCode = httpCode;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\n[httpCode]: " + httpCode + (resourceType == null ? "" : "\n[ResourceType]: " + resourceType)
                + (header == null ? "" : "\n[Header]: " + header) + (method == null ? "" : "\n[Method]: " + method);
    }
}
