package com.digiwin.dap.middleware.lmc.http.utils;

import com.digiwin.dap.middleware.lmc.exception.LMCException;
import com.digiwin.dap.middleware.lmc.http.client.ClientErrorCode;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.internal.ErrorCode;
import com.digiwin.dap.middleware.lmc.internal.model.StdError;
import com.digiwin.dap.middleware.lmc.util.LMCUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.NoHttpResponseException;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

/**
 * A simple factory used for creating instances of <code>ClientException</code>
 * and <code>OSSException</code>.
 *
 * @author chenzhuang
 * @date 2021/4/23
 */
public class ExceptionFactory {

    public static ClientException createNetworkException(IOException ex) {
        String requestId = "Unknown";
        String errorCode = ClientErrorCode.UNKNOWN;

        if (ex instanceof SocketTimeoutException) {
            errorCode = ClientErrorCode.SOCKET_TIMEOUT;
        } else if (ex instanceof SocketException) {
            errorCode = ClientErrorCode.SOCKET_EXCEPTION;
        } else if (ex instanceof ConnectException) {
            errorCode = ClientErrorCode.CONNECTION_REFUSED;
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = ClientErrorCode.CONNECTION_TIMEOUT;
        } else if (ex instanceof UnknownHostException) {
            errorCode = ClientErrorCode.UNKNOWN_HOST;
        } else if (ex instanceof HttpHostConnectException) {
            errorCode = ClientErrorCode.CONNECTION_REFUSED;
        } else if (ex instanceof NoHttpResponseException) {
            errorCode = ClientErrorCode.CONNECTION_TIMEOUT;
        } else if (ex instanceof HttpResponseException) {
            errorCode = ClientErrorCode.SERVER_ERROR;
        } else if (ex instanceof ClientProtocolException) {
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }

    public static LMCException createBadResponseException(String requestId, String rawResponseError,
                                                          Throwable cause) {
        return createBadResponseException(requestId,
                LMCUtils.COMMON_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", cause.getMessage()),
                rawResponseError);
    }

    public static LMCException createBadResponseException(String requestId, String message,
                                                          String rawResponseError) {
        return createOSSException(requestId, ErrorCode.BAD_RESPONSE, message, rawResponseError);
    }

    public static LMCException createOSSException(String requestId, String errorCode, String message,
                                                  String rawResponseError) {
        return new LMCException(message, errorCode, requestId, null, null, null, null, rawResponseError);
    }

    public static LMCException createOSSException(String requestId, String errorCode, String message) {
        return new LMCException(message, errorCode, requestId, null, null, null, null);
    }

    public static LMCException createUnknownOSSException(String requestId, int statusCode) {
        String message = "No body in response, http status code " + Integer.toString(statusCode);
        return new LMCException(message, ClientErrorCode.UNKNOWN, requestId, null, null, null, null);
    }

    public static LMCException createOSSException(StdError errorResult) {
        return new LMCException(errorResult.getErrorMessage(), errorResult.getErrorCode());
    }
}
