package com.digiwin.dap.middleware.lmc.internal;


import com.digiwin.dap.middleware.lmc.common.parser.ErrorResponseParser;
import com.digiwin.dap.middleware.lmc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.lmc.common.parser.ResponseParser;
import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;
import com.digiwin.dap.middleware.lmc.internal.model.PageData;
import com.digiwin.dap.middleware.lmc.internal.model.StdData;
import com.digiwin.dap.middleware.lmc.internal.model.entity.DevLog;
import com.digiwin.dap.middleware.lmc.internal.model.entity.EventLog;
import com.digiwin.dap.middleware.lmc.internal.model.entity.OpLog;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.digiwin.dap.middleware.lmc.util.LMCUtils;
import com.fasterxml.jackson.core.type.TypeReference;

/**
 * A collection of parsers that parse HTTP responses into corresponding human-readable results.
 *
 * @author chenzhuang
 * @date 2021/4/22
 */
public final class ResponseParsers {

    public static final ErrorResponseParser errorResponseParser = new ErrorResponseParser();
    public static final StdDataResponseParser stdDataResponseParser = new StdDataResponseParser();
    public static final SaveOpLogResponseParser saveOpLogResponseParser = new SaveOpLogResponseParser();
    public static final SaveEventLogResponseParser saveEventLogResponseParser = new SaveEventLogResponseParser();
    public static final SaveDevLogResponseParser saveDevLogResponseParser = new SaveDevLogResponseParser();
    public static final PageDataOpLogResponseParser pageDataOpLogResponseParser = new PageDataOpLogResponseParser();
    public static final PageDataDevLogResponseParser pageDataDevLogResponseParser = new PageDataDevLogResponseParser();
    public static final PageDataEventLogResponseParser pageDataEventLogResponseParser = new PageDataEventLogResponseParser();

    public static final class StdDataResponseParser implements ResponseParser<StdData> {
        @Override
        public StdData parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = JsonUtils.readValue(response.GetStringBody(), new TypeReference<StdData>() {});
                return stdData;
            } catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            } finally {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class SaveOpLogResponseParser implements ResponseParser<OpLog> {
        @Override
        public OpLog parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData<OpLog> stdData = JsonUtils.readValue(response.GetStringBody(), new TypeReference<StdData<OpLog>>() {});
                return stdData == null ? null : stdData.getData();
            } catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            } finally {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class SaveEventLogResponseParser implements ResponseParser<EventLog> {
        @Override
        public EventLog parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData<EventLog> stdData = JsonUtils.readValue(response.GetStringBody(), new TypeReference<StdData<EventLog>>() {});
                return stdData == null ? null : stdData.getData();
            } catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            } finally {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class SaveDevLogResponseParser implements ResponseParser<DevLog> {
        @Override
        public DevLog parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData<DevLog> stdData = JsonUtils.readValue(response.GetStringBody(), new TypeReference<StdData<DevLog>>() {});
                return stdData == null ? null : stdData.getData();
            } catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            } finally {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class PageDataOpLogResponseParser implements ResponseParser<PageData<OpLog>> {
        @Override
        public PageData<OpLog> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData<PageData<OpLog>> stdData = JsonUtils.readValue(response.GetStringBody(), new TypeReference<StdData<PageData<OpLog>>>() {});
                return stdData == null ? null : stdData.getData();
            } catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            } finally {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }
    public static final class PageDataDevLogResponseParser implements ResponseParser<PageData<DevLog>> {
        @Override
        public PageData<DevLog> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData<PageData<DevLog>> stdData = JsonUtils.readValue(response.GetStringBody(), new TypeReference<StdData<PageData<DevLog>>>() {});
                return stdData == null ? null : stdData.getData();
            } catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            } finally {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }
    public static final class PageDataEventLogResponseParser implements ResponseParser<PageData<EventLog>> {
        @Override
        public PageData<EventLog> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData<PageData<EventLog>> stdData = JsonUtils.readValue(response.GetStringBody(), new TypeReference<StdData<PageData<EventLog>>>() {});
                return stdData == null ? null : stdData.getData();
            } catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            } finally {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }
}
