package com.digiwin.dap.middleware.lmc.internal.model;


import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.HttpEntity;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A generic request that contains some basic request options, such as bucket
 * name, object key, custom headers, progress listener and so on.
 *
 * @author chenzhuang
 * @date 2021/4/23
 */
public class GenericRequest implements Serializable {

    private static final long serialVersionUID = 1013675993460827140L;
    private Map<String, String> headers = new LinkedHashMap<>();
    private long contentLength;

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public long getContentLength() {
        return contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public HttpEntity getEntity() {
        return EntityBuilder.create().build();
    }
}
