package com.digiwin.dap.middleware.lmc.internal.model;

import java.io.Serializable;

/**
 * 标准输出
 *
 * @author chenzhuang
 * @date 2020/3/5
 */
public class StdData<T> implements Serializable {

    private static final long serialVersionUID = 4426518373192275997L;
    private int code;
    private String message;
    private T data;
    private boolean success;

    public static final StdData<?> OK = new StdData<>(200, "success", true);

    public static final StdData<?> fail = new StdData<>(200, "success", true);

    public StdData() {
    }

    public StdData(boolean success) {
        this.success = success;
    }

    public StdData(int code, String message, boolean success) {
        this.code = code;
        this.message = message;
        this.success = success;
    }

    public static StdData<?> ok() {
        return OK;
    }

    public static <T> StdData<T> of(boolean success) {
        return new StdData<>(success);
    }

    public static <T> StdData<T> ofSuccess(T data) {
        StdData<T> stdData = new StdData<>(200, "success", true);
        stdData.setData(data);
        return stdData;
    }

    public static <T> StdData<T> ofFail(int code, String message) {
        return new StdData<>(code, message, false);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}
