package com.digiwin.dap.middleware.lmc.request;

import java.util.List;
import java.util.Map;

/**
 * 功能描述
 *
 * @author chenzhuang
 * @date 2021/5/14 13:34
 */
public class SaveCompareOpLog extends BaseOpLog{
    private static final long serialVersionUID = -6823973574731880364L;

    /** 原始json */
    private Map<String, Object> originJson;
    /** 修改json */
    private Map<String, Object> modifyJson;

    /**
     * 主键集合
     * 例如："primaryKeyList":[{"path":"","keyName":"sid"},{"path":"PurchaseModule","keyName":"id"}]
     */
    private List<Map<String, String>> primaryKeyList;
    /**
     * 关注字段名称集合
     * 例如："logFieldList":[{"fieldName":"displayName","displayName":"商品名称"},{"fieldName":"productName","displayName":"商品类别"},{"fieldName":"payRemark","displayName":"商品备注"}]
     */
    private List<Map<String, String>> logFieldList;

    public SaveCompareOpLog() {
    }

    public SaveCompareOpLog(Map<String, Object> originJson, Map<String, Object> modifyJson) {
        this.originJson = originJson;
        this.modifyJson = modifyJson;
    }

    public SaveCompareOpLog(List<Map<String, String>> primaryKeyList, List<Map<String, String>> logFieldList) {
        this.primaryKeyList = primaryKeyList;
        this.logFieldList = logFieldList;
    }

    public SaveCompareOpLog(Map<String, Object> originJson, Map<String, Object> modifyJson, List<Map<String, String>> primaryKeyList, List<Map<String, String>> logFieldList) {
        this.originJson = originJson;
        this.modifyJson = modifyJson;
        this.primaryKeyList = primaryKeyList;
        this.logFieldList = logFieldList;
    }

    public Map<String, Object> getOriginJson() {
        return originJson;
    }

    public void setOriginJson(Map<String, Object> originJson) {
        this.originJson = originJson;
    }

    public Map<String, Object> getModifyJson() {
        return modifyJson;
    }

    public void setModifyJson(Map<String, Object> modifyJson) {
        this.modifyJson = modifyJson;
    }

    public List<Map<String, String>> getPrimaryKeyList() {
        return primaryKeyList;
    }

    public void setPrimaryKeyList(List<Map<String, String>> primaryKeyList) {
        this.primaryKeyList = primaryKeyList;
    }

    public List<Map<String, String>> getLogFieldList() {
        return logFieldList;
    }

    public void setLogFieldList(List<Map<String, String>> logFieldList) {
        this.logFieldList = logFieldList;
    }
}
