/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.auth.AuthCache;
import com.digiwin.dap.middleware.lmc.common.auth.BasicAuthCache;
import com.digiwin.dap.middleware.lmc.common.comm.IdleConnectionReaper;
import com.digiwin.dap.middleware.lmc.http.client.ClientConfiguration;
import com.digiwin.dap.middleware.lmc.http.comm.HttpRequestFactory;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ServiceClient;
import com.digiwin.dap.middleware.lmc.http.utils.ExceptionFactory;
import com.digiwin.dap.middleware.lmc.http.utils.HttpUtil;
import com.digiwin.dap.middleware.lmc.http.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected CloseableHttpClient httpClient;
    protected PoolingHttpClientConnectionManager connectionManager;
    protected RequestConfig requestConfig;
    protected AuthCache authCache = new BasicAuthCache();
    private volatile String endpoint = "https://lmc-test.digiwincloud.com.cn";

    public DefaultServiceClient() {
        super(new ClientConfiguration());
        this.connectionManager = this.createHttpClientConnectionManager();
        this.httpClient = this.createHttpClient(this.connectionManager);
        this.requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.config.getConnectionTimeout())).setResponseTimeout(Timeout.ofMilliseconds((long)this.config.getSocketTimeout())).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)this.config.getConnectionRequestTimeout())).build();
    }

    @Override
    public ResponseMessage sendRequestCore(RequestMessage request) throws IOException {
        CloseableHttpResponse httpResponse;
        HttpUriRequestBase httpRequest = httpRequestFactory.createHttpRequest(request);
        HttpClientContext httpContext = this.createHttpContext();
        try {
            httpResponse = this.httpClient.execute((ClassicHttpRequest)httpRequest, (HttpContext)httpContext);
        }
        catch (IOException ex) {
            httpRequest.cancel();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    private static ResponseMessage buildResponse(RequestMessage request, CloseableHttpResponse httpResponse) throws IOException {
        ResponseMessage response = new ResponseMessage();
        response.setUrl(request.getEndpoint().toString());
        if (httpResponse.getCode() != 0) {
            response.setStatusCode(httpResponse.getCode());
        }
        if (httpResponse.getEntity() != null) {
            if (response.isSuccessful()) {
                response.setContent(httpResponse.getEntity().getContent());
            } else {
                DefaultServiceClient.readAndSetErrorResponse(httpResponse.getEntity().getContent(), response);
            }
        }
        for (Header header : httpResponse.getHeaders()) {
            if ("Content-Length".equalsIgnoreCase(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    private static void readAndSetErrorResponse(InputStream originalContent, ResponseMessage response) throws IOException {
        byte[] contentBytes = IOUtils.readStreamAsByteArray(originalContent);
        response.setErrorResponseAsString(new String(contentBytes));
        response.setContent(new ByteArrayInputStream(contentBytes));
    }

    private CloseableHttpClient createHttpClient(PoolingHttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).disableContentCompression().disableAutomaticRetries().build();
    }

    private PoolingHttpClientConnectionManager createHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(this.config.getMaxConnections());
        cm.setMaxTotal(this.config.getMaxConnections());
        cm.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)this.config.getSocketTimeout())).build());
        if (this.config.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.config.getIdleConnectionTime());
            IdleConnectionReaper.registerConnectionManager(cm);
        }
        return cm;
    }

    private HttpClientContext createHttpContext() {
        HttpClientContext ctx = HttpClientContext.create();
        ctx.setRequestConfig(this.requestConfig);
        return ctx;
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.close();
    }

    @Override
    public AuthCache getAuthCache() {
        return this.authCache;
    }

    @Override
    public void setAuthCache(String endpoint, String token) {
        this.endpoint = endpoint;
        this.authCache.put(endpoint, token);
    }
}

