/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.comm.HttpDeleteWithBody;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.http.client.HttpMethod;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import java.net.URI;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public HttpUriRequestBase createHttpRequest(RequestMessage request) {
        URI uri = request.getEndpoint();
        HttpMethod method = request.getMethod();
        Object httpRequest = switch (method) {
            case HttpMethod.POST -> {
                HttpPost post = new HttpPost(uri);
                if (request.getHttpEntity() != null) {
                    post.setEntity(request.getHttpEntity());
                }
                yield post;
            }
            case HttpMethod.PUT -> {
                HttpPut put = new HttpPut(uri);
                if (request.getHttpEntity() != null) {
                    put.setEntity(request.getHttpEntity());
                }
                yield put;
            }
            case HttpMethod.GET -> new HttpGet(uri);
            case HttpMethod.DELETE -> {
                if (request.getHttpEntity() != null) {
                    HttpDeleteWithBody delete = new HttpDeleteWithBody(uri);
                    delete.setEntity(request.getHttpEntity());
                    yield delete;
                }
                yield new HttpDelete(uri);
            }
            case HttpMethod.HEAD -> new HttpHead(uri);
            case HttpMethod.OPTIONS -> new HttpOptions(uri);
            default -> throw new ClientException("Unknown HTTP method name: " + String.valueOf((Object)method));
        };
        this.configureRequestHeaders(request, (HttpUriRequestBase)httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpUriRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), (Object)entry.getValue());
        }
        if (!httpRequest.containsHeader("Content-Type")) {
            httpRequest.addHeader("Content-Type", (Object)("application/x-www-form-urlencoded; charset=" + "utf-8".toLowerCase()));
        }
    }
}

