/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc;

import com.digiwin.dap.middleware.lmc.util.DocumentUtil;
import com.mongodb.client.MongoCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class LmcStartedListener
implements ApplicationListener<ApplicationStartedEvent> {
    @Autowired
    private MongoTemplate mongoTemplate;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.createDateIndex();
        }
    }

    private void createDateIndex() {
        MongoCollection statsDiskDetail = this.mongoTemplate.getCollection("stats_disk_detail");
        DocumentUtil.createIndex((MongoCollection)statsDiskDetail, (String)"queryTime", (Object)DocumentUtil.IndexType.ASC);
        MongoCollection crstatscenterEventlog = this.mongoTemplate.getCollection("crstatscenter_eventlog");
        DocumentUtil.createIndex((MongoCollection)crstatscenterEventlog, (String)"content.invokeTime", (Object)DocumentUtil.IndexType.ASC);
    }
}

