/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.enums.I18nError;
import com.digiwin.dap.middleware.lmc.domain.logsetting.action.ActionSettingDTO;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.logsetting.ActionSetting;
import com.digiwin.dap.middleware.lmc.repository.ActionSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1/logsetting"})
public class ActionSettingController {
    @Autowired
    private ActionSettingRepository actionSettingRepository;
    @Autowired
    private AppSettingRepository appSettingRepository;

    @PostMapping(value={"/actionsetting"})
    public ResponseEntity<?> saveAppSetting(@Validated @RequestBody ActionSettingDTO dto) {
        if (!this.appSettingRepository.existByAppId(dto.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.APP_SETTING_APP_NOT_EXISTED, new Object[]{dto.getAppId()});
        }
        if (this.actionSettingRepository.existByUnionKey(dto)) {
            throw new BusinessException((ErrorHandler)I18nError.APP_SETTING_OPERATION_TYPE_EXISTED, new Object[]{dto.getAppId(), dto.getModuleId(), dto.getActId(), dto.getOperationType()});
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)this.actionSettingRepository.insert((BaseEntity)dto.doForward())));
    }

    @PutMapping(value={"/actionsetting"})
    public StdData<?> updateActionSetting(@Validated @RequestBody ActionSettingDTO dto) {
        Assert.hasText((String)dto.getId(), (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ActionSetting old = (ActionSetting)this.actionSettingRepository.findById(dto.getId());
        if (null == old) {
            throw new BusinessException((ErrorHandler)I18nError.APP_SETTING_APP_NOT_EXISTED, new Object[]{dto.getId()});
        }
        dto.setAppId(old.getAppId());
        dto.setModuleId(old.getModuleId());
        dto.setActId(old.getActId());
        dto.setOperationType(old.getOperationType());
        ActionSetting actionSetting = (ActionSetting)dto.doForward();
        actionSetting.setId(UUID.fromString(dto.getId()));
        this.actionSettingRepository.update((BaseEntity)actionSetting);
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/actionsetting/{id}"})
    public ResponseEntity<?> deleteActionSetting(@PathVariable String id) {
        long delete = this.actionSettingRepository.deleteById(id);
        return ResponseEntity.ok((Object)StdData.ok((Object)delete));
    }

    @GetMapping(value={"/actionsetting/{id}"})
    public ResponseEntity<?> findActionSetting(@PathVariable String id) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.actionSettingRepository.findById(id)));
    }

    @GetMapping(value={"/actionsettings"})
    public ResponseEntity<?> findActionSettings(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        ActionSettingDTO dto = ActionSettingDTO.getSelf((String)params);
        Query query = new Query();
        if (!ObjectUtils.isEmpty((Object)dto.getAppId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)dto.getAppId()));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getModuleId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"moduleId").is((Object)dto.getModuleId()));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getActId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"actId").is((Object)dto.getActId()));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getOperationType())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"operationType").is((Object)dto.getOperationType()));
        }
        Map map = null;
        if (!ObjectUtils.isEmpty((Object)orders)) {
            try {
                map = (Map)JsonUtils.createObjectMapper().readValue(orders, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                throw new BusinessException(I18nError.FIELD_PARSING_FAILED.getMessage(new Object[]{"orders"}), (Throwable)e);
            }
        }
        PageData pageData = this.actionSettingRepository.findByPage(new Page(query, pageNum.intValue(), pageSize.intValue(), map));
        return ResponseEntity.ok((Object)StdData.ok((Object)pageData));
    }
}

