/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.LmcConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.I18nError;
import com.digiwin.dap.middleware.lmc.constant.enums.SaveDaysEnum;
import com.digiwin.dap.middleware.lmc.domain.logsetting.AppSettingDTO;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.repository.ActionSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.service.business.AppSettingService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1/logsetting"})
public class AppSettingController {
    private static final Logger logger = LoggerFactory.getLogger(AppSettingController.class);
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private ActionSettingRepository actionSettingRepository;
    @Autowired
    private AppSettingService appSettingService;

    @PostMapping(value={"/app"})
    public ResponseEntity<?> saveAppSetting(@RequestBody AppSettingDTO dto) {
        if (ObjectUtils.isEmpty((Object)dto.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.FIELD_IS_EMPTY, new Object[]{"appId"});
        }
        if (this.appSettingRepository.existByAppId(dto.getAppId())) {
            throw new BusinessException(MessageFormat.format("app: {0} \u5df2\u5b58\u5728\uff01", dto.getAppId()));
        }
        dto.setChangeLogSaveDays(Optional.ofNullable(dto.getChangeLogSaveDays()).orElse(SaveDaysEnum.OPLOG_SAVE_DAYS_30.getDays()));
        dto.setEventLogSaveDays(Optional.ofNullable(dto.getEventLogSaveDays()).orElse(SaveDaysEnum.EVENTLOG_SAVE_DAYS_30.getDays()));
        dto.setDevLogSaveDays(Optional.ofNullable(dto.getDevLogSaveDays()).orElse(SaveDaysEnum.DEVLOG_SAVE_DAYS_7.getDays()));
        dto.setEsChangeLogSaveDays(Optional.ofNullable(dto.getEsChangeLogSaveDays()).orElse(SaveDaysEnum.ES_OPLOG_SAVE_DAYS.getDays()));
        dto.setEsEventLogSaveDays(Optional.ofNullable(dto.getEsEventLogSaveDays()).orElse(SaveDaysEnum.ES_EVENTLOG_SAVE_DAYS.getDays()));
        dto.setEsDevLogSaveDays(Optional.ofNullable(dto.getEsDevLogSaveDays()).orElse(SaveDaysEnum.ES_DEVLOG_SAVE_DAYS.getDays()));
        if (LmcConstant.MIDDLEWARE_BACKEND.contains(dto.getAppId())) {
            dto.setIfLocal(Boolean.TRUE);
        } else {
            dto.setIfLocal(Boolean.FALSE);
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)this.appSettingRepository.insert((BaseEntity)dto.doForward())));
    }

    @PutMapping(value={"/app"})
    public StdData<?> appSetting(@RequestBody AppSettingDTO dto) {
        Assert.hasText((String)dto.getId(), (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AppSetting app = (AppSetting)this.appSettingRepository.findById(dto.getId());
        if (null == app) {
            throw new BusinessException((ErrorHandler)I18nError.APP_SETTING_APP_NOT_EXISTED, new Object[]{dto.getId()});
        }
        app.setAppName(dto.getAppName());
        app.setChangeLogSaveDays(Optional.ofNullable(dto.getChangeLogSaveDays()).orElse(Optional.ofNullable(app.getChangeLogSaveDays()).orElse(SaveDaysEnum.OPLOG_SAVE_DAYS_30.getDays())));
        app.setEventLogSaveDays(Optional.ofNullable(dto.getEventLogSaveDays()).orElse(Optional.ofNullable(app.getEventLogSaveDays()).orElse(SaveDaysEnum.EVENTLOG_SAVE_DAYS_30.getDays())));
        app.setDevLogSaveDays(Optional.ofNullable(dto.getDevLogSaveDays()).orElse(Optional.ofNullable(app.getDevLogSaveDays()).orElse(SaveDaysEnum.DEVLOG_SAVE_DAYS_7.getDays())));
        app.setEsChangeLogSaveDays(Optional.ofNullable(dto.getEsChangeLogSaveDays()).orElse(Optional.ofNullable(app.getEsChangeLogSaveDays()).orElse(SaveDaysEnum.ES_OPLOG_SAVE_DAYS.getDays())));
        app.setEsEventLogSaveDays(Optional.ofNullable(dto.getEsEventLogSaveDays()).orElse(Optional.ofNullable(app.getEsEventLogSaveDays()).orElse(SaveDaysEnum.ES_EVENTLOG_SAVE_DAYS.getDays())));
        app.setEsDevLogSaveDays(Optional.ofNullable(dto.getEsDevLogSaveDays()).orElse(Optional.ofNullable(app.getEsDevLogSaveDays()).orElse(SaveDaysEnum.ES_DEVLOG_SAVE_DAYS.getDays())));
        app.setCloudWebsite(dto.getCloudWebsite());
        if (dto.getIfLocal() != null) {
            app.setIfLocal(dto.getIfLocal());
        }
        this.appSettingRepository.update((BaseEntity)app);
        return StdData.ok().build();
    }

    @GetMapping(value={"/app/{id}"})
    public ResponseEntity<?> getAppSettingById(@PathVariable String id) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.appSettingRepository.findById(UUID.fromString(id))));
    }

    @DeleteMapping(value={"/app/{id}"})
    public StdData<?> deleteAppSettingById(@PathVariable String id) {
        AppSetting app = (AppSetting)this.appSettingRepository.findById(id);
        if (app != null) {
            this.appSettingService.deleteByAppId(app.getAppId());
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/apps"})
    public ResponseEntity<?> getAppSettings(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        AppSettingDTO dto = AppSettingDTO.getSelf((String)params);
        Query query = new Query();
        if (!ObjectUtils.isEmpty((Object)dto.getAppId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)dto.getAppId()));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getAppName())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appName").regex(Pattern.quote(dto.getAppName())));
        }
        Map map = null;
        if (!ObjectUtils.isEmpty((Object)orders)) {
            try {
                map = (Map)JsonUtils.createObjectMapper().readValue(orders, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                throw new BusinessException(I18nError.FIELD_PARSING_FAILED.getMessage(new Object[]{"orders"}), (Throwable)e);
            }
        }
        PageData pageData = this.appSettingRepository.findByPage(new Page(query, pageNum.intValue(), pageSize.intValue(), map));
        return ResponseEntity.ok((Object)StdData.ok((Object)pageData));
    }

    @GetMapping(value={"/apps/exclude"})
    public ResponseEntity<?> getAppSettingsExcludeDataPolicy(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        AppSettingDTO dto = AppSettingDTO.getSelf((String)params);
        Query query = new Query();
        if (!ObjectUtils.isEmpty((Object)dto.getAppId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)dto.getAppId()));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getAppName())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appName").regex(Pattern.quote(dto.getAppName())));
        }
        Map map = null;
        if (!ObjectUtils.isEmpty((Object)orders)) {
            try {
                map = (Map)JsonUtils.createObjectMapper().readValue(orders, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                throw new BusinessException(I18nError.FIELD_PARSING_FAILED.getMessage(new Object[]{"orders"}), (Throwable)e);
            }
        }
        PageData pageData = this.appSettingRepository.findByPageExcludeDataPolicy(new Page(query, pageNum.intValue(), pageSize.intValue(), map));
        return ResponseEntity.ok((Object)StdData.ok((Object)pageData));
    }
}

