/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.I18nError;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.PageDTO;
import com.digiwin.dap.middleware.lmc.domain.PageQuery;
import com.digiwin.dap.middleware.lmc.domain.devlog.DevLogDTO;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.devlog.DevLog;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.DevLogRepository;
import com.digiwin.dap.middleware.lmc.service.business.AppSettingService;
import com.digiwin.dap.middleware.lmc.service.excel.ExcelService;
import com.digiwin.dap.middleware.lmc.support.remote.thirdparty.RemoteLmcService;
import com.digiwin.dap.middleware.lmc.support.remote.thirdparty.RemotePinpiontService;
import com.digiwin.dap.middleware.lmc.util.BaseEntityUtils;
import com.digiwin.dap.middleware.lmc.util.ObjectUtil;
import com.digiwin.dap.middleware.util.EnvUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
@RequestMapping(value={"/api/lmc/v1"})
public class DevLogController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevLogController.class);
    @Autowired
    private DevLogRepository devLogRepository;
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private AppSettingService appSettingService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ExcelService excelService;
    @Autowired
    private RemotePinpiontService remotePinpiontService;
    @Autowired
    private RemoteLmcService remoteLmcService;

    @PostMapping(value={"/devlog"})
    public StdData<?> saveDevLog(@RequestBody @Validated DevLog devLog) {
        this.appSettingService.checkAndSaveDefaultAppSetting(devLog.getAppId());
        BaseEntityUtils.setCreateFields((BaseEntity)devLog);
        this.devLogRepository.mixInsertAsync((BaseEntity)devLog, devLog.getAppId() + "_devlog");
        return StdData.ok().build();
    }

    @PostMapping(value={"/devlog/sync"})
    public ResponseEntity<?> saveDevLogSync(@RequestBody @Validated DevLog devLog) {
        this.appSettingService.checkAndSaveDefaultAppSetting(devLog.getAppId());
        DevLog insert = (DevLog)this.devLogRepository.mixInsert((BaseEntity)devLog, devLog.getAppId() + "_devlog");
        return ResponseEntity.ok((Object)StdData.ok((Object)insert));
    }

    @PostMapping(value={"/devlog/batch"})
    public StdData<?> saveDevLogs(@RequestBody @Validated List<DevLog> devLogs) {
        for (DevLog devLog : devLogs) {
            this.appSettingService.checkAndSaveDefaultAppSetting(devLog.getAppId());
            BaseEntityUtils.setCreateFields((BaseEntity)devLog);
        }
        devLogs.stream().collect(Collectors.groupingBy(DevLog::getAppId)).forEach((k, v) -> this.devLogRepository.mixInsertAllAsync((Collection)v, k + "_devlog"));
        return StdData.ok().build();
    }

    @PostMapping(value={"/devlog/batch/sync"})
    public StdData<?> saveDevLogsSync(@RequestBody @Validated List<DevLog> devLogs) {
        for (DevLog devLog : devLogs) {
            this.appSettingService.checkAndSaveDefaultAppSetting(devLog.getAppId());
        }
        devLogs.stream().collect(Collectors.groupingBy(DevLog::getAppId)).forEach((k, v) -> this.devLogRepository.mixInsertAll((Collection)v, k + "_devlog"));
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/devlog/appid/{appId}/{id}"})
    public ResponseEntity<?> delete(@PathVariable String appId, @PathVariable String id, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long delete = this.devLogRepository.deleteById(id, appId + "_devlog");
        return ResponseEntity.ok((Object)StdData.ok((Object)delete));
    }

    @GetMapping(value={"/devlogs"})
    public ResponseEntity<?> findDevLogs(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"time\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        DevLogDTO dto = DevLogDTO.getSelf((String)params);
        PageDTO pageDTO = this.getPageDTO(pageNum, pageSize, orders, dto, this.envProperties.ifEs(dto.getEs()));
        PageData pageData = this.devLogRepository.mixFindByPage(pageDTO);
        return ResponseEntity.ok((Object)StdData.ok((Object)this.fillAppName(pageData)));
    }

    @PostMapping(value={"/devlogs/cloud/area/user"})
    public ResponseEntity<?> listCloudAreaDevLogs(@RequestBody PageQuery<DevLogDTO> pageQuery, HttpServletRequest request) {
        DevLogDTO dto = (DevLogDTO)pageQuery.getParams();
        Assert.notNull((Object)dto, (String)"\u67e5\u8be2\u53c2\u6570params\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)dto.getSourceCloudArea(), (String)"\u6765\u6e90\u4e91\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)dto.getUserToken(), (String)"\u7528\u6237token\u4e0d\u80fd\u4e3a\u7a7a");
        pageQuery.setOrderBy(Optional.ofNullable(pageQuery.getOrderBy()).filter(StringUtils::hasLength).orElse("{\"time\":-1}"));
        DeployAreaEnum areaEnum = DeployAreaEnum.get((String)dto.getSourceCloudArea());
        request.setAttribute("digi-middleware-source-auth-user-token", (Object)dto.getUserToken());
        request.setAttribute("digi-middleware-source-deploy-area", (Object)areaEnum);
        PageDTO pageDTO = this.getPageDTO(pageQuery.getPageNum(), pageQuery.getPageSize(), pageQuery.getOrderBy(), dto, this.envProperties.ifEs(dto.getEs()));
        PageData pageData = this.devLogRepository.mixFindByPage(pageDTO);
        return ResponseEntity.ok((Object)StdData.ok((Object)this.fillAppName(pageData)));
    }

    @GetMapping(value={"/devlog/es/search"})
    public ResponseEntity<?> findDevLogsElasticsearch(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"time\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        DevLogDTO dto = DevLogDTO.getSelf((String)params);
        PageDTO pageDTO = this.getPageDTO(pageNum, pageSize, orders, dto, true);
        PageData pageData = this.devLogRepository.queryEsForPageExcludePolicy(pageDTO.getEsParams(), pageDTO.getLogTypeEnum());
        return ResponseEntity.ok((Object)StdData.ok((Object)pageData));
    }

    @GetMapping(value={"/devlog/export"})
    public void exportDevLogs(HttpServletResponse response, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="3000") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"time\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        DevLogDTO dto = DevLogDTO.getSelf((String)params);
        PageDTO pageDTO = this.getPageDTO(pageNum, pageSize, orders, dto, this.envProperties.ifEs(dto.getEs()));
        PageData pageData = this.devLogRepository.mixFindByPage(pageDTO);
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            pageData.getList().forEach(x -> builder.insert(0, x.getLog()));
        }
        String fileName = "logs-from-" + Optional.ofNullable(dto.getAppId()).orElse("devlog").toLowerCase() + "-" + DateConstant.DATE_TIME_FORMATTER_SMALL.format(LocalDateTime.now());
        this.excelService.exportTxt(response, builder.toString(), fileName);
    }

    @GetMapping(value={"/devlog/traceId/{traceId}"})
    public StdData<?> getTraceIdUrl(@PathVariable String traceId) {
        if (!traceId.contains("^")) {
            return StdData.ok().build();
        }
        return StdData.ok((Object)this.remotePinpiontService.getPinpointUrl(traceId));
    }

    @GetMapping(value={"/devlog/redirect/mmc"})
    public ModelAndView redirectMmc(@RequestParam(name="transactionId", required=false) String transactionId, @RequestParam(name="spanId", required=false) String spanId, @RequestParam(name="applicationName", required=false) String applicationName, @RequestParam(value="time", required=false) Long time) {
        if (ObjectUtils.isEmpty((Object)transactionId) || !transactionId.contains("^") || !applicationName.contains("_")) {
            return null;
        }
        String[] applicationNameArr = applicationName.split("_");
        if (applicationNameArr.length < 3) {
            return null;
        }
        String lmcUri = this.getLmcUri(applicationNameArr);
        if (ObjectUtils.isEmpty((Object)lmcUri)) {
            return null;
        }
        String mmcUri = lmcUri.equals(EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.DevelopDev)) ? this.envProperties.getDevMmcUri() : lmcUri.replace("lmc", "mmc");
        String appName = applicationNameArr[2].split("-")[0];
        List appSettingList = this.remoteLmcService.getAppSettings(lmcUri);
        String appId = appSettingList.stream().map(AppSetting::getAppId).filter(appName::equalsIgnoreCase).findAny().orElse(appName);
        String mmcDevLogsUrl = mmcUri + String.format("/logger-manager-center/systems-logger?appId=%s&traceId=%s", appId, transactionId);
        return new ModelAndView((View)new RedirectView(mmcDevLogsUrl));
    }

    private PageDTO<DevLog> getPageDTO(Integer pageNum, Integer pageSize, String orders, DevLogDTO dto, boolean all) {
        if (!all && ObjectUtils.isEmpty((Object)dto.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.FIELD_IS_EMPTY, new Object[]{"appId"});
        }
        ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
        Query query = new Query();
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("from", (pageNum - 1) * pageSize);
        pageMap.put("size", pageSize);
        HashMap queryMap = new HashMap();
        HashMap boolMap = new HashMap();
        queryMap.put("bool", boolMap);
        ArrayList<Map<String, Map<String, Object>>> filterList = new ArrayList<Map<String, Map<String, Object>>>();
        if (!ObjectUtils.isEmpty((Object)dto.getAppId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)dto.getAppId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("appId", dto.getAppId())));
        }
        ArrayList<Map<String, Map<String, String>>> mustList = new ArrayList<Map<String, Map<String, String>>>();
        if (!ObjectUtils.isEmpty((Object)dto.getLevel())) {
            andCrtList.add(Criteria.where((String)"level").is((Object)dto.getLevel()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("level", dto.getLevel())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTraceId())) {
            andCrtList.add(Criteria.where((String)"traceId").is((Object)dto.getTraceId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("traceId", dto.getTraceId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getSpanId())) {
            andCrtList.add(Criteria.where((String)"spanId").is((Object)dto.getSpanId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("spanId", dto.getSpanId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getNodeType())) {
            andCrtList.add(Criteria.where((String)"nodeType").is((Object)dto.getNodeType()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("nodeType", dto.getNodeType())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getType())) {
            andCrtList.add(Criteria.where((String)"type").is((Object)dto.getType()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("type", dto.getType())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getNodeId())) {
            andCrtList.add(Criteria.where((String)"nodeId").is((Object)dto.getNodeId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("nodeId", dto.getNodeId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCurrentNodeSpanId())) {
            andCrtList.add(Criteria.where((String)"currentNodeSpanId").is((Object)dto.getCurrentNodeSpanId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("currentNodeSpanId", dto.getCurrentNodeSpanId())));
        }
        this.addTimeConsumeFilters(dto, andCrtList, filterList);
        this.addParamSizeFilters(dto, andCrtList, filterList);
        if (!ObjectUtils.isEmpty((Object)dto.getAppender())) {
            andCrtList.add(Criteria.where((String)"appender").regex(Pattern.quote(dto.getAppender())));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("appender", dto.getAppender())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLoggerName())) {
            andCrtList.add(Criteria.where((String)"loggerName").regex(Pattern.quote(dto.getLoggerName())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("loggerName", dto.getLoggerName())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            andCrtList.add(Criteria.where((String)"tenantId").is((Object)dto.getTenantId()));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", dto.getTenantId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantContent())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tenantId").regex(Pattern.quote(dto.getTenantContent())), Criteria.where((String)"tenantName").regex(Pattern.quote(dto.getTenantContent()))}));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantName", dto.getTenantContent())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getMessage())) {
            andCrtList.add(Criteria.where((String)"message").regex(Pattern.quote(dto.getMessage())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("message", dto.getMessage())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getMessages())) {
            for (String string : dto.getMessages()) {
                andCrtList.add(Criteria.where((String)"message").regex(Pattern.quote(string)));
                mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("message", string)));
            }
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLog())) {
            andCrtList.add(Criteria.where((String)"log").regex(Pattern.quote(dto.getLog())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getSource())) {
            andCrtList.add(Criteria.where((String)"source").regex(Pattern.quote(dto.getSource())));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("source", dto.getSource())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getIds())) {
            andCrtList.add(Criteria.where((String)"_id").in((Collection)dto.getIds().stream().map(UUID::fromString).collect(Collectors.toList())));
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("id", dto.getIds())));
        }
        this.addTimeFilters(dto, andCrtList, filterList);
        if (!CollectionUtils.isEmpty((Map)dto.getCustomContent())) {
            for (Map.Entry entry2 : dto.getCustomContent().entrySet()) {
                andCrtList.add(Criteria.where((String)("customContent." + (String)entry2.getKey())).is(entry2.getValue()));
                filterList.add(Collections.singletonMap("term", Collections.singletonMap("customContent." + (String)entry2.getKey(), entry2.getValue())));
            }
        }
        if (StringUtils.hasLength((String)dto.getThread())) {
            andCrtList.add(Criteria.where((String)"thread").is((Object)dto.getThread()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("thread", dto.getThread())));
        }
        this.esFilter(dto, filterList);
        Map orderMap = new HashMap();
        if (!ObjectUtils.isEmpty((Object)orders)) {
            try {
                orderMap = (Map)JsonUtils.createObjectMapper().readValue(orders, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException iOException) {
                throw new BusinessException(I18nError.FIELD_PARSING_FAILED.getMessage(new Object[]{"orders"}), (Throwable)iOException);
            }
        }
        List list = orderMap.entrySet().stream().map(entry -> Collections.singletonMap(entry.getKey(), Objects.equals(entry.getValue(), 1) ? "asc" : "desc")).collect(Collectors.toList());
        pageMap.put("sort", list);
        if (!andCrtList.isEmpty()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
        }
        query = ObjectUtil.query((Query)query, (Map)dto.getRegexFilters(), (Map)dto.getEqFilters(), (Map)dto.getGteFilters(), (Map)dto.getLteFilters(), (Map)dto.getInFilters());
        if (!filterList.isEmpty()) {
            boolMap.put("filter", filterList);
        }
        if (!mustList.isEmpty()) {
            boolMap.put("must", mustList);
        }
        pageMap.put("query", queryMap);
        return new PageDTO(pageMap, new Page(query, pageNum.intValue(), pageSize.intValue(), orderMap), dto.getEs(), dto.getAppId(), LogTypeEnum.DEV_LOG);
    }

    private void addTimeFilters(DevLogDTO dto, List<Criteria> andCrtList, List<Map<String, Object>> filterList) {
        HashMap<String, String> timeMap = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object)dto.getTimeStart())) {
            andCrtList.add(Criteria.where((String)"time").gte((Object)dto.getTimeStart()));
            timeMap.put("gte", dto.getTimeStart() + ".000");
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTimeEnd())) {
            andCrtList.add(Criteria.where((String)"time").lte((Object)dto.getTimeEnd()));
            timeMap.put("lte", dto.getTimeEnd() + ".999");
        }
        if (!timeMap.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("time", timeMap)));
        }
    }

    private void addTimeConsumeFilters(DevLogDTO dto, List<Criteria> andCrtList, List<Map<String, Object>> filterList) {
        HashMap<String, Long> timeConsumeMap = new HashMap<String, Long>();
        if (!ObjectUtils.isEmpty((Object)dto.getTimeConsumeStart())) {
            andCrtList.add(Criteria.where((String)"timeConsume").gte((Object)dto.getTimeConsumeStart()));
            timeConsumeMap.put("gte", dto.getTimeConsumeStart());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTimeConsumeEnd())) {
            andCrtList.add(Criteria.where((String)"timeConsume").lte((Object)dto.getTimeConsumeEnd()));
            timeConsumeMap.put("lte", dto.getTimeConsumeEnd());
        }
        if (!timeConsumeMap.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("timeConsume", timeConsumeMap)));
        }
    }

    private void addParamSizeFilters(DevLogDTO dto, List<Criteria> andCrtList, List<Map<String, Object>> filterList) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (!ObjectUtils.isEmpty((Object)dto.getParamSizeStart())) {
            andCrtList.add(Criteria.where((String)"paramSize").gte((Object)dto.getParamSizeStart()));
            map.put("gte", dto.getParamSizeStart());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getParamSizeEnd())) {
            andCrtList.add(Criteria.where((String)"paramSize").lte((Object)dto.getParamSizeEnd()));
            map.put("lte", dto.getParamSizeEnd());
        }
        if (!map.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("paramSize", map)));
        }
    }

    private void esFilter(DevLogDTO dto, List<Map<String, Object>> filterList) {
        Map map;
        Map map2;
        Map map3;
        Map eqFilters;
        Map regexFilters = dto.getRegexFilters();
        if (!CollectionUtils.isEmpty((Map)regexFilters)) {
            for (Map.Entry entry : regexFilters.entrySet()) {
                filterList.add(Collections.singletonMap("match_phrase", Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(eqFilters = dto.getEqFilters()))) {
            for (Map.Entry entry : eqFilters.entrySet()) {
                filterList.add(Collections.singletonMap("term", Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map3 = dto.getGteFilters()))) {
            for (Map.Entry entry : map3.entrySet()) {
                HashMap hashMap = new HashMap();
                hashMap.put("gte", entry.getValue());
                filterList.add(Collections.singletonMap("range", Collections.singletonMap(entry.getKey(), hashMap)));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map2 = dto.getLteFilters()))) {
            for (Map.Entry entry : map2.entrySet()) {
                HashMap lteMap = new HashMap();
                lteMap.put("lte", entry.getValue());
                filterList.add(Collections.singletonMap("range", Collections.singletonMap(entry.getKey(), lteMap)));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map = dto.getInFilters()))) {
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof List) {
                    filterList.add(Collections.singletonMap("terms", Collections.singletonMap(entry.getKey(), (List)entry.getValue())));
                    continue;
                }
                filterList.add(Collections.singletonMap("terms", Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
    }

    private String getLmcUri(String[] applicationNameArr) {
        String lmcUri = "";
        String cloud = applicationNameArr[0].toLowerCase();
        String environment = applicationNameArr[1].toLowerCase();
        if (cloud.contains("dev")) {
            lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.DevelopDev);
        } else if (cloud.contains("ali")) {
            switch (environment) {
                case "paas": {
                    lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.AliyunPaas);
                    break;
                }
                case "test": {
                    lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.AliyunTest);
                    break;
                }
                case "prod": {
                    lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.AliyunProd);
                    break;
                }
            }
        } else if (cloud.contains("azure")) {
            if (environment.equals("test")) {
                lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.AzureTest);
            } else if (environment.equals("prod")) {
                lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.AzureProd);
            }
        } else if (cloud.contains("hw") || cloud.contains("huawei")) {
            if (environment.equals("test")) {
                lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.HuaweiTest);
            } else if (environment.equals("prod")) {
                lmcUri = EnvUtils.getUri((CommonCode)CommonCode.LMC, (DeployAreaEnum)DeployAreaEnum.HuaweiProd);
            }
        }
        return lmcUri;
    }

    private PageData<DevLog> fillAppName(PageData<DevLog> pageData) {
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            Set appIdList = pageData.getList().stream().map(DevLog::getAppId).collect(Collectors.toSet());
            List appList = this.appSettingRepository.findAll(new Query((CriteriaDefinition)Criteria.where((String)"appId").in(appIdList)));
            if (!appList.isEmpty()) {
                Map<String, String> appMap = appList.stream().collect(Collectors.toMap(AppSetting::getAppId, AppSetting::getAppName, (k1, k2) -> k1));
                pageData.getList().stream().filter(devLog -> !StringUtils.hasLength((String)devLog.getAppName())).forEach(devLog -> devLog.setAppName((String)appMap.get(devLog.getAppId())));
            }
        }
        return pageData;
    }
}

