/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.lmc.config.ElasticsearchConfiguration;
import com.digiwin.dap.middleware.lmc.domain.elasticsearch.ExecuteDTO;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.util.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1/elasticsearch"})
public class ElasticsearchController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchController.class);
    private static final String INDEX_MAPPINGS_NODE = "indexParam.mappings";
    private static final String INDEX_SETTINGS_NODE = "indexParam.settings";
    private static final String INDEX_ALIAS_NODE = "indexParam.aliases";
    private static final String REFRESH_INTERVAL = "30s";
    @Autowired
    private IElasticsearchService elasticsearchService;
    @Autowired
    private ElasticsearchConfiguration elasticsearchConfiguration;

    @PostMapping(value={"/execute"})
    public ResponseEntity<?> executeDsl(@Validated @RequestBody ExecuteDTO dto) {
        LOGGER.info("{} \u6267\u884cDSL {}", (Object)UserUtils.getUserId(), (Object)dto);
        String responseBody = this.elasticsearchService.executeDsl(dto.getDslMap(), dto.getMethod(), dto.getEndpoint());
        return ResponseEntity.ok((Object)StdData.ok((Object)responseBody));
    }

    @DeleteMapping(value={"/deleteIndexTemplate"})
    public ResponseEntity<?> deleteIndexTemplate(@RequestParam(value="templateName") String templateName) {
        this.elasticsearchService.deleteIndexTemplate(templateName);
        return ResponseEntity.ok((Object)StdData.ok(null));
    }

    @DeleteMapping(value={"/deleteIndex"})
    public ResponseEntity<?> deleteIndex(@RequestParam(value="indexName") String indexName) {
        this.elasticsearchService.deleteIndex(new String[]{indexName});
        return ResponseEntity.ok((Object)StdData.ok(null));
    }

    @GetMapping(value={"/init"})
    public ResponseEntity<?> init() {
        return null;
    }
}

