/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.service.LogLevelService;
import com.digiwin.dap.middleware.lmc.service.business.AppSettingService;
import com.digiwin.dap.middleware.lmc.service.impl.LogLevelServiceImpl;
import com.digiwin.dap.middleware.lmc.support.remote.thirdparty.RemotePinpiontService;
import com.digiwin.dap.middleware.lmc.support.schedule.ScheduleTaskService;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EnvController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvController.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ScheduleTaskService scheduleTaskService;
    @Autowired
    private AppSettingService appSettingService;
    @Autowired
    private RemotePinpiontService remotePinpiontService;
    @Autowired
    private MongoTemplate mongoTemplate;
    private static LogLevelService logLevelService = LogLevelServiceImpl.logLevelInstance();

    @GetMapping(value={"/"})
    public ResponseEntity<?> home() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("version", this.envProperties.getVersion());
        map.put("build-time", this.envProperties.getBuildTime());
        map.put("server-time", DateConstant.DATE_TIME_FORMATTER.format(LocalDateTime.now()));
        map.put("profiles-active", this.envProperties.getActive());
        map.put("deploy-area", this.envProperties.getDeployArea());
        return ResponseEntity.ok(map);
    }

    @RequestMapping(value={"/api/lmc/v1/env/health"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<?> health() {
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @GetMapping(value={"/api/lmc/v1/env", "/api/lmc/v2/env"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getRuntimeEnv() {
        this.envProperties.refresh();
        return ResponseEntity.ok((Object)this.envProperties);
    }

    @GetMapping(value={"/api/lmc/v1/env/log/es/enable"})
    public ResponseEntity<?> getLogEsEnabled() {
        return ResponseEntity.ok(Collections.singletonMap("logESEnabled", this.envProperties.getLogESEnabled()));
    }

    @PutMapping(value={"/api/lmc/v1/env/mongo/{mongoFlag}"})
    public ResponseEntity modifyMongoFlag(@PathVariable String mongoFlag) {
        this.envProperties.setLogMongoDBEnabled(Boolean.valueOf(mongoFlag));
        return ResponseEntity.ok((Object)this.envProperties.getLogMongoDBEnabled());
    }

    @GetMapping(value={"/api/lmc/v1/log"})
    public ResponseEntity<?> logLevel() {
        String log4j2Level = logLevelService.getLogLevel();
        return ResponseEntity.ok((Object)StdData.ok((Object)log4j2Level));
    }

    @PutMapping(value={"/api/lmc/v1/log/{logLevel}"})
    public StdData<?> updateLogLevel(@PathVariable String logLevel) {
        String log4j2Level = logLevelService.updateLogLevel(logLevel);
        return StdData.ok((Object)log4j2Level);
    }

    @PostMapping(value={"/api/lmc/v1/index/flush"})
    public StdData<?> createIndex() {
        this.appSettingService.createIndex();
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/lmc/v1/log/expired/remove"})
    public StdData<?> deleteLogs() {
        this.scheduleTaskService.deleteLogs();
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/lmc/v1/log/es/expired/remove"})
    public StdData<?> deleteEsLogs() {
        this.scheduleTaskService.deleteEsByDays();
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/lmc/v1/logsetting/log/total"})
    public StdData<Map<String, Object>> getLogs() {
        Map logsCountMap = this.appSettingService.getLogsCount();
        return StdData.ok((Object)logsCountMap);
    }

    @PostMapping(value={"/api/lmc/v1/logsetting/log/total/email"})
    public StdData<?> getLogsScheduleTask() {
        this.scheduleTaskService.getLogsCount();
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/lmc/v1/test/invoke/scheduleTask/{methodName}"})
    public ResponseEntity<?> invokeScheduleTask(@PathVariable String methodName) {
        try {
            Method method = this.scheduleTaskService.getClass().getMethod(methodName, new Class[0]);
            method.invoke((Object)this.scheduleTaskService, new Object[0]);
            return ResponseEntity.ok((Object)"ok");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("\u8c03\u7528\u5931\u8d25: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/api/lmc/v1/devlog/cache/clear"})
    public StdData<?> celarTraceIdCache() {
        this.remotePinpiontService.clearTimedCache();
        this.appSettingService.deleteAllCache();
        return StdData.ok((Object)"\u6e05\u7406\u7f13\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"/api/lmc/v1/{collectionName}/search"})
    public StdData<?> getLogByIds(@PathVariable String collectionName, @RequestBody List<String> ids) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)ids.stream().map(UUID::fromString).collect(Collectors.toList())));
        List mapList = this.mongoTemplate.find(query, Map.class, collectionName);
        return StdData.ok((Object)mapList);
    }
}

