/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.lmc.domain.esplog.CreateEspLogDTO;
import com.digiwin.dap.middleware.lmc.domain.esplog.CreateEspLogRequest;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogAggregationDTO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogAggregationRequest;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogDetailsVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogIncludeChainInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspProductVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspStateCodeVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.PageEspLogRequest;
import com.digiwin.dap.middleware.lmc.domain.esplog.PageEspLogVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.PageQueryEspLogDTO;
import com.digiwin.dap.middleware.lmc.domain.excel.EspLogExcelVO;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspProd;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspProdListResponse;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspStateCodeResponse;
import com.digiwin.dap.middleware.lmc.service.esp.log.IEspLogService;
import com.digiwin.dap.middleware.lmc.service.excel.ExcelService;
import com.digiwin.dap.middleware.lmc.support.remote.IEspService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1/esp/log/"})
public class EspLogController {
    @Autowired
    private IEspLogService espLogService;
    @Autowired
    private IEspService espService;
    @Autowired
    private ExcelService excelService;

    @PostMapping(value={"/exchange/create"})
    public StdData<?> createEspLog(@RequestBody CreateEspLogRequest request) {
        this.espLogService.saveEspLog(this.buildCreateEspLogDTO(request));
        return StdData.ok(null);
    }

    @PostMapping(value={"/exchange/batch/create"})
    public StdData<?> batchCreateEspLog(@RequestBody List<CreateEspLogRequest> requestList) {
        if (CollectionUtils.isEmpty(requestList)) {
            return StdData.ok().build();
        }
        List createEspLogDTOList = requestList.stream().map(arg_0 -> this.buildCreateEspLogDTO(arg_0)).collect(Collectors.toList());
        this.espLogService.batchSaveEspLog(createEspLogDTOList);
        return StdData.ok().build();
    }

    @PostMapping(value={"/list/product/search"})
    public StdData<?> getProdList() {
        EspProdListResponse espProdListResponse = this.espService.getProdList();
        if (CollectionUtils.isEmpty((Collection)espProdListResponse.getProdList())) {
            return StdData.ok().build();
        }
        return StdData.ok(espProdListResponse.getProdList().stream().collect(Collectors.toMap(EspProd::getName, Function.identity(), (existing, replacement) -> existing)).values().stream().map(arg_0 -> this.buildEspProductVO(arg_0)).collect(Collectors.toList()));
    }

    @PostMapping(value={"/list/state/code/search"})
    public StdData<?> getStateCodes() {
        List espStateCodeResponseList = this.espService.getStateCodes();
        if (CollectionUtils.isEmpty((Collection)espStateCodeResponseList)) {
            return StdData.ok().build();
        }
        return StdData.ok(espStateCodeResponseList.stream().map(arg_0 -> this.buildEspStateCodeVO(arg_0)).collect(Collectors.toList()));
    }

    @PostMapping(value={"/page/search"})
    public StdData<?> pageEspLog(@RequestBody PageEspLogRequest request) {
        PageData pageData = this.espLogService.queryEspLogEsForPage(this.buildPageEspLogDTO(request));
        return StdData.ok((Object)pageData);
    }

    @GetMapping(value={"/details/search"})
    public StdData<?> searchEspLogByReqId(@RequestParam(value="reqId") String reqId) {
        EspLogDetailsVO espLogDetailsVO = this.espLogService.listEspLogByReqId(reqId);
        return StdData.ok((Object)espLogDetailsVO);
    }

    @GetMapping(value={"/details/requestMessage/search"})
    public StdData<?> searchEspLogByReqId(@RequestParam(value="reqId") String reqId, @RequestParam(value="stepNumber") String stepNumber, @RequestParam(value="stateCode") String stateCode, @RequestParam(value="format", defaultValue="false") Boolean format) {
        String requestMessage = this.espLogService.queryRequestMessage(reqId, stepNumber, stateCode, format);
        return StdData.ok((Object)requestMessage);
    }

    @GetMapping(value={"/eaiLog/search"})
    public StdData<?> searchEaiLogs(@RequestParam(value="reqId") String reqId, @RequestParam(value="tenantId") String tenantId) {
        PageData pageData = this.espLogService.searchEaiLogs(reqId, tenantId);
        return StdData.ok((Object)pageData);
    }

    @PostMapping(value={"/export"})
    public void exportEspLog(HttpServletResponse response, @RequestBody PageEspLogRequest request) throws IOException {
        PageData pageData = this.espLogService.queryEspLogEsForPage(this.buildPageEspLogDTO(request));
        List<Object> espLogExcelVOList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            espLogExcelVOList = pageData.getList().stream().map(arg_0 -> this.buildEspLogExcelVO(arg_0)).collect(Collectors.toList());
        }
        this.excelService.exportCore(espLogExcelVOList, "esp_log", EspLogExcelVO.class, response);
    }

    @PostMapping(value={"/chainInfo/find"})
    public StdData<?> searchEspLogIncludeChainInfoByPinpointId(@RequestBody PageEspLogRequest request) {
        EspLogIncludeChainInfoVO espLogIncludeChainInfoVO = this.espLogService.searchEspLogIncludeChainInfoByPinpointId(request.getPinpointId());
        return StdData.ok((Object)espLogIncludeChainInfoVO);
    }

    @PostMapping(value={"/includeChainInfo/page/search"})
    public StdData<?> pageEspLogIncludeChainInfo(@RequestBody PageEspLogRequest request) {
        PageData pageData = this.espLogService.pageEspLogIncludeChainInfo(this.buildPageEspLogDTO(request));
        return StdData.ok((Object)pageData);
    }

    @PostMapping(value={"/aggregation"})
    public StdData<?> aggregationEspLog(@RequestBody EspLogAggregationRequest request) {
        return StdData.ok((Object)this.espLogService.aggregationEspLog(EspLogAggregationDTO.convertRequestToDTO((EspLogAggregationRequest)request)));
    }

    private CreateEspLogDTO buildCreateEspLogDTO(CreateEspLogRequest request) {
        if (request == null) {
            return null;
        }
        CreateEspLogDTO espLog = new CreateEspLogDTO();
        espLog.setReqId(request.getReqId());
        espLog.setState(request.getState());
        espLog.setStepNumber(request.getStepNumber());
        espLog.setStateCode(request.getStateCode());
        if (StringUtils.hasLength((String)request.getRequestAp())) {
            espLog.setRequest(request.getRequestAp());
        }
        espLog.setRequestAp(request.getRequestAp());
        espLog.setRequestApVersion(request.getRequestApVersion());
        espLog.setRequestApIp(request.getRequestApIp());
        espLog.setRequestApId(request.getRequestApId());
        espLog.setRequestApUid(request.getRequestApUid());
        espLog.setRequestApUser(request.getRequestApUser());
        espLog.setRequestTimestamp(request.getRequestTimestamp());
        if (StringUtils.hasLength((String)request.getServiceAp())) {
            String[] serviceApArr = request.getServiceAp().split("/");
            espLog.setService(serviceApArr.length > 0 ? serviceApArr[0].trim() : "");
            espLog.setServiceApUid(serviceApArr.length > 4 ? serviceApArr[4].trim() : "");
            espLog.setServiceApId(serviceApArr.length > 3 ? serviceApArr[3].trim() : "");
            espLog.setServiceApIp(serviceApArr.length > 2 ? serviceApArr[2].trim() : "");
        }
        espLog.setServiceAp(request.getServiceAp());
        espLog.setServiceName(request.getServiceName());
        espLog.setServiceDescription(request.getServiceDescription());
        espLog.setServiceVersion(request.getServiceVersion());
        espLog.setMessageSize(request.getMessageSize());
        espLog.setPlatformTime(request.getPlatformTime());
        espLog.setStandardTime(request.getStandardTime());
        espLog.setDataKey(request.getDataKey());
        espLog.setOperation(request.getOperation());
        espLog.setUnionApIp(request.getUnionApIp());
        espLog.setLogDisplayPriority(request.getLogDisplayPriority());
        espLog.setMsgFormat(request.getMsgFormat());
        espLog.setReqUnionIp(request.getReqUnionIp());
        espLog.setTenantId(request.getTenantId());
        espLog.setTs(request.getTs());
        espLog.setAppId(request.getAppId());
        espLog.setCompressedMessage(request.getCompressedMessage());
        espLog.setPinpointId(request.getPinpointId());
        return espLog;
    }

    private EspProductVO buildEspProductVO(EspProd espProd) {
        if (espProd == null) {
            return null;
        }
        EspProductVO espProductVO = new EspProductVO();
        espProductVO.setProductName(espProd.getName());
        espProductVO.setProductVersion(espProd.getVer());
        espProductVO.setProductIp(espProd.getIp());
        espProductVO.setProductUid(espProd.getUid());
        return espProductVO;
    }

    private EspStateCodeVO buildEspStateCodeVO(EspStateCodeResponse espStateCodeResponse) {
        if (espStateCodeResponse == null) {
            return null;
        }
        EspStateCodeVO espStateCodeVO = new EspStateCodeVO();
        espStateCodeVO.setCode(espStateCodeResponse.getCode());
        espStateCodeVO.setDescriptionEn(espStateCodeResponse.getDescriptionEn());
        espStateCodeVO.setDescriptionZhCn(espStateCodeResponse.getDescriptionZhCn());
        espStateCodeVO.setDescriptionZhTw(espStateCodeResponse.getDescriptionZhTw());
        return espStateCodeVO;
    }

    private PageQueryEspLogDTO buildPageEspLogDTO(PageEspLogRequest request) {
        if (request == null) {
            return null;
        }
        PageQueryEspLogDTO pageQueryEspLogDTO = new PageQueryEspLogDTO();
        pageQueryEspLogDTO.setPageNum(request.getPageNum());
        pageQueryEspLogDTO.setPageSize(request.getPageSize());
        pageQueryEspLogDTO.setRequest(request.getRequestAp());
        pageQueryEspLogDTO.setRequestApIp(request.getRequestApIp());
        pageQueryEspLogDTO.setRequestApId(request.getRequestApId());
        pageQueryEspLogDTO.setService(request.getServiceAp());
        pageQueryEspLogDTO.setServiceApIp(request.getServiceApIp());
        pageQueryEspLogDTO.setServiceApId(request.getServiceApId());
        pageQueryEspLogDTO.setRequestId(request.getRequestId());
        pageQueryEspLogDTO.setRequestApUid(request.getRequestApUid());
        pageQueryEspLogDTO.setServiceApUid(request.getServiceApUid());
        pageQueryEspLogDTO.setServiceDescription(request.getServiceDescription());
        pageQueryEspLogDTO.setServiceName(request.getServiceName());
        pageQueryEspLogDTO.setStateCode(request.getStateCode());
        pageQueryEspLogDTO.setStartTime(request.getStartTime());
        pageQueryEspLogDTO.setEndTime(request.getEndTime());
        pageQueryEspLogDTO.setDataKey(request.getDataKey());
        pageQueryEspLogDTO.setTenantId(request.getTenantId());
        pageQueryEspLogDTO.setState(request.getState());
        pageQueryEspLogDTO.setPinpointId(request.getPinpointId());
        if (Objects.nonNull(request.getOrderCondition())) {
            pageQueryEspLogDTO.setOrderField(request.getOrderCondition().getOrderField());
            pageQueryEspLogDTO.setOrderType(request.getOrderCondition().getOrderType());
        }
        return pageQueryEspLogDTO;
    }

    private EspLogExcelVO buildEspLogExcelVO(PageEspLogVO pageEspLogVO) {
        if (pageEspLogVO == null) {
            return null;
        }
        EspLogExcelVO espLogExcelVO = new EspLogExcelVO();
        espLogExcelVO.setPlatformTime(pageEspLogVO.getPlatformTime());
        espLogExcelVO.setReqId(pageEspLogVO.getReqId());
        espLogExcelVO.setStateCode(pageEspLogVO.getStateCode());
        espLogExcelVO.setRequest(pageEspLogVO.getRequest());
        espLogExcelVO.setRequestApUser(pageEspLogVO.getRequestApUser());
        espLogExcelVO.setServiceAp(pageEspLogVO.getServiceAp());
        espLogExcelVO.setServiceName(pageEspLogVO.getServiceName());
        espLogExcelVO.setServiceDescription(pageEspLogVO.getServiceDescription());
        espLogExcelVO.setMessageSize(pageEspLogVO.getMessageSize().toString());
        espLogExcelVO.setDataKey(pageEspLogVO.getDataKey());
        espLogExcelVO.setTenantId(pageEspLogVO.getTenantId());
        return espLogExcelVO;
    }
}

