/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.BusinessStatus;
import com.digiwin.dap.middleware.lmc.constant.enums.I18nError;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.PageDTO;
import com.digiwin.dap.middleware.lmc.domain.event.EventLogDTO;
import com.digiwin.dap.middleware.lmc.domain.excel.LoginLogExcelVO;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.event.EventLog;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.EventLogRepository;
import com.digiwin.dap.middleware.lmc.service.business.AppSettingService;
import com.digiwin.dap.middleware.lmc.service.excel.ExcelService;
import com.digiwin.dap.middleware.lmc.util.BaseEntityUtils;
import com.digiwin.dap.middleware.lmc.util.ObjectUtil;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/lmc/v1"})
public class EventLogController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventLogController.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();
    @Autowired
    private EventLogRepository eventLogRepository;
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private AppSettingService appSettingService;
    @Autowired
    private ExcelService excelService;
    @Autowired
    private EnvProperties envProperties;

    @PostMapping(value={"/eventlog"})
    public StdData<?> saveEventLog(@Validated @RequestBody EventLogDTO dto) {
        this.appSettingService.checkAndSaveDefaultAppSetting(dto.getAppId());
        if (dto.getStatus() == null) {
            dto.setStatus(Integer.valueOf(BusinessStatus.SUCCESS.ordinal()));
        }
        EventLog eventLog = (EventLog)dto.doForward();
        EventLog insert = this.eventLogRepository.mixInsert(eventLog, dto.getAppId() + "_eventlog");
        return StdData.ok((Object)insert);
    }

    @PostMapping(value={"/eventlog/batch"})
    public StdData<?> saveEventLogs(@RequestBody List<EventLogDTO> dtos) {
        ArrayList<EventLog> eventLogs = new ArrayList<EventLog>();
        for (EventLogDTO dto : dtos) {
            Assert.hasText((String)dto.getAppId(), (String)"\u5e94\u7528id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getEventName(), (String)"\u4e8b\u4ef6\u540d\u79f0\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getEventType(), (String)"\u4e8b\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            this.appSettingService.checkAndSaveDefaultAppSetting(dto.getAppId());
            if (dto.getStatus() == null) {
                dto.setStatus(Integer.valueOf(BusinessStatus.SUCCESS.ordinal()));
            }
            EventLog eventLog = (EventLog)dto.doForward();
            BaseEntityUtils.setCreateFieldsAndId((BaseEntity)eventLog);
            eventLogs.add(eventLog);
        }
        eventLogs.stream().collect(Collectors.groupingBy(EventLog::getAppId)).forEach((k, v) -> this.eventLogRepository.mixInsertAllAsync((Collection)v, k + "_eventlog"));
        return StdData.ok().build();
    }

    @PostMapping(value={"/eventlog/batch/sync"})
    public StdData<?> saveEventLogsSync(@RequestBody List<EventLogDTO> dtos) {
        ArrayList<EventLog> eventLogs = new ArrayList<EventLog>();
        for (EventLogDTO dto : dtos) {
            Assert.hasText((String)dto.getAppId(), (String)"\u5e94\u7528id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getEventName(), (String)"\u4e8b\u4ef6\u540d\u79f0\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getEventType(), (String)"\u4e8b\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            this.appSettingService.checkAndSaveDefaultAppSetting(dto.getAppId());
            if (dto.getStatus() == null) {
                dto.setStatus(Integer.valueOf(BusinessStatus.SUCCESS.ordinal()));
            }
            EventLog eventLog = (EventLog)dto.doForward();
            eventLogs.add(eventLog);
        }
        eventLogs.stream().collect(Collectors.groupingBy(EventLog::getAppId)).forEach((k, v) -> this.eventLogRepository.mixInsertAll((Collection)v, k + "_eventlog"));
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/eventlog/appid/{appId}/{id}"})
    public StdData<?> delete(@PathVariable String appId, @PathVariable String id) {
        long delete = this.eventLogRepository.deleteById(id, appId + "_eventlog");
        return StdData.ok((Object)delete);
    }

    @GetMapping(value={"/eventlogs"})
    public StdData<?> findEventLogs(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        EventLogDTO dto = EventLogDTO.getSelf((String)params);
        PageData pageData = this.getEventLogPageData(pageNum, pageSize, orders, dto);
        String appName = Optional.ofNullable(this.appSettingRepository.findOne((BaseEntity)new AppSetting(dto.getAppId()))).map(AppSetting::getAppName).orElse("");
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            pageData.getList().forEach(eventLog -> {
                eventLog.setAppName(appName);
                Optional.ofNullable(eventLog.getContent()).ifPresent(content -> {
                    String userToken = (String)content.get("userToken");
                    if (StringUtils.hasLength((String)userToken)) {
                        content.put("userToken", CharSequenceUtil.hide((CharSequence)userToken, (int)8, (int)(userToken.length() - 8)));
                    }
                });
            });
        }
        return StdData.ok((Object)pageData);
    }

    @GetMapping(value={"/eventlog/export"})
    public void exportEventLogs(HttpServletResponse response, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="1000") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        EventLogDTO dto = EventLogDTO.getSelf((String)params);
        PageData pageData = this.getEventLogPageData(pageNum, pageSize, orders, dto);
        String appName = Optional.ofNullable(this.appSettingRepository.findOne((BaseEntity)new AppSetting(dto.getAppId()))).map(AppSetting::getAppName).orElse("");
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            pageData.getList().forEach(x -> x.setAppName(appName));
        }
        List dataList = pageData.getList();
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)dataList)) {
            Collections.reverse(dataList);
            dataList.forEach(x -> {
                try {
                    builder.append(OBJECT_MAPPER.writeValueAsString(x)).append("\n");
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("\u5e8f\u5217\u5316\u5931\u8d25 {}", (Object)x.getId());
                }
            });
        }
        String fileName = "logs-from-" + dto.getAppId().toLowerCase() + "-" + DateConstant.DATE_TIME_FORMATTER_SMALL.format(LocalDateTime.now());
        this.excelService.exportTxt(response, builder.toString(), fileName);
    }

    @GetMapping(value={"/eventlog/login/export"})
    public void exportLoginLogs(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10000") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params, HttpServletResponse response) throws IOException {
        EventLogDTO dto = EventLogDTO.getSelf((String)params);
        PageData pageData = this.getEventLogPageData(pageNum, pageSize, orders, dto);
        ArrayList eventLogExcelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            pageData.getList().forEach(eventLog -> eventLogExcelList.add(new LoginLogExcelVO(eventLog)));
            this.excelService.exportCore(eventLogExcelList, "login_log", LoginLogExcelVO.class, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private PageData<EventLog> getEventLogPageData(Integer pageNum, Integer pageSize, String orders, EventLogDTO dto) {
        void var19_38;
        Map map;
        Map map2;
        Map map3;
        Map map4;
        Map regexFilters;
        Map<String, Map<String, List<Map>>> stringMapMap;
        if (ObjectUtils.isEmpty((Object)dto.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.FIELD_IS_EMPTY, new Object[]{"appId"});
        }
        ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)dto.getAppId()));
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("from", (pageNum - 1) * pageSize);
        pageMap.put("size", pageSize);
        HashMap queryMap = new HashMap();
        HashMap boolMap = new HashMap();
        queryMap.put("bool", boolMap);
        ArrayList<Map<String, Map<String, Object>>> filterList = new ArrayList<Map<String, Map<String, Object>>>();
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("appId", dto.getAppId())));
        boolMap.put("filter", filterList);
        ArrayList<Map<String, Map<String, Object>>> mustList = new ArrayList<Map<String, Map<String, Object>>>();
        ArrayList<Map<String, Map<String, List>>> mustNotList = new ArrayList<Map<String, Map<String, List>>>();
        if (!ObjectUtils.isEmpty((Object)dto.getEventId())) {
            andCrtList.add(Criteria.where((String)"eventId").is((Object)dto.getEventId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("eventId", dto.getEventId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEventName())) {
            andCrtList.add(Criteria.where((String)"eventName").regex(Pattern.quote(dto.getEventName())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("eventName", dto.getEventName())));
        }
        if (dto.getEventType() != null) {
            andCrtList.add(Criteria.where((String)"eventType").is((Object)dto.getEventType()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("eventType", dto.getEventType())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getEventTypes())) {
            andCrtList.add(Criteria.where((String)"eventType").in((Collection)dto.getEventTypes()));
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("eventType", dto.getEventTypes())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            andCrtList.add(Criteria.where((String)"tenantId").is((Object)dto.getTenantId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("tenantId", dto.getTenantId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantContent())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tenantId").regex(Pattern.quote(dto.getTenantContent())), Criteria.where((String)"tenantName").regex(Pattern.quote(dto.getTenantContent()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", dto.getTenantContent())), Collections.singletonMap("match_phrase", Collections.singletonMap("tenantName", dto.getTenantContent())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getMethod())) {
            andCrtList.add(Criteria.where((String)"method").regex(Pattern.quote(dto.getMethod())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("method", dto.getMethod())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getUserId())) {
            andCrtList.add(Criteria.where((String)"userId").is((Object)dto.getUserId()));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("userId", dto.getUserId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getUserContent())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"userId").regex(Pattern.quote(dto.getUserContent())), Criteria.where((String)"userName").regex(Pattern.quote(dto.getUserContent()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("userId", dto.getUserContent())), Collections.singletonMap("match_phrase", Collections.singletonMap("userName", dto.getUserContent())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getSysId())) {
            andCrtList.add(Criteria.where((String)"sysId").is((Object)dto.getSysId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("sysId", dto.getSysId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getSysContent())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"sysId").regex(Pattern.quote(dto.getSysContent())), Criteria.where((String)"sysName").regex(Pattern.quote(dto.getSysContent()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("sysId", dto.getSysContent())), Collections.singletonMap("match_phrase", Collections.singletonMap("sysName", dto.getSysContent())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getNotInUserIds())) {
            andCrtList.add(Criteria.where((String)"userId").nin((Collection)dto.getNotInUserIds()));
            mustNotList.add(Collections.singletonMap("terms", Collections.singletonMap("userId", dto.getNotInUserIds())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEventSource())) {
            andCrtList.add(Criteria.where((String)"eventSource").regex(Pattern.quote(dto.getEventSource())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("eventSource", dto.getEventSource())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getRequestUrl())) {
            andCrtList.add(Criteria.where((String)"requestUrl").is((Object)dto.getRequestUrl()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("requestUrl", dto.getRequestUrl())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getRequestParam())) {
            andCrtList.add(Criteria.where((String)"requestParam").regex(Pattern.quote(dto.getRequestParam())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("requestParam", dto.getRequestParam())));
        }
        if (dto.getStatus() != null) {
            andCrtList.add(Criteria.where((String)"status").is((Object)dto.getStatus()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("status", dto.getStatus())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getIds())) {
            andCrtList.add(Criteria.where((String)"_id").in((Collection)dto.getIds().stream().map(UUID::fromString).collect(Collectors.toList())));
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("id", dto.getIds())));
        }
        HashMap<String, String> timeMap = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object)dto.getCreateDateStart())) {
            andCrtList.add(Criteria.where((String)"createDate").gte((Object)DateUtils.getDateByStr((String)dto.getCreateDateStart())));
            timeMap.put("gte", dto.getCreateDateStart() + ".000");
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateDateEnd())) {
            andCrtList.add(Criteria.where((String)"createDate").lte((Object)DateUtils.getDateByStr((String)dto.getCreateDateEnd())));
            timeMap.put("lte", dto.getCreateDateEnd() + ".999");
        }
        if (!timeMap.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("createDate", timeMap)));
        }
        if (!CollectionUtils.isEmpty((Map)dto.getContent())) {
            for (Map.Entry entry : dto.getContent().entrySet()) {
                andCrtList.add(Criteria.where((String)("content." + (String)entry.getKey())).is(entry.getValue()));
                filterList.add(Collections.singletonMap("term", Collections.singletonMap("content." + (String)entry.getKey(), entry.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(regexFilters = dto.getRegexFilters()))) {
            for (Map.Entry entry : regexFilters.entrySet()) {
                filterList.add(Collections.singletonMap("match_phrase", Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map4 = dto.getEqFilters()))) {
            for (Map.Entry entry : map4.entrySet()) {
                filterList.add(Collections.singletonMap("term", Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map3 = dto.getGteFilters()))) {
            for (Map.Entry entry : map3.entrySet()) {
                HashMap hashMap = new HashMap();
                hashMap.put("gte", entry.getValue());
                filterList.add(Collections.singletonMap("range", Collections.singletonMap(entry.getKey(), hashMap)));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map2 = dto.getLteFilters()))) {
            for (Map.Entry entry : map2.entrySet()) {
                HashMap hashMap = new HashMap();
                hashMap.put("lte", entry.getValue());
                filterList.add(Collections.singletonMap("range", Collections.singletonMap(entry.getKey(), hashMap)));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map = dto.getInFilters()))) {
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof List) {
                    filterList.add(Collections.singletonMap("terms", Collections.singletonMap(entry.getKey(), (List)entry.getValue())));
                    continue;
                }
                filterList.add(Collections.singletonMap("terms", Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
        if (!andCrtList.isEmpty()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
        }
        Object var19_36 = null;
        if (!ObjectUtils.isEmpty((Object)orders)) {
            try {
                Map map5 = (Map)OBJECT_MAPPER.readValue(orders, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException iOException) {
                throw new BusinessException(I18nError.FIELD_PARSING_FAILED.getMessage(new Object[]{"orders"}), (Throwable)iOException);
            }
        }
        pageMap.put("sort", EventLogController.getSortList((Map)var19_38));
        query = ObjectUtil.query((Query)query, (Map)dto.getRegexFilters(), (Map)dto.getEqFilters(), (Map)dto.getGteFilters(), (Map)dto.getLteFilters(), (Map)dto.getInFilters());
        if (!mustList.isEmpty()) {
            boolMap.put("must", mustList);
        }
        if (!mustNotList.isEmpty()) {
            boolMap.put("must_not", mustNotList);
        }
        pageMap.put("query", queryMap);
        PageDTO pageDTO = new PageDTO(pageMap, new Page(query, pageNum.intValue(), pageSize.intValue(), (Map)var19_38), dto.getEs(), dto.getAppId(), LogTypeEnum.EVENT_LOG);
        if ("crstatscenter".equals(dto.getAppId())) {
            return this.eventLogRepository.findByPage(pageDTO.getMongoDBParams(), pageDTO.getCollectionName());
        }
        return this.eventLogRepository.mixFindByPage(pageDTO);
    }

    private static List<Map<String, String>> getSortList(Map<String, Object> orderMap) {
        if (CollectionUtils.isEmpty(orderMap)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> sortList = new ArrayList<Map<String, String>>();
        orderMap.forEach((k, v) -> {
            if (v.equals(1)) {
                sortList.add(Collections.singletonMap(k, "asc"));
            } else {
                sortList.add(Collections.singletonMap(k, "desc"));
            }
        });
        return sortList;
    }
}

