/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.I18nError;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.PageDTO;
import com.digiwin.dap.middleware.lmc.domain.excel.OpLogExcelVO;
import com.digiwin.dap.middleware.lmc.domain.oplog.LogFieldPath;
import com.digiwin.dap.middleware.lmc.domain.oplog.OpLogDTO;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.logsetting.ActionSetting;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.entity.oplog.OpLog;
import com.digiwin.dap.middleware.lmc.repository.ActionSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.lmc.service.business.AppSettingService;
import com.digiwin.dap.middleware.lmc.service.excel.ExcelService;
import com.digiwin.dap.middleware.lmc.util.BaseEntityUtils;
import com.digiwin.dap.middleware.lmc.util.ObjectUtil;
import com.digiwin.dap.middleware.lmc.util.StringUtil;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1"})
public class OpLogController {
    private static final Logger logger = LoggerFactory.getLogger(OpLogController.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private ActionSettingRepository actionSettingRepository;
    @Autowired
    private AppSettingService appSettingService;
    @Autowired
    private ExcelService excelService;
    @Autowired
    private EnvProperties envProperties;

    @PostMapping(value={"/oplog"})
    public ResponseEntity<?> saveOpLog(@Validated @RequestBody OpLogDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.appSettingService.checkAndSaveDefaultAppSetting(dto.getAppId());
        if (ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            dto.setTenantId(authoredUser.getTenantId());
        }
        if (ObjectUtils.isEmpty((Object)dto.getTenantName())) {
            dto.setTenantName(authoredUser.getTenantName());
        }
        OpLog opLog = (OpLog)dto.doForward();
        this.fillOplog(opLog);
        OpLog insert = (OpLog)this.opLogRepository.mixInsert((BaseEntity)opLog, dto.getAppId() + "_oplog");
        return ResponseEntity.ok((Object)StdData.ok((Object)insert));
    }

    @PostMapping(value={"/oplog/batch"})
    public StdData<?> saveOpLogs(@Validated @RequestBody List<OpLogDTO> dtos, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        ArrayList<OpLog> opLogs = new ArrayList<OpLog>();
        for (OpLogDTO dto : dtos) {
            Assert.hasText((String)dto.getAppId(), (String)"\u5e94\u7528id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.hasText((String)dto.getModuleId(), (String)"\u6a21\u7ec4id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getActId(), (String)"\u884c\u4e3aid\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            this.appSettingService.checkAndSaveDefaultAppSetting(dto.getAppId());
            if (ObjectUtils.isEmpty((Object)dto.getTenantId())) {
                dto.setTenantId(authoredUser.getTenantId());
            }
            if (ObjectUtils.isEmpty((Object)dto.getTenantName())) {
                dto.setTenantName(authoredUser.getTenantName());
            }
            OpLog opLog = (OpLog)dto.doForward();
            this.fillOplog(opLog);
            opLogs.add(opLog);
        }
        opLogs.stream().collect(Collectors.groupingBy(OpLog::getAppId)).forEach((k, v) -> this.opLogRepository.mixInsertAll((Collection)v, k + "_oplog"));
        return StdData.ok().build();
    }

    @PostMapping(value={"/oplog/compare"})
    public ResponseEntity<?> saveCompareOpLog(@Validated @RequestBody OpLogDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.appSettingService.checkAndSaveDefaultAppSetting(dto.getAppId());
        ActionSetting actionSetting = (ActionSetting)this.actionSettingRepository.findOne((BaseEntity)new ActionSetting(dto.getAppId(), dto.getModuleId(), dto.getActId(), dto.getOperationType()));
        if (actionSetting == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_SETTING_OPERATION_TYPE_NOT_EXISTED, new Object[]{dto.getAppId(), dto.getModuleId(), dto.getActId(), dto.getOperationType()});
        }
        if (ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            dto.setTenantId(authoredUser.getTenantId());
        }
        if (ObjectUtils.isEmpty((Object)dto.getTenantName())) {
            dto.setTenantName(authoredUser.getTenantName());
        }
        OpLog opLog = (OpLog)dto.doForward();
        List changeInfoS = this.opLogRepository.getModifyContent(dto.getOriginJson(), dto.getModifyJson(), actionSetting.getLogFieldList(), actionSetting.getPrimaryKeyList(), new LogFieldPath());
        opLog.setChangeInfoList(changeInfoS);
        this.fillOplog(opLog);
        OpLog insert = (OpLog)this.opLogRepository.mixInsert((BaseEntity)opLog, dto.getAppId() + "_oplog");
        return ResponseEntity.ok((Object)StdData.ok((Object)insert));
    }

    @PostMapping(value={"/oplog/compare/direct"})
    public ResponseEntity<?> saveCompareOpLogDirect(@Validated @RequestBody OpLogDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)dto.getPrimaryKeyList(), (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getLogFieldList(), (String)"\u5173\u6ce8\u5b57\u6bb5\u540d\u79f0\u96c6\u5408\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        this.appSettingService.checkAndSaveDefaultAppSetting(dto.getAppId());
        if (ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            dto.setTenantId(authoredUser.getTenantId());
        }
        if (ObjectUtils.isEmpty((Object)dto.getTenantName())) {
            dto.setTenantName(authoredUser.getTenantName());
        }
        OpLog opLog = (OpLog)dto.doForward();
        List changeInfoS = this.opLogRepository.getModifyContent(dto.getOriginJson(), dto.getModifyJson(), dto.getLogFieldList(), dto.getPrimaryKeyList(), new LogFieldPath());
        opLog.setChangeInfoList(changeInfoS);
        this.fillOplog(opLog);
        OpLog insert = (OpLog)this.opLogRepository.mixInsert((BaseEntity)opLog, dto.getAppId() + "_oplog");
        return ResponseEntity.ok((Object)StdData.ok((Object)insert));
    }

    @DeleteMapping(value={"/oplog/appid/{appId}/{id}"})
    public ResponseEntity<?> delete(@PathVariable String appId, @PathVariable String id, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long delete = this.opLogRepository.deleteById(id, appId + "_oplog");
        return ResponseEntity.ok((Object)StdData.ok((Object)delete));
    }

    @GetMapping(value={"/oplogs"})
    public ResponseEntity<?> findOpLogs(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params) {
        OpLogDTO dto = OpLogDTO.getSelf((String)params);
        PageData pageData = this.getOpLogPageData(pageNum, pageSize, orders, dto);
        String appName = Optional.ofNullable(this.appSettingRepository.findOne((BaseEntity)new AppSetting(dto.getAppId()))).map(AppSetting::getAppName).orElse("");
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            pageData.getList().forEach(x -> x.setAppName(appName));
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)pageData));
    }

    @GetMapping(value={"/oplog/export"})
    public void exportOpLogs(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="100000") Integer pageSize, @RequestParam(name="orders", defaultValue="{\"createDate\":-1}") String orders, @RequestParam(name="params", required=false) String params, HttpServletResponse response) throws IOException {
        OpLogDTO dto = OpLogDTO.getSelf((String)params);
        PageData pageData = this.getOpLogPageData(pageNum, pageSize, orders, dto);
        ArrayList opLogExcelList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)pageData.getList())) {
            pageData.getList().forEach(x -> opLogExcelList.add(new OpLogExcelVO(x)));
            this.excelService.exportCore(opLogExcelList, "op_log", OpLogExcelVO.class, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private PageData<OpLog> getOpLogPageData(Integer pageNum, Integer pageSize, String orders, OpLogDTO dto) {
        void var20_39;
        Map map;
        Map map2;
        Map map3;
        Map map4;
        Map regexFilters;
        Map<String, Map<String, List<Map>>> stringMapMap;
        if (ObjectUtils.isEmpty((Object)dto.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.FIELD_IS_EMPTY, new Object[]{"appId"});
        }
        ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)dto.getAppId()));
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("from", (pageNum - 1) * pageSize);
        pageMap.put("size", pageSize);
        HashMap queryMap = new HashMap();
        HashMap boolMap = new HashMap();
        queryMap.put("bool", boolMap);
        ArrayList<Map<String, Map<String, Object>>> filterList = new ArrayList<Map<String, Map<String, Object>>>();
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("appId", dto.getAppId())));
        boolMap.put("filter", filterList);
        ArrayList<Map<String, Map<String, Object>>> mustList = new ArrayList<Map<String, Map<String, Object>>>();
        ArrayList<Map<String, Map<String, List>>> mustNotList = new ArrayList<Map<String, Map<String, List>>>();
        if (!ObjectUtils.isEmpty((Object)dto.getModuleId())) {
            andCrtList.add(Criteria.where((String)"moduleId").is((Object)dto.getModuleId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("moduleId", dto.getModuleId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getActId())) {
            andCrtList.add(Criteria.where((String)"actId").is((Object)dto.getActId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("actId", dto.getActId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getOperationType())) {
            andCrtList.add(Criteria.where((String)"operationType").is((Object)dto.getOperationType()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("operationType", dto.getOperationType())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            andCrtList.add(Criteria.where((String)"tenantId").is((Object)dto.getTenantId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("tenantId", dto.getTenantId())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantName())) {
            andCrtList.add(Criteria.where((String)"tenantName").regex(Pattern.quote(dto.getTenantName())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantName", dto.getTenantName())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantContent())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tenantId").regex(Pattern.quote(dto.getTenantContent())), Criteria.where((String)"tenantName").regex(Pattern.quote(dto.getTenantContent()))}));
            Map<String, Map<String, List<Map>>> stringMapMap2 = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", dto.getTenantContent())), Collections.singletonMap("match_phrase", Collections.singletonMap("tenantName", dto.getTenantContent())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap2));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getPrimaryKey())) {
            andCrtList.add(Criteria.where((String)"primaryKey").is((Object)dto.getPrimaryKey()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("primaryKey", dto.getPrimaryKey())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getModifyById())) {
            andCrtList.add(Criteria.where((String)"modifyById").regex(Pattern.quote(dto.getModifyById())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("modifyById", dto.getModifyById())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateById())) {
            andCrtList.add(Criteria.where((String)"createById").regex(Pattern.quote(dto.getCreateById())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("createById", dto.getCreateById())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getNotInCreateByIds())) {
            andCrtList.add(Criteria.where((String)"createById").nin((Collection)dto.getNotInCreateByIds()));
            mustNotList.add(Collections.singletonMap("terms", Collections.singletonMap("createById", dto.getNotInCreateByIds())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getOperationObject())) {
            andCrtList.add(Criteria.where((String)"operationObject").regex(Pattern.quote(dto.getOperationObject())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("operationObject", dto.getOperationObject())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getIds())) {
            andCrtList.add(Criteria.where((String)"_id").in((Collection)dto.getIds().stream().map(UUID::fromString).collect(Collectors.toList())));
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("id", dto.getIds())));
        }
        HashMap<String, String> timeMap = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object)dto.getCreateDateStart())) {
            andCrtList.add(Criteria.where((String)"createDate").gte((Object)DateUtils.getDateByStr((String)dto.getCreateDateStart())));
            timeMap.put("gte", dto.getCreateDateStart() + ".000");
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateDateEnd())) {
            andCrtList.add(Criteria.where((String)"createDate").lte((Object)DateUtils.getDateByStr((String)dto.getCreateDateEnd())));
            timeMap.put("lte", dto.getCreateDateEnd() + ".999");
        }
        if (!timeMap.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("createDate", timeMap)));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getSource())) {
            andCrtList.add(Criteria.where((String)"source").is((Object)dto.getSource()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("source", dto.getSource())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getNotInSources())) {
            andCrtList.add(Criteria.where((String)"source").nin((Collection)dto.getNotInSources()));
            mustNotList.add(Collections.singletonMap("terms", Collections.singletonMap("source", dto.getNotInSources())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getActionId())) {
            andCrtList.add(Criteria.where((String)"actionId").is((Object)dto.getActionId()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("actionId", dto.getActionId())));
        }
        if (!StringUtils.isEmpty((Object)dto.getPrimaryName())) {
            andCrtList.add(Criteria.where((String)"primaryName").regex(Pattern.quote(dto.getPrimaryName())));
            mustList.add(Collections.singletonMap("match_phrase", Collections.singletonMap("primaryName", dto.getPrimaryName())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getPrimaryContent())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"primaryKey").regex(dto.getPrimaryContent()), Criteria.where((String)"primaryName").regex(dto.getPrimaryContent())}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("primaryKey", dto.getPrimaryContent())), Collections.singletonMap("match_phrase", Collections.singletonMap("primaryName", dto.getPrimaryContent())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!StringUtils.isEmpty((Object)dto.getEditUserId())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"editUserId").regex(Pattern.quote(dto.getEditUserId())), Criteria.where((String)"editUserName").regex(Pattern.quote(dto.getEditUserId()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("editUserId", dto.getEditUserId())), Collections.singletonMap("match_phrase", Collections.singletonMap("editUserName", dto.getEditUserId())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        HashMap<String, String> timeMap2 = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)dto.getBeginTime())) {
            andCrtList.add(Criteria.where((String)"editTime").gte((Object)dto.getBeginTime()));
            timeMap2.put("gte", dto.getBeginTime() + ".000");
        }
        if (!StringUtils.isEmpty((Object)dto.getEndTime())) {
            andCrtList.add(Criteria.where((String)"editTime").lte((Object)dto.getEndTime()));
            timeMap2.put("lte", dto.getEndTime() + ".999");
        }
        if (!timeMap2.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("editTime", timeMap2)));
        }
        if (!StringUtils.isEmpty((Object)dto.getEditPlace())) {
            andCrtList.add(Criteria.where((String)"editPlace").is((Object)dto.getEditPlace()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("editPlace", dto.getEditPlace())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getActionIds())) {
            andCrtList.add(Criteria.where((String)"actionId").in((Collection)dto.getActionIds()));
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("actionId", dto.getActionIds())));
        }
        if (!CollectionUtils.isEmpty((Map)dto.getContent())) {
            for (Map.Entry entry2 : dto.getContent().entrySet()) {
                andCrtList.add(Criteria.where((String)("content." + (String)entry2.getKey())).is(entry2.getValue()));
                filterList.add(Collections.singletonMap("term", Collections.singletonMap("content." + (String)entry2.getKey(), entry2.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(regexFilters = dto.getRegexFilters()))) {
            for (Map.Entry entry3 : regexFilters.entrySet()) {
                filterList.add(Collections.singletonMap("match_phrase", Collections.singletonMap(entry3.getKey(), entry3.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map4 = dto.getEqFilters()))) {
            for (Map.Entry entry4 : map4.entrySet()) {
                filterList.add(Collections.singletonMap("term", Collections.singletonMap(entry4.getKey(), entry4.getValue())));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map3 = dto.getGteFilters()))) {
            for (Map.Entry entry5 : map3.entrySet()) {
                HashMap hashMap = new HashMap();
                hashMap.put("gte", entry5.getValue());
                filterList.add(Collections.singletonMap("range", Collections.singletonMap(entry5.getKey(), hashMap)));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map2 = dto.getLteFilters()))) {
            for (Map.Entry entry6 : map2.entrySet()) {
                HashMap hashMap = new HashMap();
                hashMap.put("lte", entry6.getValue());
                filterList.add(Collections.singletonMap("range", Collections.singletonMap(entry6.getKey(), hashMap)));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map = dto.getInFilters()))) {
            for (Map.Entry entry7 : map.entrySet()) {
                if (entry7.getValue() instanceof List) {
                    filterList.add(Collections.singletonMap("terms", Collections.singletonMap(entry7.getKey(), (List)entry7.getValue())));
                    continue;
                }
                filterList.add(Collections.singletonMap("terms", Collections.singletonMap(entry7.getKey(), entry7.getValue())));
            }
        }
        if (!andCrtList.isEmpty()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
        }
        HashMap hashMap = new HashMap();
        if (!StringUtils.isEmpty((Object)orders)) {
            try {
                Map map5 = (Map)OBJECT_MAPPER.readValue(orders, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException iOException) {
                throw new BusinessException(I18nError.FIELD_PARSING_FAILED.getMessage(new Object[]{"orders"}), (Throwable)iOException);
            }
        }
        List list = var20_39.entrySet().stream().map(entry -> Collections.singletonMap(entry.getKey(), Objects.equals(entry.getValue(), 1) ? "asc" : "desc")).collect(Collectors.toList());
        pageMap.put("sort", list);
        query = ObjectUtil.query((Query)query, (Map)dto.getRegexFilters(), (Map)dto.getEqFilters(), (Map)dto.getGteFilters(), (Map)dto.getLteFilters(), (Map)dto.getInFilters());
        if (!mustList.isEmpty()) {
            boolMap.put("must", mustList);
        }
        if (!mustNotList.isEmpty()) {
            boolMap.put("must_not", mustNotList);
        }
        pageMap.put("query", queryMap);
        return this.opLogRepository.mixFindByPage(new PageDTO(pageMap, new Page(query, pageNum.intValue(), pageSize.intValue(), (Map)var20_39), dto.getEs(), dto.getAppId(), LogTypeEnum.OP_LOG));
    }

    private void fillOplog(OpLog opLog) {
        BaseEntityUtils.setCreateFields((BaseEntity)opLog);
        if (StringUtils.isEmpty((Object)opLog.getEditTime())) {
            opLog.setEditTime(DateConstant.DATE_TIME_FORMATTER.format(LocalDateTime.now()));
        }
        if (!StringUtils.isEmpty((Object)opLog.getTemplate()) || !StringUtils.isEmpty((Object)opLog.getOperationObject())) {
            Map valueMap = new HashMap();
            try {
                valueMap = (Map)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsString((Object)opLog), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                logger.error("\u64cd\u4f5c\u65e5\u5fd7\u8f6c\u5316json\u5931\u8d25", (Throwable)e);
            }
            if (!StringUtils.isEmpty((Object)opLog.getTemplate())) {
                opLog.setTemplate(StringUtil.replace((String)opLog.getTemplate(), valueMap));
            }
            if (!StringUtils.isEmpty((Object)opLog.getOperationObject())) {
                opLog.setOperationObject(StringUtil.replace((String)opLog.getOperationObject(), valueMap));
            }
        }
    }
}

