/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.PageDTO;
import com.digiwin.dap.middleware.lmc.domain.oplog.ChangeQuery;
import com.digiwin.dap.middleware.lmc.domain.oplog.LogFieldPath;
import com.digiwin.dap.middleware.lmc.domain.oplog.ModifiedInfo;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.oplog.OpLog;
import com.digiwin.dap.middleware.lmc.repository.OpLogRepository;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1"})
public class OperationLogController {
    @Autowired
    private OpLogRepository opLogRepository;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/buckets/{bucket}/changelogs"})
    public StdData<?> dataComparison(@PathVariable String bucket, @Validated @RequestBody ModifiedInfo dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        dto.setAppId(bucket);
        if (ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            dto.setTenantId(authoredUser.getTenantId());
        }
        if (ObjectUtils.isEmpty((Object)dto.getTenantName())) {
            dto.setTenantName(authoredUser.getTenantName());
        }
        OpLog opLog = dto.generateOplog();
        List changeInfoS = this.opLogRepository.getModifyContent(dto.getOriginJson(), dto.getModifyJson(), dto.getLogFieldList(), dto.getPrimaryKeyList(), new LogFieldPath());
        if (CollectionUtils.isEmpty((Collection)changeInfoS)) {
            return StdData.ok().build();
        }
        opLog.setChangeInfoList(changeInfoS);
        OpLog log = (OpLog)this.opLogRepository.mixInsert((BaseEntity)opLog, opLog.getAppId() + "_oplog");
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/buckets/{bucket}/changelogs/result"})
    public ResponseEntity<?> saveChangeLogs(@PathVariable String bucket, @RequestBody OpLog dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        dto.setAppId(bucket);
        if (ObjectUtils.isEmpty((Object)dto.getEditTime())) {
            ZonedDateTime zonedDateTime = LocalDateTime.now().atZone(ZoneId.of("Asia/Shanghai"));
            dto.setEditTime(DateConstant.SIMPLE_DATE_FORMAT.format(Date.from(zonedDateTime.toInstant()).getTime()));
        }
        if (ObjectUtils.isEmpty((Object)dto.getTenantId())) {
            dto.setTenantId(authoredUser.getTenantId());
        }
        if (ObjectUtils.isEmpty((Object)dto.getTenantName())) {
            dto.setTenantName(authoredUser.getTenantName());
        }
        OpLog opLog = (OpLog)this.opLogRepository.mixInsert((BaseEntity)dto, dto.getAppId() + "_oplog");
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/buckets/{bucket}/source/{source}/primaryKey/{primaryKey}/changelogs/count/{count}"})
    public ResponseEntity<?> getChangeLogs(@PathVariable String bucket, @PathVariable String source, @PathVariable String primaryKey, @PathVariable int count, @RequestParam(name="params", required=false) String params) {
        ChangeQuery dto = ChangeQuery.getSelf((String)params);
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("from", 0);
        pageMap.put("size", Math.min(count, 10000));
        pageMap.put("sort", Collections.singletonList(Collections.singletonMap("editTime", "desc")));
        HashMap queryMap = new HashMap();
        HashMap boolMap = new HashMap();
        queryMap.put("bool", boolMap);
        ArrayList<Map<String, Map<String, Object>>> filterList = new ArrayList<Map<String, Map<String, Object>>>();
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("appId", bucket)));
        boolMap.put("filter", filterList);
        ArrayList<HashMap<String, Map<String, List<Map>>>> mustList = new ArrayList<HashMap<String, Map<String, List<Map>>>>();
        ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"source").is((Object)source));
        andCrtList.add(Criteria.where((String)"primaryKey").is((Object)primaryKey));
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("source", source)));
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("primaryKey", primaryKey)));
        if (!ObjectUtils.isEmpty((Object)dto.getEditUserId())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"editUserId").regex(Pattern.quote(dto.getEditUserId())), Criteria.where((String)"editUserName").regex(Pattern.quote(dto.getEditUserId()))}));
            Map<String, Map<String, List<Map>>> stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("editUserId", dto.getEditUserId())), Collections.singletonMap("match_phrase", Collections.singletonMap("editUserName", dto.getEditUserId())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        HashMap<String, String> timeMap = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object)dto.getBeginTime())) {
            andCrtList.add(Criteria.where((String)"editTime").gte((Object)this.formatTime(dto.getBeginTime(), Boolean.valueOf(true))));
            timeMap.put("gte", this.formatTime(dto.getBeginTime(), Boolean.valueOf(true)) + ".000");
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEndTime())) {
            andCrtList.add(Criteria.where((String)"editTime").lte((Object)this.formatTime(dto.getEndTime(), Boolean.valueOf(false))));
            timeMap.put("lte", this.formatTime(dto.getEndTime(), Boolean.valueOf(false)) + ".999");
        }
        if (!timeMap.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("editTime", timeMap)));
        }
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
        if (!mustList.isEmpty()) {
            boolMap.put("must", mustList);
        }
        pageMap.put("query", queryMap);
        Map<String, Integer> orderMap = Collections.singletonMap("editTime", -1);
        PageData pageData = this.opLogRepository.mixFindByPage(new PageDTO(pageMap, new Page(query, 1, count, orderMap), dto.getEs(), bucket, LogTypeEnum.OP_LOG));
        return ResponseEntity.ok((Object)pageData.getList());
    }

    private String formatTime(String time, Boolean startTime) {
        int timeLength = time.length();
        if (timeLength < 19) {
            time = time.substring(0, 10);
            time = startTime != false ? time + " 00:00:00" : time + " 23:59:59";
            return time;
        }
        return time;
    }

    @PostMapping(value={"/buckets/{bucket}/source/{source}/tenant/{tenantId}/changelogs/count/{count}"})
    public ResponseEntity<?> getChangeLogsByTenantId(@PathVariable String bucket, @PathVariable String source, @PathVariable String tenantId, @PathVariable int count, @RequestBody ChangeQuery changeQuery) {
        List opLogs = this.opLogRepository.getCompareInfoListByTenantgetCompareInfoListByTenant(bucket, source, tenantId, count, changeQuery);
        return ResponseEntity.ok((Object)opLogs);
    }

    @PostMapping(value={"/buckets/{bucket}/source/{source}/changelogs/multitenant"})
    public ResponseEntity<?> getChangeLogsForMultiTenant(@PathVariable String bucket, @PathVariable String source, @RequestBody ChangeQuery changeQuery) {
        Map opLogsPage = this.opLogRepository.getChangeLogsForMultiTenant(bucket, source, changeQuery);
        return ResponseEntity.ok((Object)opLogsPage);
    }
}

