/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.lmc.domain.page.Item;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.domain.page.PageItem;
import com.digiwin.dap.middleware.lmc.domain.page.PageQueryDTO;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1"})
public class SelectController {
    @Autowired
    private AppSettingRepository appSettingRepository;

    @PostMapping(value={"/app/id/item"})
    public ResponseEntity<?> getGoodsCode(@RequestBody PageQueryDTO data) {
        Query query = new Query();
        Optional.ofNullable(data.getFilters()).map(x -> (String)x.get("code")).filter(x -> !ObjectUtils.isEmpty((Object)x)).ifPresent(x -> query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"appId").regex(Pattern.quote(x)), Criteria.where((String)"appName").regex(Pattern.quote(x))})));
        PageData pageData = this.appSettingRepository.findByPageExcludeDataPolicy(new Page(query, data.getPageNum(), data.getPageSize(), Collections.emptyMap()));
        PageItem pageItem = PageItem.data((long)pageData.getTotal(), pageData.getList().stream().map(x -> new Item(x.getAppId(), x.getAppName())).collect(Collectors.toList()));
        return ResponseEntity.ok((Object)pageItem);
    }
}

