/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.domain.stats.StatsDistDetailDTO;
import com.digiwin.dap.middleware.lmc.repository.StatsDiskDetailRepository;
import com.digiwin.dap.middleware.util.DateUtils;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lmc/v1/disk/counts"})
public class StatsDiskDetailController {
    @Autowired
    private StatsDiskDetailRepository statsDiskDetailRepository;

    @GetMapping(value={"/search"})
    public StdData<?> search(Page page, StatsDistDetailDTO dto) {
        Query query = new Query();
        ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
        if (!ObjectUtils.isEmpty((Object)dto.getAppId())) {
            andCrtList.add(Criteria.where((String)"appId").is((Object)dto.getAppId()));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateDateStart())) {
            andCrtList.add(Criteria.where((String)"createDate").gte((Object)DateUtils.parseLocalDateTime((String)dto.getCreateDateStart())));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateDateEnd())) {
            andCrtList.add(Criteria.where((String)"createDate").lte((Object)DateUtils.parseLocalDateTime((String)dto.getCreateDateEnd())));
        }
        if (!andCrtList.isEmpty()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
        }
        PageData pageData = this.statsDiskDetailRepository.findByPageExcludeDataPolicy(new Page(query, page.getPageNum(), page.getPageSize(), page.getOrders()));
        return StdData.ok((Object)pageData);
    }

    @PostMapping(value={"/del/{id}"})
    public ResponseEntity<?> delete(@PathVariable String id, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long deletedCount = this.statsDiskDetailRepository.deleteById(id);
        return ResponseEntity.ok((Object)StdData.ok((Object)deletedCount));
    }
}

