/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.config;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.config.ElasticsearchConfiguration;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="elasticsearchConfig")
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('spring.elasticsearch.uris'))}")
public class ElasticsearchConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchConfig.class);
    @Autowired
    private ElasticsearchConfiguration elasticsearchConfiguration;
    private HttpHost[] httpHosts;

    @PostConstruct
    public void initHttpHost() {
        String[] uriArray;
        if (!StringUtils.hasLength((String)this.elasticsearchConfiguration.getUris())) {
            throw new BusinessException("elasticsearch\u914d\u7f6e\u5f02\u5e38,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6!");
        }
        for (String uri : uriArray = this.elasticsearchConfiguration.getUris().split(",")) {
            if (uri.indexOf(":") != -1) continue;
            throw new BusinessException("elasticsearch\u914d\u7f6e\u5f02\u5e38,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6!");
        }
        ArrayList<HttpHost> httpHostList = new ArrayList<HttpHost>();
        String[] stringArray = uriArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String uri;
            String ip = uri = stringArray[i];
            String scheme = null;
            int schemeIdx = uri.indexOf("://");
            if (schemeIdx > 0) {
                scheme = uri.substring(0, schemeIdx);
                ip = ip.substring(schemeIdx + 3);
            }
            int port = -1;
            int portIdx = ip.lastIndexOf(":");
            if (portIdx > 0) {
                try {
                    port = Integer.parseInt(ip.substring(portIdx + 1));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid HTTP host: " + uri);
                }
                ip = ip.substring(0, portIdx);
            }
            HttpHost httpHost = new HttpHost(ip, port, scheme);
            httpHostList.add(httpHost);
        }
        this.httpHosts = httpHostList.toArray(httpHostList.toArray(new HttpHost[httpHostList.size()]));
    }

    @Bean(name={"lmcRestHighLevelClient"})
    public RestHighLevelClient restHighLevelClient() {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this.httpHosts).setRequestConfigCallback(builder -> {
            builder.setConnectTimeout(this.elasticsearchConfiguration.getConnectionTimeout().intValue()).setSocketTimeout(this.elasticsearchConfiguration.getSocketTimeout().intValue()).setConnectionRequestTimeout(this.elasticsearchConfiguration.getConnectionTimeout().intValue());
            return builder;
        }).setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            if (StringUtils.hasLength((String)this.elasticsearchConfiguration.getUsername()) && StringUtils.hasLength((String)this.elasticsearchConfiguration.getPassword())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.elasticsearchConfiguration.getUsername(), this.elasticsearchConfiguration.getPassword()));
                httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
            return httpAsyncClientBuilder;
        });
        RestHighLevelClient restHighLevelClient = new RestHighLevelClient(restClientBuilder);
        LOGGER.info("elasticsearch\u914d\u7f6e\u521d\u59cb\u5316\u5b8c\u6210!");
        return restHighLevelClient;
    }

    @Bean(name={"gzipRequestOptions"})
    public RequestOptions requestOptions() {
        return RequestOptions.DEFAULT.toBuilder().addHeader("Accept-Encoding", "gzip").build();
    }

    @Bean(name={"lmcEsActionListener"})
    public ActionListener actionListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

