/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.config;

import com.digiwin.dap.middleware.lmc.support.exception.LmcCommonErrorHandler;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.RoundRobinPartitioner;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;

@Configuration
@EnableKafka
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('spring.kafka.server'))}")
public class KafkaConfig {
    @Value(value="${spring.kafka.server:}")
    private String bootstrapServers;
    @Value(value="${spring.kafka.max.request.size}")
    private Long maxRequestSize;
    @Autowired
    private LmcCommonErrorHandler lmcCommonErrorHandler;
    @Value(value="${spring.kafka.max.poll.records}")
    private Integer kafkaMaxPollRecords;

    @Bean
    public ProducerFactory<String, String> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfigs());
    }

    @Bean
    public Map<String, Object> producerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("retries", 0);
        props.put("linger.ms", 10);
        props.put("acks", "1");
        props.put("send.buffer.bytes", -1);
        props.put("batch.size", 1038576);
        props.put("enable.idempotence", false);
        props.put("max.request.size", this.maxRequestSize.intValue());
        props.put("delivery.timeout.ms", 1200000);
        props.put("max.block.ms", 10000);
        props.put("partitioner.class", RoundRobinPartitioner.class);
        props.put("key.serializer", ByteArraySerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        return props;
    }

    @Bean(value={"kafkaSender"})
    public KafkaTemplate<String, String> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }

    public Map<String, Object> consumerConfigs(String kafkaServerUrls) {
        HashMap props = Maps.newHashMap();
        props.put("bootstrap.servers", kafkaServerUrls);
        props.put("enable.auto.commit", false);
        props.put("key.deserializer", ByteArrayDeserializer.class);
        props.put("value.deserializer", ByteArrayDeserializer.class);
        props.put("auto.offset.reset", "latest");
        props.put("fetch.max.bytes", 0x1000000);
        props.put("max.poll.records", this.kafkaMaxPollRecords);
        props.put("max.poll.interval.ms", 30000);
        return props;
    }

    public ConsumerFactory<String, String> initConsumerFactory(String kafkaServerUrls) {
        return new DefaultKafkaConsumerFactory(this.consumerConfigs(kafkaServerUrls));
    }

    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> initKafkaListenerContainerFactory(String kafkaServerUrls) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.initConsumerFactory(kafkaServerUrls));
        factory.setConcurrency(Integer.valueOf(1));
        factory.setBatchListener(Boolean.valueOf(true));
        factory.setCommonErrorHandler((CommonErrorHandler)this.lmcCommonErrorHandler);
        factory.getContainerProperties().setAckMode(ContainerProperties.AckMode.MANUAL_IMMEDIATE);
        return factory;
    }

    @Bean(name={"commonKafkaListenerContainerFactory"})
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> kafkaListenerContainerFactory() {
        return this.initKafkaListenerContainerFactory(this.bootstrapServers);
    }
}

