/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.config;

import com.digiwin.dap.middleware.autoconfigure.properties.DapProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    private static final int READ_TIMEOUT_MILLISECONDS = 300000;

    @Bean
    public ClientHttpRequestFactory customHttpRequestFactory(DapProperties dapProperties) {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(dapProperties.getHttpClient().getConnectTimeout());
        factory.setReadTimeout(300000);
        return factory;
    }

    @Bean
    public RestTemplate customRestTemplate(@Qualifier(value="customHttpRequestFactory") ClientHttpRequestFactory factory, ObjectMapper objectMapper, RestTemplate restTemplate) {
        RestTemplate customRestTemplate = new RestTemplate(factory);
        for (HttpMessageConverter httpMessageConverter : customRestTemplate.getMessageConverters()) {
            if (!(httpMessageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            ((MappingJackson2HttpMessageConverter)httpMessageConverter).setObjectMapper(objectMapper);
        }
        customRestTemplate.setInterceptors(restTemplate.getInterceptors());
        return customRestTemplate;
    }
}

