/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.config;

import com.digiwin.dap.middleware.lmc.support.concurrent.DelegateThreadPoolTaskExecutor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfig {
    private int corePoolSize = 20;
    private int maxPoolSize = 100;
    private int queueCapacity = 1000;
    private int keepAliveSeconds = 180;
    private String threadNamePrefix = "dap-log-exec-";
    public static final String ES_TASK_EXECUTOR = "esTaskExecutor";
    public static final String MQ_TASK_EXECUTOR = "mqTaskExecutor";

    @Bean(name={"threadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setCorePoolSize(this.corePoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setThreadNamePrefix(this.threadNamePrefix);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Lazy
    @Bean(name={"esTaskExecutor"})
    public DelegateThreadPoolTaskExecutor daasTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(300);
        executor.setCorePoolSize(8);
        executor.setQueueCapacity(300);
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setThreadNamePrefix("dap-es-exec-");
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return new DelegateThreadPoolTaskExecutor(executor);
    }

    @Bean(name={"mqTaskExecutor"})
    public ThreadPoolTaskExecutor applicationTaskExecutor(TaskExecutorBuilder builder) {
        ThreadPoolTaskExecutor build = builder.build();
        build.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        build.setThreadNamePrefix("dap-mq-exec-");
        build.setWaitForTasksToCompleteOnShutdown(true);
        build.setKeepAliveSeconds(this.keepAliveSeconds);
        build.setCorePoolSize(this.corePoolSize);
        return build;
    }
}

