/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.constant.enums;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum EnumSingleton {
    INSTANCE;

    private final Map<Class<?>, Long> executionTimeMsMap = new ConcurrentHashMap();

    public static EnumSingleton getInstance() {
        return INSTANCE;
    }

    public long getExecutionTimeMs(Class<?> tClass) {
        return this.executionTimeMsMap.computeIfAbsent(tClass, k -> System.currentTimeMillis());
    }

    public void setExecutionTimeMs(Class<?> tClass, long executionTimeMs) {
        this.executionTimeMsMap.put(tClass, executionTimeMs);
    }
}

