/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.domain;

import com.digiwin.dap.middleware.domain.DapEnv;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EnvProperties
extends DapEnv {
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${dap.middleware.emc.uri:}")
    private String emcUri;
    @Value(value="${dap.middleware.lmc.log.count.enabled:}")
    private Boolean logCountEnabled;
    @Value(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('spring.elasticsearch.uris'))}")
    private boolean logESEnabled;
    @Value(value="${dap.middleware.lmc.log.mongodb.enabled:}")
    private Boolean logMongoDBEnabled;
    @Value(value="${dap.middleware.lmc.log.mongodb.deleteCount:}")
    private Integer logMongoDBDeleteCount;
    @Value(value="${dap.middleware.lmc.log.es.timeIntervalMs:2000}")
    private Long timeIntervalMs;
    @Value(value="${dap.middleware.pinpoint.uri:}")
    private String pinpointUri;
    @Value(value="${dap.middleware.dev.mmc.uri:}")
    private String devMmcUri;
    @Value(value="${dap.middleware.lmc.data.policy:true}")
    private Boolean dataPolicy;
    @Value(value="${dap.middleware.lmc.internal.app:}")
    private String internalApp;
    @Value(value="${dap.middleware.lmc.internal.management.app:}")
    private String internalManagementApp;
    @Value(value="${dap.middleware.lmc.internal.host.tenant_id:}")
    private String hostTenantId;
    @Value(value="${dap.middleware.lmc.internal.athena.app:}")
    private String athenaApp;
    @Value(value="${dap.middleware.lmc.endpoint}")
    private String endpoint;
    @Value(value="${dap.middleware.lmc.cloud:0}")
    private Integer cloud;
    @Value(value="${dap.middleware.lmc.svc.uri:}")
    private String lmcSvcUri;
    @Value(value="${dap.middleware.esp.uri:}")
    private String espUri;
    @Value(value="${dap.middleware.esp.api.getProdList:}")
    private String espApiGetProdList;
    @Value(value="${dap.middleware.esp.api.getStateCodes:}")
    private String espApiGetStateCodes;
    @Value(value="${dap.middleware.esp.api.getSolution:}")
    private String espApiGetSolution;
    @Value(value="${dap.middleware.esp.api.getEaiLogs:}")
    private String espApiGetEaiLogs;

    public String getLmcSvcUri() {
        return this.lmcSvcUri;
    }

    public void setLmcSvcUri(String lmcSvcUri) {
        this.lmcSvcUri = lmcSvcUri;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public Long getTimeIntervalMs() {
        return Optional.ofNullable(this.timeIntervalMs).orElse(2000L);
    }

    public void setTimeIntervalMs(Long timeIntervalMs) {
        this.timeIntervalMs = timeIntervalMs;
    }

    public Boolean getLogCountEnabled() {
        return this.logCountEnabled;
    }

    public void setLogCountEnabled(Boolean logCountEnabled) {
        this.logCountEnabled = logCountEnabled;
    }

    public String getEmcUri() {
        return this.emcUri;
    }

    public void setEmcUri(String emcUri) {
        this.emcUri = emcUri;
    }

    public boolean getLogESEnabled() {
        return this.logESEnabled;
    }

    public void setLogESEnabled(boolean logESEnabled) {
        this.logESEnabled = logESEnabled;
    }

    public String getDevMmcUri() {
        return this.devMmcUri;
    }

    public void setDevMmcUri(String devMmcUri) {
        this.devMmcUri = devMmcUri;
    }

    public String getPinpointUri() {
        return this.pinpointUri;
    }

    public void setPinpointUri(String pinpointUri) {
        this.pinpointUri = pinpointUri;
    }

    public Integer getCloud() {
        return this.cloud;
    }

    public void setCloud(Integer cloud) {
        this.cloud = cloud;
    }

    public Boolean getDataPolicy() {
        return this.dataPolicy;
    }

    public void setDataPolicy(Boolean dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getInternalApp() {
        return this.internalApp;
    }

    public void setInternalApp(String internalApp) {
        this.internalApp = internalApp;
    }

    public String getInternalManagementApp() {
        return this.internalManagementApp;
    }

    public void setInternalManagementApp(String internalManagementApp) {
        this.internalManagementApp = internalManagementApp;
    }

    public String getHostTenantId() {
        return this.hostTenantId;
    }

    public void setHostTenantId(String hostTenantId) {
        this.hostTenantId = hostTenantId;
    }

    public String getAthenaApp() {
        return this.athenaApp;
    }

    public void setAthenaApp(String athenaApp) {
        this.athenaApp = athenaApp;
    }

    public Boolean getLogMongoDBEnabled() {
        return this.logMongoDBEnabled;
    }

    public void setLogMongoDBEnabled(Boolean logMongoDBEnabled) {
        this.logMongoDBEnabled = logMongoDBEnabled;
    }

    public boolean ifEs() {
        return this.logESEnabled;
    }

    public boolean ifMongoDB() {
        return !Boolean.FALSE.equals(this.logMongoDBEnabled) || !this.logESEnabled;
    }

    public boolean ifEs(Boolean es) {
        boolean flag1 = this.logESEnabled && !Boolean.FALSE.equals(this.logMongoDBEnabled) && Boolean.TRUE.equals(es);
        boolean flag2 = this.logESEnabled && Boolean.FALSE.equals(this.logMongoDBEnabled);
        return flag1 || flag2;
    }

    public String getEspUri() {
        return this.espUri;
    }

    public void setEspUri(String espUri) {
        this.espUri = espUri;
    }

    public String getEspApiGetProdList() {
        return this.espApiGetProdList;
    }

    public void setEspApiGetProdList(String espApiGetProdList) {
        this.espApiGetProdList = espApiGetProdList;
    }

    public String getEspApiGetStateCodes() {
        return this.espApiGetStateCodes;
    }

    public void setEspApiGetStateCodes(String espApiGetStateCodes) {
        this.espApiGetStateCodes = espApiGetStateCodes;
    }

    public String getEspApiGetSolution() {
        return this.espApiGetSolution;
    }

    public void setEspApiGetSolution(String espApiGetSolution) {
        this.espApiGetSolution = espApiGetSolution;
    }

    public String getEspApiGetEaiLogs() {
        return this.espApiGetEaiLogs;
    }

    public void setEspApiGetEaiLogs(String espApiGetEaiLogs) {
        this.espApiGetEaiLogs = espApiGetEaiLogs;
    }

    public Integer getLogMongoDBDeleteCount() {
        return this.logMongoDBDeleteCount;
    }

    public void setLogMongoDBDeleteCount(Integer logMongoDBDeleteCount) {
        this.logMongoDBDeleteCount = logMongoDBDeleteCount;
    }
}

