/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.domain.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.BusinessTypeEnum;
import com.digiwin.dap.middleware.lmc.entity.event.EventLog;
import java.util.Optional;

public class LoginLogExcelVO {
    @ExcelProperty(value={"\u767b\u5f55\u65f6\u95f4"}, index=0)
    private String createDate;
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0\uff08ID\uff09"}, index=1)
    private String tenantId;
    @ExcelProperty(value={"\u7528\u6237\u540d\u79f0\uff08ID\uff09"}, index=2)
    private String userId;
    @ExcelProperty(value={"\u5e94\u7528\u540d\u79f0\uff08ID\uff09"}, index=3)
    private String sysId;
    @ExcelProperty(value={"\u767b\u5165/\u767b\u51fa"}, index=4)
    private String eventType;
    @ExcelProperty(value={"IP"}, index=5)
    private String ip;

    public LoginLogExcelVO() {
    }

    public LoginLogExcelVO(EventLog eventLog) {
        this.createDate = Optional.ofNullable(eventLog.getCreateDate()).map(x -> DateConstant.DATE_TIME_FORMATTER.format(eventLog.getCreateDate())).orElse("");
        this.tenantId = this.getIdAndName(eventLog.getTenantId(), eventLog.getTenantName());
        this.userId = this.getIdAndName(eventLog.getUserId(), eventLog.getUserName());
        this.sysId = this.getIdAndName(eventLog.getSysId(), eventLog.getSysName());
        this.eventType = BusinessTypeEnum.getName((Integer)eventLog.getEventType());
        this.ip = eventLog.getIp();
    }

    private String getIdAndName(String id, String name) {
        if (id == null && name == null) {
            return "";
        }
        return (name == null ? "" : name) + "(" + (id == null ? "" : id) + ")";
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}

