/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.domain.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.entity.oplog.OpLog;
import java.util.Optional;

public class OpLogExcelVO {
    @ExcelProperty(value={"\u64cd\u4f5c\u65f6\u95f4"}, index=0)
    private String createDate;
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0\uff08ID\uff09"}, index=1)
    private String tenantId;
    @ExcelProperty(value={"\u64cd\u4f5c\u4eba\u5458\uff08ID\uff09"}, index=2)
    private String editUserId;
    @ExcelProperty(value={"\u64cd\u4f5c\u52a8\u4f5c\uff08ID\uff09"}, index=3)
    private String actionId;
    @ExcelProperty(value={"\u64cd\u4f5c\u7c7b\u578b\uff08ID\uff09"}, index=4)
    private String operationType;
    @ExcelProperty(value={"\u64cd\u4f5c\u76ee\u6807\uff08ID\uff09"}, index=5)
    private String operationObject;

    public OpLogExcelVO() {
    }

    public OpLogExcelVO(OpLog opLog) {
        this.createDate = Optional.ofNullable(opLog.getCreateDate()).map(x -> DateConstant.DATE_TIME_FORMATTER.format(opLog.getCreateDate())).orElse("");
        this.tenantId = this.getIdAndName(opLog.getTenantId(), opLog.getTenantName());
        this.editUserId = opLog.getCreateById();
        this.actionId = opLog.getActionId();
        this.operationType = this.getOperationTypeName(opLog.getOperationType());
        this.operationObject = opLog.getOperationObject();
    }

    private String getIdAndName(String id, String name) {
        if (id == null && name == null) {
            return "";
        }
        return (name == null ? "" : name) + "(" + (id == null ? "" : id) + ")";
    }

    private String getOperationTypeName(String operationType) {
        String operationTypeName;
        if (operationType == null) {
            return "";
        }
        switch (operationType) {
            case "insert": {
                operationTypeName = "\u65b0\u589e";
                break;
            }
            case "update": {
                operationTypeName = "\u4fee\u6539";
                break;
            }
            case "delete": {
                operationTypeName = "\u5220\u9664";
                break;
            }
            case "select": {
                operationTypeName = "\u67e5\u8be2";
                break;
            }
            case "import": {
                operationTypeName = "\u5bfc\u5165";
                break;
            }
            case "export": {
                operationTypeName = "\u5bfc\u51fa";
                break;
            }
            default: {
                operationTypeName = "";
            }
        }
        return operationTypeName;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getEditUserId() {
        return this.editUserId;
    }

    public void setEditUserId(String editUserId) {
        this.editUserId = editUserId;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getOperationObject() {
        return this.operationObject;
    }

    public void setOperationObject(String operationObject) {
        this.operationObject = operationObject;
    }
}

