/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.domain.remote;

import com.digiwin.dap.middleware.lmc.constant.enums.DataSourceEnum;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.util.CollectionUtils;

public class FieldValue {
    private Long sid;
    private String filterType;
    private Object filterValue;
    private String filterField;
    private String dataType;

    public FieldValue() {
    }

    public FieldValue(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "sid": {
                    this.sid = Long.parseLong(entry.getValue().toString());
                    break;
                }
                case "filterType": {
                    this.filterType = entry.getValue().toString();
                    break;
                }
                case "filterValue": {
                    this.filterValue = entry.getValue();
                    break;
                }
                case "filterField": {
                    this.filterField = entry.getValue().toString();
                    break;
                }
                case "dataType": {
                    this.dataType = entry.getValue().toString();
                    break;
                }
            }
        }
    }

    public Long getSid() {
        return this.sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public Object getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(Object filterValue) {
        this.filterValue = filterValue;
    }

    public String getFilterField() {
        return this.filterField;
    }

    public void setFilterField(String filterField) {
        this.filterField = filterField;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Object getCondition(DataSourceEnum dataSourceEnum) {
        switch (this.filterType) {
            case "in": {
                List values = (List)this.filterValue;
                if (CollectionUtils.isEmpty((Collection)values)) {
                    return null;
                }
                if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
                    return Criteria.where((String)this.filterField).in((Collection)values);
                }
                if (!DataSourceEnum.ES_API.equals((Object)dataSourceEnum)) break;
                return Collections.singletonMap("terms", Collections.singletonMap(this.filterField, values));
            }
            case "eq": {
                break;
            }
        }
        return null;
    }
}

