/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.entity.logsetting;

import com.digiwin.dap.middleware.lmc.constant.LmcConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.SaveDaysEnum;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="appsetting")
public class AppSetting
extends BaseEntity {
    private String appId;
    private String appName;
    private Integer changeLogSaveDays;
    private Integer devLogSaveDays;
    private Integer eventLogSaveDays;
    private Integer esChangeLogSaveDays;
    private Integer esDevLogSaveDays;
    private Integer esEventLogSaveDays;
    private String cloudWebsite;
    private Boolean ifLocal;

    public AppSetting() {
    }

    public AppSetting(String appId) {
        this.appId = appId;
    }

    public AppSetting(String appId, String appName, Integer changeLogSaveDays, Integer devLogSaveDays, Integer eventLogSaveDays, String cloudWebsite, Boolean ifLocal) {
        this.appId = appId;
        this.appName = appName;
        this.changeLogSaveDays = changeLogSaveDays;
        this.devLogSaveDays = devLogSaveDays;
        this.eventLogSaveDays = eventLogSaveDays;
        this.cloudWebsite = cloudWebsite;
        this.ifLocal = ifLocal;
    }

    public static AppSetting of(String appId, String appName) {
        AppSetting appSetting = new AppSetting();
        appSetting.setAppId(appId);
        appSetting.setAppName(appName);
        appSetting.setChangeLogSaveDays(Integer.valueOf(SaveDaysEnum.OPLOG_SAVE_DAYS_30.getDays()));
        appSetting.setDevLogSaveDays(Integer.valueOf(SaveDaysEnum.DEVLOG_SAVE_DAYS_7.getDays()));
        appSetting.setEventLogSaveDays(Integer.valueOf(SaveDaysEnum.EVENTLOG_SAVE_DAYS_30.getDays()));
        appSetting.setEsChangeLogSaveDays(Integer.valueOf(SaveDaysEnum.ES_OPLOG_SAVE_DAYS.getDays()));
        appSetting.setEsDevLogSaveDays(Integer.valueOf(SaveDaysEnum.ES_DEVLOG_SAVE_DAYS.getDays()));
        appSetting.setEsEventLogSaveDays(Integer.valueOf(SaveDaysEnum.ES_EVENTLOG_SAVE_DAYS.getDays()));
        appSetting.setCloudWebsite("");
        appSetting.setIfLocal(Boolean.valueOf(LmcConstant.MIDDLEWARE_BACKEND.contains(appId)));
        return appSetting;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getChangeLogSaveDays() {
        return this.changeLogSaveDays;
    }

    public void setChangeLogSaveDays(Integer changeLogSaveDays) {
        this.changeLogSaveDays = changeLogSaveDays;
    }

    public Integer getDevLogSaveDays() {
        return this.devLogSaveDays;
    }

    public void setDevLogSaveDays(Integer devLogSaveDays) {
        this.devLogSaveDays = devLogSaveDays;
    }

    public String getCloudWebsite() {
        return this.cloudWebsite;
    }

    public void setCloudWebsite(String cloudWebsite) {
        this.cloudWebsite = cloudWebsite;
    }

    public Integer getEventLogSaveDays() {
        return this.eventLogSaveDays;
    }

    public void setEventLogSaveDays(Integer eventLogSaveDays) {
        this.eventLogSaveDays = eventLogSaveDays;
    }

    public Boolean getIfLocal() {
        return this.ifLocal;
    }

    public void setIfLocal(Boolean ifLocal) {
        this.ifLocal = ifLocal;
    }

    public Integer getEsChangeLogSaveDays() {
        return this.esChangeLogSaveDays;
    }

    public void setEsChangeLogSaveDays(Integer esChangeLogSaveDays) {
        this.esChangeLogSaveDays = esChangeLogSaveDays;
    }

    public Integer getEsDevLogSaveDays() {
        return this.esDevLogSaveDays;
    }

    public void setEsDevLogSaveDays(Integer esDevLogSaveDays) {
        this.esDevLogSaveDays = esDevLogSaveDays;
    }

    public Integer getEsEventLogSaveDays() {
        return this.esEventLogSaveDays;
    }

    public void setEsEventLogSaveDays(Integer esEventLogSaveDays) {
        this.esEventLogSaveDays = esEventLogSaveDays;
    }
}

