/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.entity.oplog;

import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.oplog.ChangeInfo;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexLifeCycle;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexStrategy;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexTemplate;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.validation.constraints.NotBlank;

@ElasticsearchIndexStrategy(indexName="lmc-op-log", aliasName="lmc-op-log-alias", mappingPath="static/templates/lmc_oplog.json", shards="${spring.elasticsearch.shards.op-log}", replicas="${spring.elasticsearch.replicas.op-log}", mappingSize=true, refreshInterval="${spring.elasticsearch.refresh_interval}")
@ElasticsearchIndexTemplate(templateName="lmc-oplog-template", indexPatterns={"lmc-op-log-*"}, forceUpdate=true)
@ElasticsearchIndexLifeCycle(lifecycleRolloverAlias="lmc-op-log-rollover-alias", hotRolloverMaxPrimaryShardSize="${spring.elasticsearch.ilm.op-log.hot.rollover.max_primary_shard_size}", hotRolloverMaxSize="${spring.elasticsearch.ilm.op-log.hot.rollover.max_size}", hotRolloverMaxAge="${spring.elasticsearch.ilm.op-log.hot.rollover.max_age}", warmMinAge="${spring.elasticsearch.ilm.op-log.warm.min_age}", warmNumberOfReplicas="${spring.elasticsearch.ilm.op-log.warm.number_of_replicas}", warmShrinkNumberOfShards="${spring.elasticsearch.ilm.op-log.warm.shrink_number_of_shards}", coldMinAge="${spring.elasticsearch.ilm.op-log.cold.min_age}", coldNumberOfReplicas="${spring.elasticsearch.ilm.op-log.cold.number_of_replicas}")
public class OpLog
extends BaseEntity
implements Document<OpLog> {
    @NotBlank(message="\u5e94\u7528id\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotBlank(message="\u5e94\u7528id\u4e0d\u5141\u8bb8\u4e3a\u7a7a") String appId;
    @NotBlank(message="\u6a21\u7ec4id\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotBlank(message="\u6a21\u7ec4id\u4e0d\u5141\u8bb8\u4e3a\u7a7a") String moduleId;
    @NotBlank(message="\u884c\u4e3aId\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotBlank(message="\u884c\u4e3aId\u4e0d\u5141\u8bb8\u4e3a\u7a7a") String actId;
    @NotBlank(message="\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotBlank(message="\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a") String operationType;
    private String template;
    private String operationObject;
    private String source;
    private String actionId;
    private String primaryKey;
    private String primaryName;
    private String editPlace;
    private String tenantId;
    private String tenantName;
    private String tableName;
    private String editUserId;
    private String editUserName;
    private String editTime;
    private String remark;
    private Map<String, Object> originJson;
    private List<ChangeInfo> changeInfoList;
    private Map<String, Object> content;
    private String appName;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getActId() {
        return this.actId;
    }

    public void setActId(String actId) {
        this.actId = actId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getOperationObject() {
        return this.operationObject;
    }

    public void setOperationObject(String operationObject) {
        this.operationObject = operationObject;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public void setPrimaryName(String primaryName) {
        this.primaryName = primaryName;
    }

    public String getEditPlace() {
        return this.editPlace;
    }

    public void setEditPlace(String editPlace) {
        this.editPlace = editPlace;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getEditUserId() {
        return this.editUserId;
    }

    public void setEditUserId(String editUserId) {
        this.editUserId = editUserId;
    }

    public String getEditUserName() {
        return this.editUserName;
    }

    public void setEditUserName(String editUserName) {
        this.editUserName = editUserName;
    }

    public String getEditTime() {
        return this.editTime;
    }

    public void setEditTime(String editTime) {
        this.editTime = editTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Map<String, Object> getOriginJson() {
        return this.originJson;
    }

    public void setOriginJson(Map<String, Object> originJson) {
        this.originJson = originJson;
    }

    public List<ChangeInfo> getChangeInfoList() {
        return this.changeInfoList;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setChangeInfoList(List<ChangeInfo> changeInfoList) {
        this.changeInfoList = changeInfoList;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public void setContent(Map<String, Object> content) {
        this.content = content;
    }

    public String documentId() {
        return this.getId().toString();
    }

    public OpLog deserialization(String documentId, Map<String, Object> map) {
        this.setId(UUID.fromString(documentId));
        this.appId = map.getOrDefault("appId", "").toString();
        this.moduleId = map.getOrDefault("moduleId", "").toString();
        this.actId = map.getOrDefault("actId", "").toString();
        this.operationType = map.getOrDefault("operationType", "").toString();
        this.template = map.getOrDefault("template", "").toString();
        this.operationObject = map.getOrDefault("operationObject", "").toString();
        this.source = map.getOrDefault("source", "").toString();
        this.actionId = map.getOrDefault("actionId", "").toString();
        this.primaryKey = map.getOrDefault("primaryKey", "").toString();
        this.primaryName = map.getOrDefault("primaryName", "").toString();
        this.editPlace = map.getOrDefault("editPlace", "").toString();
        this.tenantId = map.getOrDefault("tenantId", "").toString();
        this.tenantName = map.getOrDefault("tenantName", "").toString();
        this.tableName = map.getOrDefault("tableName", "").toString();
        this.editUserId = map.getOrDefault("editUserId", "").toString();
        this.editUserName = map.getOrDefault("editUserName", "").toString();
        if (Objects.nonNull(map.get("editTime"))) {
            this.editTime = (String)map.get("editTime");
        }
        this.remark = map.getOrDefault("remark", "").toString();
        if (Objects.nonNull(map.get("originJson"))) {
            this.originJson = (Map)map.get("originJson");
        }
        if (Objects.nonNull(map.get("changeInfoList"))) {
            List changeInfos;
            this.changeInfoList = changeInfos = (List)map.get("changeInfoList");
        }
        if (Objects.nonNull(map.get("content"))) {
            this.content = (Map)map.get("content");
        }
        this.appName = map.getOrDefault("appName", "").toString();
        return this;
    }
}

