/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.repository.base;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.I18nError;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.PageDTO;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.oplog.OpLog;
import com.digiwin.dap.middleware.lmc.repository.base.EntityRepository;
import com.digiwin.dap.middleware.lmc.service.messaging.impl.KafkaMessagePublisher;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.lmc.util.BaseEntityUtils;
import com.digiwin.dap.middleware.lmc.util.ObjectUtil;
import com.digiwin.dap.middleware.lmc.util.SpringBeanUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public abstract class BaseEntityRepository<T extends BaseEntity>
implements EntityRepository<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseEntityRepository.class);
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired(required=false)
    private KafkaMessagePublisher messagePublisher;
    @Autowired(required=false)
    protected IElasticsearchService elasticsearchService;
    protected static final int QUEUE_SIZE = 1000;
    protected static final Map<Class<?>, Queue<?>> QUEUE_MAP = new ConcurrentHashMap();

    protected Class<T> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private Queue<T> getQueue(Class<T> tClass) {
        return QUEUE_MAP.computeIfAbsent(tClass, k -> new LinkedBlockingQueue(1000));
    }

    public T insert(T data) {
        BaseEntityUtils.setCreateFieldsAndId(data);
        return (T)((BaseEntity)this.mongoTemplate.insert(data));
    }

    public T insert(T data, String collectionName) {
        BaseEntityUtils.setCreateFieldsAndId(data);
        return (T)((BaseEntity)this.mongoTemplate.insert(data, this.checkCollectionName(collectionName)));
    }

    public Collection<T> insert(List<T> batchToSave) {
        if (CollectionUtils.isEmpty(batchToSave)) {
            return Collections.emptyList();
        }
        batchToSave.forEach(BaseEntityUtils::setCreateFieldsAndId);
        return this.mongoTemplate.insert(batchToSave, this.getEntityClass());
    }

    public T mixInsert(T data, String collectionName) {
        BaseEntityUtils.setCreateFieldsAndId(data);
        BaseEntity insert = null;
        if (this.envProperties.ifMongoDB()) {
            insert = (BaseEntity)this.mongoTemplate.insert(data, this.checkCollectionName(collectionName));
        }
        if (this.envProperties.ifEs() && data instanceof Document) {
            this.saveEs(data);
        }
        return (T)insert;
    }

    public void mixInsertAll(Collection<T> dataList, String collectionName) {
        dataList.forEach(BaseEntityUtils::setCreateFieldsAndId);
        if (this.envProperties.ifMongoDB()) {
            this.mongoTemplate.insert(dataList, this.checkCollectionName(collectionName));
        }
        if (this.envProperties.ifEs()) {
            this.saveEsAll(dataList);
        }
    }

    public void deleteEsAsyncByDays(String appId, Integer days, LogTypeEnum logTypeEnum) {
        String time = DateConstant.DATE_TIME_FORMATTER.format(LocalDateTime.now().plusDays(-days.intValue())) + ".999";
        TermQueryBuilder term = new TermQueryBuilder("appId", appId);
        RangeQueryBuilder range = new RangeQueryBuilder(logTypeEnum.getCreateDateName()).lte((Object)time);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)term).filter((QueryBuilder)range);
        this.elasticsearchService.deleteByQueryAsync((QueryBuilder)boolQueryBuilder, new String[]{logTypeEnum.getAliasName()});
    }

    @Async(value="threadPoolTaskExecutor")
    public void mixInsertAsync(T data, String collectionName) {
        data.setId(Optional.ofNullable(data.getId()).orElse(UUID.randomUUID()));
        if (this.envProperties.ifMongoDB()) {
            this.mongoTemplate.insert(data, this.checkCollectionName(collectionName));
        }
        if (this.envProperties.ifEs()) {
            this.saveEs(data);
        }
    }

    @Async(value="threadPoolTaskExecutor")
    public void mixInsertAllAsync(Collection<T> dataList, String collectionName) {
        dataList.forEach(o -> o.setId(Optional.ofNullable(o.getId()).orElse(UUID.randomUUID())));
        if (this.envProperties.ifMongoDB()) {
            this.mongoTemplate.insert(dataList, this.checkCollectionName(collectionName));
        }
        if (this.envProperties.ifEs()) {
            this.saveEsAll(dataList);
        }
    }

    public PageData<T> mixFindByPage(PageDTO<T> dto) {
        if (this.envProperties.ifEs(dto.getEs())) {
            return ((BaseEntityRepository)SpringBeanUtils.getAopProxy((Object)this)).queryEsForPage(dto.getEsParams(), dto.getLogTypeEnum());
        }
        return ((BaseEntityRepository)SpringBeanUtils.getAopProxy((Object)this)).findByPage(dto.getMongoDBParams(), dto.getCollectionName());
    }

    public Collection<T> insert(List<T> batchToSave, String collectionName) {
        if (CollectionUtils.isEmpty(batchToSave)) {
            return Collections.emptyList();
        }
        batchToSave.forEach(BaseEntityUtils::setCreateFieldsAndId);
        return this.mongoTemplate.insert(batchToSave, this.checkCollectionName(collectionName));
    }

    public long deleteById(String id) {
        return this.deleteById(UUID.fromString(id));
    }

    public long deleteById(String id, String collectionName) {
        return this.deleteById(UUID.fromString(id), collectionName);
    }

    public long deleteById(UUID id) {
        return this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), this.getEntityClass()).getDeletedCount();
    }

    public long deleteById(UUID id, String collectionName) {
        return this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), this.getEntityClass(), this.checkCollectionName(collectionName)).getDeletedCount();
    }

    public long deleteByQuery(Query query) {
        return this.mongoTemplate.remove(query, this.getEntityClass()).getDeletedCount();
    }

    public long deleteByQuery(Query query, String collectionName) {
        return this.mongoTemplate.remove(query, this.getEntityClass(), this.checkCollectionName(collectionName)).getDeletedCount();
    }

    public long deleteByQuery2(Query query, String collectionName) {
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.checkCollectionName(collectionName));
        bulkOps.remove(query);
        return bulkOps.execute().getDeletedCount();
    }

    public void update(T data) {
        BaseEntity old = (BaseEntity)this.mongoTemplate.findById((Object)data.getId(), this.getEntityClass());
        if (old != null) {
            BaseEntityUtils.setModifyFields(data, (BaseEntity)old);
            this.mongoTemplate.findAndReplace(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)data.getId())), data);
        }
    }

    public void update(T data, String collectionName) {
        collectionName = this.checkCollectionName(collectionName);
        BaseEntity old = (BaseEntity)this.mongoTemplate.findById((Object)data.getId(), this.getEntityClass(), collectionName);
        if (old != null) {
            BaseEntityUtils.setModifyFields(data, (BaseEntity)old);
            this.mongoTemplate.findAndReplace(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)data.getId())), data, collectionName);
        }
    }

    public T findById(String id) {
        return (T)this.findById(UUID.fromString(id));
    }

    public T findById(String id, String collectionName) {
        return (T)this.findById(UUID.fromString(id), collectionName);
    }

    public T findById(UUID id) {
        return (T)((BaseEntity)this.mongoTemplate.findById((Object)id, this.getEntityClass()));
    }

    public T findById(UUID id, String collectionName) {
        return (T)((BaseEntity)this.mongoTemplate.findById((Object)id, this.getEntityClass(), this.checkCollectionName(collectionName)));
    }

    public T findOne(T data) {
        return (T)((BaseEntity)this.mongoTemplate.findOne(ObjectUtil.query(data), this.getEntityClass()));
    }

    public T findOne(T data, String collectionName) {
        return (T)((BaseEntity)this.mongoTemplate.findOne(ObjectUtil.query(data), this.getEntityClass(), this.checkCollectionName(collectionName)));
    }

    public List<T> findAll() {
        return this.mongoTemplate.findAll(this.getEntityClass());
    }

    public List<T> findAll(String collectionName) {
        return this.mongoTemplate.findAll(this.getEntityClass(), this.checkCollectionName(collectionName));
    }

    public List<T> findAll(T data) {
        return this.mongoTemplate.find(ObjectUtil.query(data), this.getEntityClass());
    }

    public List<T> findAll(T data, String collectionName) {
        return this.mongoTemplate.find(ObjectUtil.query(data), this.getEntityClass(), this.checkCollectionName(collectionName));
    }

    public List<T> findAll(T data, Boolean regex) {
        return this.mongoTemplate.find(ObjectUtil.query(data, (Boolean)regex), this.getEntityClass());
    }

    public List<T> findAll(T data, String collectionName, Boolean regex) {
        return this.mongoTemplate.find(ObjectUtil.query(data, (Boolean)regex), this.getEntityClass(), this.checkCollectionName(collectionName));
    }

    public List<T> findAll(T data, String ... regexField) {
        return this.mongoTemplate.find(ObjectUtil.query(data, (String[])regexField), this.getEntityClass());
    }

    public List<T> findAll(String collectionName, T data, String ... regexField) {
        return this.mongoTemplate.find(ObjectUtil.query(data, (String[])regexField), this.getEntityClass(), this.checkCollectionName(collectionName));
    }

    public List<T> findAll(Query query) {
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    public List<T> findAll(Query query, String collectionName) {
        return this.mongoTemplate.find(query, this.getEntityClass(), this.checkCollectionName(collectionName));
    }

    public PageData<T> findByPage(Page page) {
        long total;
        if (page == null) {
            page = new Page();
        }
        if ((total = this.mongoTemplate.count(page.queryFilter(), this.getEntityClass())) <= 0L) {
            return PageData.zero();
        }
        List list = this.mongoTemplate.find(page.query(), this.getEntityClass());
        return PageData.data((long)total, (List)list);
    }

    public PageData<T> findByPageExcludeDataPolicy(Page page) {
        return this.findByPage(page);
    }

    public PageData<T> findByPage(Page page, String collectionName) {
        long total;
        collectionName = this.checkCollectionName(collectionName);
        if (page == null) {
            page = new Page();
        }
        if ((total = this.mongoTemplate.count(page.queryFilter(), collectionName)) <= 0L) {
            return PageData.zero();
        }
        List list = this.mongoTemplate.find(page.query(), this.getEntityClass(), collectionName);
        return PageData.data((long)total, (List)list);
    }

    public PageData<T> findByPageExcludeDataPolicy(Page page, String collectionName) {
        return this.findByPage(page, collectionName);
    }

    public boolean existsById(String id) {
        return this.existsById(UUID.fromString(id));
    }

    public boolean existsById(String id, String collectionName) {
        return this.existsById(UUID.fromString(id), collectionName);
    }

    public boolean existsById(UUID id) {
        return this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), this.getEntityClass());
    }

    public boolean existsById(UUID id, String collectionName) {
        return this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), this.getEntityClass(), this.checkCollectionName(collectionName));
    }

    public long count(Query query) {
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    public long count(Query query, String collectionName) {
        return this.mongoTemplate.count(query, this.checkCollectionName(collectionName));
    }

    public String checkCollectionName(String collectionName) {
        if (ObjectUtils.isEmpty((Object)collectionName)) {
            throw new BusinessException((ErrorHandler)I18nError.FIELD_IS_EMPTY, new Object[]{"collectionName"});
        }
        return collectionName.toLowerCase();
    }

    protected void saveEs(T data) {
        if (Objects.isNull(data)) {
            return;
        }
        if (this.messagePublisher != null && !(data instanceof OpLog)) {
            this.messagePublisher.publish(JsonUtils.objToJson(data), this.getTopicName(), this.getEsSuffixIndex());
            return;
        }
        this.elasticsearchService.index((Document)data);
    }

    protected void saveEsAll(Collection<T> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        if (this.messagePublisher != null && !(dataList.iterator().next() instanceof OpLog)) {
            dataList.forEach(data -> this.messagePublisher.publish(JsonUtils.objToJson((Object)data), this.getTopicName(), this.getEsSuffixIndex()));
            return;
        }
        this.elasticsearchService.bulkIndex((List)dataList);
    }
}

