/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.repository.impl;

import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.DataSourceEnum;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.devlog.DevLog;
import com.digiwin.dap.middleware.lmc.repository.DevLogRepository;
import com.digiwin.dap.middleware.lmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.lmc.support.aspect.DataPolicy;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class DevLogRepositoryImpl
extends BaseEntityRepository<DevLog>
implements DevLogRepository {
    @Autowired
    private EnvProperties envProperties;
    @Value(value="${spring.kafka.topic.dev-log}")
    private String topic;

    public String getEsSuffixIndex() {
        return "_devlog" + DateConstant.YEARS_DF.format(LocalDateTime.now());
    }

    public String getTopicName() {
        return this.topic;
    }

    @DataPolicy
    public PageData<DevLog> findByPage(Page page, String collectionName) {
        return super.findByPage(page, collectionName);
    }

    @DataPolicy(dataSource=DataSourceEnum.ES_API)
    public PageData<DevLog> queryEsForPage(Map<String, Object> queryMap, LogTypeEnum logTypeEnum) {
        return this.elasticsearchService.pageSearch(queryMap, new String[]{logTypeEnum.getAliasName()}, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public PageData<DevLog> queryEsForPageExcludePolicy(Map<String, Object> queryMap, LogTypeEnum logTypeEnum) {
        return this.elasticsearchService.pageSearch(queryMap, new String[]{logTypeEnum.getAliasName()}, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }
}

