/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.repository.impl;

import com.digiwin.dap.middleware.lmc.constant.enums.DataSourceEnum;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.event.EventLog;
import com.digiwin.dap.middleware.lmc.repository.EventLogRepository;
import com.digiwin.dap.middleware.lmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.lmc.support.aspect.DataPolicy;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import com.digiwin.dap.middleware.lmc.util.BaseEntityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class EventLogRepositoryImpl
extends BaseEntityRepository<EventLog>
implements EventLogRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventLogRepositoryImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Value(value="${spring.kafka.topic.event-log}")
    private String topic;

    public String getEsSuffixIndex() {
        return "_eventlog202309";
    }

    public String getTopicName() {
        return this.topic;
    }

    public EventLog mixInsert(EventLog data, String collectionName) {
        BaseEntityUtils.setCreateFieldsAndId((BaseEntity)data);
        EventLog insert = null;
        if (this.envProperties.ifMongoDB() || "crstatscenter".equals(data.getAppId())) {
            insert = (EventLog)this.mongoTemplate.insert((Object)data, this.checkCollectionName(collectionName));
        }
        if (this.envProperties.ifEs() && data instanceof Document) {
            this.saveEs((BaseEntity)data);
        }
        return insert;
    }

    @Async(value="threadPoolTaskExecutor")
    public void mixInsertAllAsync(Collection<EventLog> dataList, String collectionName) {
        dataList.forEach(o -> o.setId(Optional.ofNullable(o.getId()).orElse(UUID.randomUUID())));
        if (this.envProperties.ifMongoDB()) {
            this.mongoTemplate.insert(dataList, this.checkCollectionName(collectionName));
        }
        if (this.envProperties.ifEs()) {
            List eventLogPaasBillList = dataList.stream().filter(x -> "crstatscenter".equals(x.getAppId())).collect(Collectors.toList());
            List eventLogList = dataList.stream().filter(x -> !"crstatscenter".equals(x.getAppId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(eventLogPaasBillList) && !this.envProperties.ifMongoDB()) {
                this.mongoTemplate.insert(eventLogPaasBillList, this.checkCollectionName(collectionName));
            }
            this.saveEsAll(eventLogList);
        }
    }

    public void mixInsertAll(Collection<EventLog> dataList, String collectionName) {
        dataList.forEach(BaseEntityUtils::setCreateFieldsAndId);
        if (this.envProperties.ifMongoDB()) {
            this.mongoTemplate.insert(dataList, this.checkCollectionName(collectionName));
        }
        if (this.envProperties.ifEs()) {
            List eventLogPaasBillList = dataList.stream().filter(x -> "crstatscenter".equals(x.getAppId())).collect(Collectors.toList());
            List eventLogList = dataList.stream().filter(x -> !"crstatscenter".equals(x.getAppId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(eventLogPaasBillList)) {
                this.mongoTemplate.insert(eventLogPaasBillList, this.checkCollectionName(collectionName));
            }
            this.saveEsAll(eventLogList);
        }
    }

    @DataPolicy(logType={LogTypeEnum.EVENT_LOG})
    public PageData<EventLog> findByPage(Page page, String collectionName) {
        return super.findByPage(page, collectionName);
    }

    @DataPolicy(dataSource=DataSourceEnum.ES_API, logType={LogTypeEnum.EVENT_LOG})
    public PageData<EventLog> queryEsForPage(Map<String, Object> queryMap, LogTypeEnum logTypeEnum) {
        return this.elasticsearchService.pageSearch(queryMap, new String[]{logTypeEnum.getAliasName()}, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }
}

