/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.repository.impl;

import com.digiwin.dap.middleware.lmc.constant.enums.DataSourceEnum;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.PageDTO;
import com.digiwin.dap.middleware.lmc.domain.oplog.ChangeQuery;
import com.digiwin.dap.middleware.lmc.domain.oplog.LogFieldPath;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.oplog.ChangeInfo;
import com.digiwin.dap.middleware.lmc.entity.oplog.OpLog;
import com.digiwin.dap.middleware.lmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.lmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.lmc.support.aspect.DataPolicy;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class OpLogRepositoryImpl
extends BaseEntityRepository<OpLog>
implements OpLogRepository {
    private static final Logger logger = LoggerFactory.getLogger(OpLogRepositoryImpl.class);
    @Value(value="${spring.kafka.topic.op-log}")
    private String topic;
    @Autowired
    MongoConverter mongoConverter;
    private static final String PRIMARY_KRY_NAME = "primaryKey";
    private static final String LINKED_HASH_MAP = "LinkedHashMap";
    private static final String ARRAY_LIST = "ArrayList";

    public String getEsSuffixIndex() {
        return "_oplog";
    }

    public String getTopicName() {
        return this.topic;
    }

    @DataPolicy(logType={LogTypeEnum.OP_LOG})
    public PageData<OpLog> findByPage(Page page, String collectionName) {
        return super.findByPage(page, collectionName);
    }

    public List<ChangeInfo> getModifyContent(Map<String, Object> sourceMap, Map<String, Object> targetMap, List<Map<String, String>> logFieldList, List<Map<String, String>> primaryKeyList, LogFieldPath logFieldPath) {
        ArrayList<ChangeInfo> changeList = new ArrayList<ChangeInfo>();
        try {
            sourceMap.forEach((k, v) -> {
                Object targetValue = targetMap.get(k);
                if (targetValue != null && !Objects.equals(v, targetValue)) {
                    if (LINKED_HASH_MAP.equals(targetValue.getClass().getSimpleName())) {
                        ChangeInfo changeInfo = this.complexPropertyInfo(k, v, targetValue, logFieldList, primaryKeyList, logFieldPath);
                        if (changeInfo == null) {
                            return;
                        }
                        changeList.add(changeInfo);
                    } else if (ARRAY_LIST.equals(targetValue.getClass().getSimpleName())) {
                        ChangeInfo changeInfo = this.collectionPropertyInfo(k, v, targetValue, logFieldList, primaryKeyList, logFieldPath);
                        if (changeInfo == null || changeInfo.getChangedSet().size() == 0) {
                            return;
                        }
                        changeList.add(changeInfo);
                    } else {
                        ChangeInfo changeInfo = this.simplePropertyInfo(k, v, targetValue, logFieldList, logFieldPath);
                        if (changeInfo == null) {
                            return;
                        }
                        changeList.add(changeInfo);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6bd4\u5bf9\u7ed3\u679c\u9519\u8bef", (Throwable)e);
        }
        return changeList;
    }

    public List<OpLog> getCompareInfoListByTenantgetCompareInfoListByTenant(String bucket, String source, String tenantId, int count, ChangeQuery dto) {
        Map<String, Map<String, List<Map>>> stringMapMap;
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("from", 0);
        pageMap.put("size", Math.min(count, 10000));
        pageMap.put("sort", Collections.singletonList(Collections.singletonMap("editTime", "desc")));
        HashMap queryMap = new HashMap();
        HashMap boolMap = new HashMap();
        queryMap.put("bool", boolMap);
        ArrayList<Map<String, Map<String, Object>>> filterList = new ArrayList<Map<String, Map<String, Object>>>();
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("appId", bucket)));
        boolMap.put("filter", filterList);
        ArrayList<HashMap<String, Map<String, List<Map>>>> mustList = new ArrayList<HashMap<String, Map<String, List<Map>>>>();
        ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"source").is((Object)source));
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("source", source)));
        HashMap<String, String> timeMap = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object)dto.getBeginTime())) {
            andCrtList.add(Criteria.where((String)"editTime").gte((Object)this.formatTime(dto.getBeginTime(), Boolean.valueOf(true))));
            timeMap.put("gte", this.formatTime(dto.getBeginTime(), Boolean.valueOf(true)) + ".000");
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEndTime())) {
            andCrtList.add(Criteria.where((String)"editTime").lte((Object)this.formatTime(dto.getEndTime(), Boolean.valueOf(false))));
            timeMap.put("lte", this.formatTime(dto.getEndTime(), Boolean.valueOf(false)) + ".999");
        }
        if (!timeMap.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("editTime", timeMap)));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEditUserId())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"editUserId").regex(dto.getEditUserId()), Criteria.where((String)"editUserName").regex(Pattern.quote(dto.getEditUserId()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("editUserId", dto.getEditUserId())), Collections.singletonMap("match_phrase", Collections.singletonMap("editUserName", dto.getEditUserId())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getChangedUserId())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)PRIMARY_KRY_NAME).regex(dto.getChangedUserId()), Criteria.where((String)"primaryName").regex(Pattern.quote(dto.getChangedUserId()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap(PRIMARY_KRY_NAME, dto.getChangedUserId())), Collections.singletonMap("match_phrase", Collections.singletonMap("primaryName", dto.getChangedUserId())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEditPlace())) {
            andCrtList.add(Criteria.where((String)"editPlace").is((Object)dto.getEditPlace()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("editPlace", dto.getEditPlace())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getActionIds())) {
            andCrtList.add(Criteria.where((String)"actionId").in((Collection)dto.getActionIds()));
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("actionId", dto.getActionIds())));
        }
        if (!"*".equals(tenantId)) {
            andCrtList.add(Criteria.where((String)"tenantId").is((Object)tenantId));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("tenantId", tenantId)));
        }
        if (!andCrtList.isEmpty()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
        }
        if (!mustList.isEmpty()) {
            boolMap.put("must", mustList);
        }
        pageMap.put("query", queryMap);
        Map<String, Integer> orderMap = Collections.singletonMap("editTime", -1);
        PageData pageData = this.mixFindByPage(new PageDTO(pageMap, new Page(query, 1, count, orderMap), dto.getEs(), bucket, LogTypeEnum.OP_LOG));
        return pageData.getList();
    }

    private String formatTime(String time, Boolean startTime) {
        int timeLength = time.length();
        if (timeLength < 19) {
            time = time.substring(0, 10);
            time = startTime != false ? time + " 00:00:00" : time + " 23:59:59";
            return time;
        }
        return time;
    }

    public Map<String, Object> getChangeLogsForMultiTenant(String bucket, String source, ChangeQuery dto) {
        Map<String, Map<String, List<Map>>> stringMapMap;
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("from", (dto.getPageIndex() - 1) * dto.getPageSize());
        pageMap.put("size", dto.getPageSize());
        pageMap.put("sort", Collections.singletonList(Collections.singletonMap("editTime", "desc")));
        HashMap queryMap = new HashMap();
        HashMap boolMap = new HashMap();
        queryMap.put("bool", boolMap);
        ArrayList<Map<String, Map<String, Object>>> filterList = new ArrayList<Map<String, Map<String, Object>>>();
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("appId", bucket)));
        boolMap.put("filter", filterList);
        ArrayList<HashMap<String, Map<String, List<Map>>>> mustList = new ArrayList<HashMap<String, Map<String, List<Map>>>>();
        ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"source").is((Object)source));
        filterList.add(Collections.singletonMap("term", Collections.singletonMap("source", source)));
        HashMap<String, String> timeMap = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object)dto.getBeginTime())) {
            andCrtList.add(Criteria.where((String)"editTime").gte((Object)dto.getBeginTime()));
            timeMap.put("gte", dto.getBeginTime() + ".000");
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEndTime())) {
            andCrtList.add(Criteria.where((String)"editTime").lte((Object)dto.getEndTime()));
            timeMap.put("lte", dto.getEndTime() + ".999");
        }
        if (!timeMap.isEmpty()) {
            filterList.add(Collections.singletonMap("range", Collections.singletonMap("editTime", timeMap)));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getTenantInfo())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tenantId").regex(dto.getTenantInfo()), Criteria.where((String)"tenantName").regex(Pattern.quote(dto.getTenantInfo()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", dto.getTenantInfo())), Collections.singletonMap("match_phrase", Collections.singletonMap("tenantName", dto.getTenantInfo())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getChildTenantInfo())) {
            andCrtList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)PRIMARY_KRY_NAME).regex(dto.getChildTenantInfo()), Criteria.where((String)"primaryName").regex(Pattern.quote(dto.getChildTenantInfo()))}));
            stringMapMap = Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("match_phrase", Collections.singletonMap(PRIMARY_KRY_NAME, dto.getChildTenantInfo())), Collections.singletonMap("match_phrase", Collections.singletonMap("primaryName", dto.getChildTenantInfo())))));
            mustList.add(new HashMap<String, Map<String, List<Map>>>(stringMapMap));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEditPlace())) {
            andCrtList.add(Criteria.where((String)"editPlace").is((Object)dto.getEditPlace()));
            filterList.add(Collections.singletonMap("term", Collections.singletonMap("editPlace", dto.getEditPlace())));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getActionIds())) {
            andCrtList.add(Criteria.where((String)"actionId").in((Collection)dto.getActionIds()));
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("actionId", dto.getActionIds())));
        }
        if (!andCrtList.isEmpty()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
        }
        if (!mustList.isEmpty()) {
            boolMap.put("must", mustList);
        }
        pageMap.put("query", queryMap);
        Map<String, Integer> orderMap = Collections.singletonMap("editTime", -1);
        PageData pageData = this.mixFindByPage(new PageDTO(pageMap, new Page(query, dto.getPageIndex().intValue(), dto.getPageSize().intValue(), orderMap), dto.getEs(), bucket, LogTypeEnum.OP_LOG));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("totalCount", pageData.getTotal());
        resultMap.put("data", pageData.getList());
        return resultMap;
    }

    @DataPolicy(dataSource=DataSourceEnum.ES_API, logType={LogTypeEnum.OP_LOG})
    public PageData<OpLog> queryEsForPage(Map<String, Object> queryMap, LogTypeEnum logTypeEnum) {
        return this.elasticsearchService.pageSearch(queryMap, new String[]{logTypeEnum.getAliasName()}, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ChangeInfo simplePropertyInfo(String key, Object originValue, Object modifyValue, List<Map<String, String>> logFieldList, LogFieldPath logFieldPath) {
        logFieldPath.push(key);
        Optional<Map> logField = logFieldList.stream().filter(logFieldMap -> ((String)logFieldMap.get("fieldName")).equals(logFieldPath.getPath())).findFirst();
        logFieldPath.pop();
        if (logField.orElse(null) == null) {
            return null;
        }
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey(key);
        changeInfo.setDisplayName((String)logField.get().get("displayName"));
        changeInfo.setType("simpleProperty");
        changeInfo.setOriginValue(originValue == null ? "" : originValue.toString());
        changeInfo.setModifyValue(modifyValue == null ? "" : modifyValue.toString());
        return changeInfo;
    }

    private ChangeInfo complexPropertyInfo(String key, Object originValue, Object modifyValue, List<Map<String, String>> logFieldList, List<Map<String, String>> primaryKeyList, LogFieldPath logFieldPath) {
        logFieldPath.push(key);
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey(key);
        changeInfo.setType("complexProperty");
        changeInfo.setChangeInfoList(this.getModifyContent((Map)originValue, (Map)modifyValue, logFieldList, primaryKeyList, logFieldPath));
        logFieldPath.pop();
        return changeInfo;
    }

    private ChangeInfo collectionPropertyInfo(String key, Object originValue, Object modifyValue, List<Map<String, String>> logFieldList, List<Map<String, String>> primaryKeyList, LogFieldPath logFieldPath) {
        logFieldPath.push(key);
        Optional<Map> primaryKeyFirst = primaryKeyList.stream().filter(primaryKeyMap -> ((String)primaryKeyMap.get("path")).equals(logFieldPath.getPath())).findFirst();
        if (primaryKeyFirst.orElse(null) == null) {
            logFieldPath.pop();
            return null;
        }
        String primaryKey = (String)primaryKeyFirst.get().get("keyName");
        String showField = (String)primaryKeyFirst.get().get("showField");
        List originChildList = (List)originValue;
        List modifyChildList = (List)modifyValue;
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey(key);
        changeInfo.setType("collectionProperty");
        ArrayList changedSet = new ArrayList();
        originChildList.forEach(map -> {
            Optional<Map> targetChildInfo = modifyChildList.stream().filter(targetChild -> targetChild.get(primaryKey).equals(map.get(primaryKey))).findFirst();
            if (targetChildInfo.orElse(null) != null) {
                ChangeInfo changeInfoChild = new ChangeInfo();
                changeInfoChild.setPrimaryKey(map.get(primaryKey).toString());
                changeInfoChild.setDisplayName(showField == null ? "" : map.get(showField).toString());
                changeInfoChild.setChangeType("update");
                List changeInfoS = this.getModifyContent(map, targetChildInfo.get(), logFieldList, primaryKeyList, logFieldPath);
                if (changeInfoS.size() > 0) {
                    changeInfoChild.setChangeInfoList(changeInfoS);
                    changedSet.add(changeInfoChild);
                }
            } else {
                ChangeInfo deleteInfo = new ChangeInfo();
                deleteInfo.setPrimaryKey(map.get(primaryKey).toString());
                deleteInfo.setDisplayName(showField == null ? "" : map.get(showField).toString());
                deleteInfo.setChangeType("delete");
                deleteInfo.setDeleteInfo(map);
                changedSet.add(deleteInfo);
            }
        });
        modifyChildList.forEach(targetChild -> {
            Optional<Map> insertList = originChildList.stream().filter(sourceChild -> sourceChild.get(primaryKey).equals(targetChild.get(primaryKey))).findFirst();
            if (insertList.orElse(null) == null) {
                ChangeInfo insertInfo = new ChangeInfo();
                insertInfo.setPrimaryKey(targetChild.get(primaryKey).toString());
                insertInfo.setDisplayName(showField == null ? "" : targetChild.get(showField).toString());
                insertInfo.setChangeType("insert");
                insertInfo.setInsertInfo(targetChild);
                changedSet.add(insertInfo);
            }
        });
        changeInfo.setChangedSet(changedSet);
        logFieldPath.pop();
        return changeInfo;
    }
}

