/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.repository.impl;

import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.devlog.DevLog;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.entity.stats.StatsDiskDetail;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.StatsDiskDetailRepository;
import com.digiwin.dap.middleware.lmc.repository.base.BaseEntityRepository;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsStatisticsDiskUsageResponse;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class StatsDiskDetailRepositoryImpl
extends BaseEntityRepository<StatsDiskDetail>
implements StatsDiskDetailRepository {
    private static final Logger logger = LoggerFactory.getLogger(StatsDiskDetailRepositoryImpl.class);
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private IElasticsearchService elasticsearchService;

    public void statsDiskDetail() {
        List appSettings = this.appSettingRepository.findAll();
        Map<String, String> collectionNameMap = appSettings.stream().collect(Collectors.toMap(x -> x.getAppId().toLowerCase() + "_devlog", AppSetting::getAppId, (k1, k2) -> k1));
        for (Map.Entry<String, String> entry : collectionNameMap.entrySet()) {
            try {
                if (!this.mongoTemplate.collectionExists(entry.getKey())) continue;
                Document collStats = this.mongoTemplate.executeCommand(new Document("collStats", (Object)entry.getKey()));
                StatsDiskDetail statsDiskDetail = new StatsDiskDetail();
                statsDiskDetail.setAppId(entry.getValue());
                statsDiskDetail.setSize(Long.valueOf(((Number)collStats.get((Object)"size", Number.class)).longValue()));
                statsDiskDetail.setQueryTime(LocalDateTime.now());
                this.insert((BaseEntity)statsDiskDetail);
            }
            catch (Exception e) {
                logger.error("{} \u4e0d\u5b58\u5728\uff0c\u9519\u8bef\uff1a{}", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
    }

    public void statsDiskDetailFromElasticsearch() {
        logger.info("\u5f00\u59cb\u7edf\u8ba1es\u78c1\u76d8\u4f7f\u7528\u60c5\u51b5");
        long start = System.currentTimeMillis();
        EsStatisticsDiskUsageResponse esStatisticsDiskUsageResponse = this.elasticsearchService.statisticsDiskUsageByConditions("appId", DevLog.class);
        long end = System.currentTimeMillis();
        logger.info("\u7edf\u8ba1es\u78c1\u76d8\u4f7f\u7528\u60c5\u51b5\u5b8c\u6210,\u8017\u65f6(ms):{}", (Object)(end - start));
        if (Objects.isNull(esStatisticsDiskUsageResponse) || CollectionUtils.isEmpty((Collection)esStatisticsDiskUsageResponse.getDiskUsageList())) {
            logger.warn("\u7edf\u8ba1es\u78c1\u76d8\u4f7f\u7528\u60c5\u51b5\u8fd4\u56de\u4e3a\u7a7a!");
            return;
        }
        esStatisticsDiskUsageResponse.getDiskUsageList().forEach(esStatisticsDiskUsageResult -> {
            StatsDiskDetail statsDiskDetail = new StatsDiskDetail();
            statsDiskDetail.setAppId(esStatisticsDiskUsageResult.getKey());
            statsDiskDetail.setSize(Long.valueOf(esStatisticsDiskUsageResult.getDiskUsage()));
            statsDiskDetail.setQueryTime(LocalDateTime.now());
            this.insert((BaseEntity)statsDiskDetail);
        });
    }
}

