/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.service.business.impl;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.LogCountVO;
import com.digiwin.dap.middleware.lmc.domain.elasticsearch.ExecuteDTO;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.repository.ActionSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.DevLogRepository;
import com.digiwin.dap.middleware.lmc.repository.EventLogRepository;
import com.digiwin.dap.middleware.lmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.lmc.service.business.AppSettingService;
import com.digiwin.dap.middleware.lmc.support.cache.MongoDistributedLockV2;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsSearchResult;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.HitsResult;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Total;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AppSettingServiceImpl
implements AppSettingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSettingServiceImpl.class);
    private static final String GROUP_BY_FIELD = "group_by_field";
    private static final String TOTAL_APP = "totalApp";
    private static final String CAT_INDICES_V_S_INDEX = "/_cat/indices?v&s=index";
    public static final long EXPIRE_MILLIS = 5L;
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private ActionSettingRepository actionSettingRepository;
    @Autowired
    protected OpLogRepository opLogRepository;
    @Autowired
    protected EventLogRepository eventLogRepository;
    @Autowired
    protected DevLogRepository devLogRepository;
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Autowired
    private IElasticsearchService elasticsearchService;
    @Autowired
    private MongoDistributedLockV2 mongoDistributedLockV2;
    @Autowired
    private EnvProperties envProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Cacheable(cacheNames={"lmc:appSetting"}, key="#appId", unless="#result == null")
    public AppSetting checkAndSaveDefaultAppSetting(String appId) {
        boolean lock = this.mongoDistributedLockV2.getLock(String.format("lmc-appsetting-insert-appid-%s", appId), 5L);
        if (lock) {
            AppSetting app;
            block5: {
                AppSetting appSetting;
                try {
                    app = (AppSetting)this.appSettingRepository.findOne((BaseEntity)new AppSetting(appId));
                    if (app == null) break block5;
                    appSetting = app;
                }
                catch (Throwable throwable) {
                    this.mongoDistributedLockV2.releaseLock(String.format("lmc-appsetting-insert-appid-%s", appId));
                    throw throwable;
                }
                this.mongoDistributedLockV2.releaseLock(String.format("lmc-appsetting-insert-appid-%s", appId));
                return appSetting;
            }
            app = AppSetting.of((String)appId, (String)appId);
            app = (AppSetting)this.appSettingRepository.insert((BaseEntity)app);
            if (!this.mongoTemplate.collectionExists(this.appSettingRepository.checkCollectionName(appId + "_devlog"))) {
                this.mongoTemplate.createCollection(this.appSettingRepository.checkCollectionName(appId + "_devlog"));
            }
            this.createIndex();
            AppSetting appSetting = app;
            this.mongoDistributedLockV2.releaseLock(String.format("lmc-appsetting-insert-appid-%s", appId));
            return appSetting;
        }
        return (AppSetting)this.appSettingRepository.findOne((BaseEntity)new AppSetting(appId));
    }

    @CacheEvict(cacheNames={"lmc:appSetting"}, key="#appId", allEntries=true)
    public void deleteByAppId(String appId) {
        this.appSettingRepository.deleteByQuery(Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId)));
        this.actionSettingRepository.deleteByAppId(appId);
    }

    @CacheEvict(cacheNames={"lmc:appSetting"}, allEntries=true)
    public void deleteAllCache() {
        LOGGER.info("\u5220\u9664\u6240\u6709\u7684 app \u7f13\u5b58\u6210\u529f\uff01 {}", (Object)LocalDateTime.now());
    }

    public void createIndex() {
        Set collectionNames = this.mongoTemplate.getCollectionNames();
        collectionNames.forEach(collectionName -> {
            List indexInfos = this.mongoTemplate.indexOps(collectionName).getIndexInfo();
            if (collectionName.endsWith("_devlog")) {
                this.createInboxIndexByKey(collectionName, indexInfos, "appId");
                this.createInboxIndexByKey(collectionName, indexInfos, "time");
                this.createInboxIndexByKey(collectionName, indexInfos, "traceId");
                this.createInboxIndexByKey(collectionName, indexInfos, "loggerName");
                this.createInboxIndexByKey(collectionName, indexInfos, "level");
            } else if (collectionName.endsWith("_eventlog") || collectionName.endsWith("_oplog")) {
                this.createInboxIndexByKey(collectionName, indexInfos, "appId");
                this.createInboxIndexByKey(collectionName, indexInfos, "createDate");
                this.createInboxIndexByKey(collectionName, indexInfos, "tenantId");
                if (collectionName.equals("digiwincloud_oplog")) {
                    this.createInboxIndexByKey(collectionName, indexInfos, "editTime");
                    this.createInboxIndexByKey(collectionName, indexInfos, "source");
                    this.createInboxIndexByKey(collectionName, indexInfos, "primaryKey");
                } else {
                    this.createInboxIndexByKey(collectionName, indexInfos, "eventType");
                    this.createInboxIndexByKey(collectionName, indexInfos, "userId");
                }
            } else if ("stats_count_detail".equals(collectionName)) {
                this.createInboxIndexByKey(collectionName, indexInfos, "createDate");
            }
        });
    }

    public Map<String, Object> getLogsCount() {
        LogCountVO countVO;
        List apps = this.appSettingRepository.findAll();
        if (apps.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, LogCountVO> appMap = new LinkedHashMap<String, LogCountVO>();
        Query emptyQuery = new Query();
        long totalDevLogCount = 0L;
        long totalEventLogCount = 0L;
        long totalOpLogCount = 0L;
        long totalTodayLogCount = 0L;
        long totalLast1DayLogCount = 0L;
        long totalLast3DayLogCount = 0L;
        for (AppSetting app : apps) {
            long devLogCount = this.devLogRepository.count(emptyQuery, app.getAppId() + "_devlog");
            long eventLogCount = this.eventLogRepository.count(emptyQuery, app.getAppId() + "_eventlog");
            long opLogCount = this.opLogRepository.count(emptyQuery, app.getAppId() + "_oplog");
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime timeStartTemporal = now.withHour(0).withMinute(0).withSecond(0);
            String timeStart = DateConstant.DATE_TIME_FORMATTER.format(timeStartTemporal);
            String timeEnd = DateConstant.DATE_TIME_FORMATTER.format(now);
            Criteria devCriteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"time").gte((Object)timeStart), Criteria.where((String)"time").lte((Object)timeEnd)});
            Query devQuery = new Query((CriteriaDefinition)devCriteria);
            Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"createDate").gte((Object)timeStartTemporal), Criteria.where((String)"createDate").lte((Object)now)});
            Query query = new Query((CriteriaDefinition)criteria);
            long todayDevLogCount = this.devLogRepository.count(devQuery, app.getAppId() + "_devlog");
            long todayEventLogCount = this.eventLogRepository.count(query, app.getAppId() + "_eventlog");
            long todayOpLogCount = this.opLogRepository.count(query, app.getAppId() + "_oplog");
            timeStartTemporal = now.minusDays(1L);
            timeStart = DateConstant.DATE_TIME_FORMATTER.format(timeStartTemporal);
            devCriteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"time").gte((Object)timeStart), Criteria.where((String)"time").lte((Object)timeEnd)});
            devQuery = new Query((CriteriaDefinition)devCriteria);
            criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"createDate").gte((Object)timeStartTemporal), Criteria.where((String)"createDate").lte((Object)now)});
            query = new Query((CriteriaDefinition)criteria);
            long last1DayDevLogCount = this.devLogRepository.count(devQuery, app.getAppId() + "_devlog");
            long last1DayEventLogCount = this.eventLogRepository.count(query, app.getAppId() + "_eventlog");
            long last1DayOpLogCount = this.opLogRepository.count(query, app.getAppId() + "_oplog");
            timeStartTemporal = now.minusDays(3L);
            timeStart = DateConstant.DATE_TIME_FORMATTER.format(timeStartTemporal);
            devCriteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"time").gte((Object)timeStart), Criteria.where((String)"time").lte((Object)timeEnd)});
            devQuery = new Query((CriteriaDefinition)devCriteria);
            criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"createDate").gte((Object)timeStartTemporal), Criteria.where((String)"createDate").lte((Object)now)});
            query = new Query((CriteriaDefinition)criteria);
            long last3DayDevLogCount = this.devLogRepository.count(devQuery, app.getAppId() + "_devlog");
            long last3DayEventLogCount = this.eventLogRepository.count(query, app.getAppId() + "_eventlog");
            long last3DayOpLogCount = this.opLogRepository.count(query, app.getAppId() + "_oplog");
            countVO = new LogCountVO();
            countVO.setDevLog(Long.valueOf(devLogCount));
            countVO.setEventLog(Long.valueOf(eventLogCount));
            countVO.setOpLog(Long.valueOf(opLogCount));
            countVO.setLast3DayLogCount(Long.valueOf(last3DayDevLogCount + last3DayEventLogCount + last3DayOpLogCount));
            countVO.setLast1DayLogCount(Long.valueOf(last1DayDevLogCount + last1DayEventLogCount + last1DayOpLogCount));
            countVO.setTodayLogCount(Long.valueOf(todayDevLogCount + todayEventLogCount + todayOpLogCount));
            countVO.setTotal(Long.valueOf(devLogCount + eventLogCount + opLogCount));
            totalDevLogCount += devLogCount;
            totalEventLogCount += eventLogCount;
            totalOpLogCount += opLogCount;
            totalLast3DayLogCount += last3DayDevLogCount + last3DayEventLogCount + last3DayOpLogCount;
            totalLast1DayLogCount += last1DayDevLogCount + last1DayEventLogCount + last1DayOpLogCount;
            totalTodayLogCount += todayDevLogCount + todayEventLogCount + todayOpLogCount;
            appMap.put(app.getAppId(), countVO);
        }
        appMap.entrySet().removeIf(entry -> ((LogCountVO)entry.getValue()).ifEmpty());
        List<LogCountVO> sortedValues = appMap.values().stream().sorted(Comparator.comparing(LogCountVO::getDevLog).reversed()).collect(Collectors.toList());
        LinkedHashMap<String, LogCountVO> sortedMap = new LinkedHashMap<String, LogCountVO>();
        sortedValues.forEach(vo -> sortedMap.put(this.findKeyByValue(appMap, vo), (LogCountVO)vo));
        countVO = new LogCountVO();
        countVO.setDevLog(Long.valueOf(totalDevLogCount));
        countVO.setEventLog(Long.valueOf(totalEventLogCount));
        countVO.setOpLog(Long.valueOf(totalOpLogCount));
        countVO.setLast3DayLogCount(Long.valueOf(totalLast3DayLogCount));
        countVO.setLast1DayLogCount(Long.valueOf(totalLast1DayLogCount));
        countVO.setTodayLogCount(Long.valueOf(totalTodayLogCount));
        countVO.setTotal(Long.valueOf(totalDevLogCount + totalEventLogCount + totalOpLogCount));
        sortedMap.put("totalApp", countVO);
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        dbMap.put("mongoDB", sortedMap);
        if (!this.envProperties.ifEs()) {
            return dbMap;
        }
        LinkedHashMap<String, LogCountVO> esAppMap = new LinkedHashMap<String, LogCountVO>();
        ExecuteDTO executeDTO = new ExecuteDTO();
        executeDTO.setMethod(HttpMethod.POST.name());
        LinkedHashMap<String, Object> dslMap = new LinkedHashMap<String, Object>();
        dslMap.put("track_total_hits", true);
        dslMap.put("size", 0);
        LogCountVO totalAppCountVO = new LogCountVO();
        for (LogTypeEnum anEnum : LogTypeEnum.values()) {
            Map aggregations;
            EsSearchResult totalEsSearchResult;
            EsSearchResult last3DayEsSearchResult;
            EsSearchResult last1DayEsSearchResult;
            EsSearchResult todayEsSearchResult;
            executeDTO.setEndpoint(anEnum.getAliasName() + "/_search");
            executeDTO.setDslMap(dslMap);
            if (LogTypeEnum.ESP_LOG.equals((Object)anEnum)) {
                dslMap.put("aggs", Collections.emptyMap());
            } else {
                HashMap<String, Object> termsMap = new HashMap<String, Object>();
                termsMap.put("field", "appId");
                termsMap.put("size", 1000);
                dslMap.put("aggs", Collections.singletonMap("group_by_field", Collections.singletonMap("terms", termsMap)));
            }
            LocalDateTime now = LocalDateTime.now();
            String timeStart = DateConstant.DATE_TIME_NORM_DATETIME_MS.format(now.withHour(0).withMinute(0).withSecond(0).withNano(0));
            String timeEnd = DateConstant.DATE_TIME_NORM_DATETIME_MS.format(now);
            HashMap queryMap = new HashMap();
            HashMap<String, String> timeMap = new HashMap<String, String>();
            queryMap.put("bool", Collections.singletonMap("filter", Collections.singletonList(Collections.singletonMap("range", Collections.singletonMap(anEnum.getCreateDateName(), timeMap)))));
            timeMap.put("gte", timeStart);
            timeMap.put("lte", timeEnd);
            dslMap.put("query", queryMap);
            String todayResponseBody = this.elasticsearchService.executeDsl(executeDTO.getDslMap(), executeDTO.getMethod(), executeDTO.getEndpoint());
            try {
                todayEsSearchResult = (EsSearchResult)JsonUtils.createObjectMapper().readValue(todayResponseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (JsonProcessingException e) {
                throw new BusinessException("Elasticsearch DSL search responseBody Json Processing Exception", (Throwable)e);
            }
            long toDayTotalLogCount = Optional.ofNullable(todayEsSearchResult.getHits()).map(HitsResult::getTotal).map(Total::getValue).orElse(0L);
            totalAppCountVO.setTodayLogCount(Long.valueOf(Optional.ofNullable(totalAppCountVO.getTodayLogCount()).orElse(0L) + toDayTotalLogCount));
            Map todayAggregations = todayEsSearchResult.getAggregations();
            if (todayAggregations != null) {
                Map todaygroupByField = (Map)todayAggregations.get("group_by_field");
                List todaybuckets = (List)todaygroupByField.get("buckets");
                for (Map bucket : todaybuckets) {
                    LogCountVO vo2 = esAppMap.getOrDefault(bucket.get("key"), new LogCountVO());
                    Integer docCount = (Integer)bucket.get("doc_count");
                    vo2.setTodayLogCount(Long.valueOf(Optional.ofNullable(vo2.getTodayLogCount()).orElse(0L) + (long)docCount.intValue()));
                    esAppMap.put((String)bucket.get("key"), vo2);
                }
            }
            timeStart = DateConstant.DATE_TIME_NORM_DATETIME_MS.format(now.minusDays(1L));
            timeMap.put("gte", timeStart);
            String last1DayResponseBody = this.elasticsearchService.executeDsl(executeDTO.getDslMap(), executeDTO.getMethod(), executeDTO.getEndpoint());
            try {
                last1DayEsSearchResult = (EsSearchResult)JsonUtils.createObjectMapper().readValue(last1DayResponseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (JsonProcessingException e) {
                throw new BusinessException("Elasticsearch DSL search responseBody Json Processing Exception", (Throwable)e);
            }
            long last1DayTotalLogCount = Optional.ofNullable(last1DayEsSearchResult.getHits()).map(HitsResult::getTotal).map(Total::getValue).orElse(0L);
            totalAppCountVO.setLast1DayLogCount(Long.valueOf(Optional.ofNullable(totalAppCountVO.getLast1DayLogCount()).orElse(0L) + last1DayTotalLogCount));
            Map last1DayAggregations = last1DayEsSearchResult.getAggregations();
            if (last1DayAggregations != null) {
                Map last1DayGroupByField = (Map)last1DayAggregations.get("group_by_field");
                List last1Daybuckets = (List)last1DayGroupByField.get("buckets");
                for (Map bucket : last1Daybuckets) {
                    LogCountVO vo3 = esAppMap.getOrDefault(bucket.get("key"), new LogCountVO());
                    Integer docCount = (Integer)bucket.get("doc_count");
                    vo3.setLast1DayLogCount(Long.valueOf(Optional.ofNullable(vo3.getLast1DayLogCount()).orElse(0L) + (long)docCount.intValue()));
                    esAppMap.put((String)bucket.get("key"), vo3);
                }
            }
            timeStart = DateConstant.DATE_TIME_NORM_DATETIME_MS.format(now.minusDays(3L));
            timeMap.put("gte", timeStart);
            String last3DayResponseBody = this.elasticsearchService.executeDsl(executeDTO.getDslMap(), executeDTO.getMethod(), executeDTO.getEndpoint());
            try {
                last3DayEsSearchResult = (EsSearchResult)JsonUtils.createObjectMapper().readValue(last3DayResponseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (JsonProcessingException e) {
                throw new BusinessException("Elasticsearch DSL search responseBody Json Processing Exception", (Throwable)e);
            }
            long last3DayTotalLogCount = Optional.ofNullable(last3DayEsSearchResult.getHits()).map(HitsResult::getTotal).map(Total::getValue).orElse(0L);
            totalAppCountVO.setLast3DayLogCount(Long.valueOf(Optional.ofNullable(totalAppCountVO.getLast3DayLogCount()).orElse(0L) + last3DayTotalLogCount));
            Map last3DayAggregations = last3DayEsSearchResult.getAggregations();
            if (last3DayAggregations != null) {
                Map last3DayGroupByField = (Map)last3DayAggregations.get("group_by_field");
                List last3Daybuckets = (List)last3DayGroupByField.get("buckets");
                for (Map bucket : last3Daybuckets) {
                    LogCountVO vo4 = esAppMap.getOrDefault(bucket.get("key"), new LogCountVO());
                    Integer docCount = (Integer)bucket.get("doc_count");
                    vo4.setLast3DayLogCount(Long.valueOf(Optional.ofNullable(vo4.getLast3DayLogCount()).orElse(0L) + (long)docCount.intValue()));
                    esAppMap.put((String)bucket.get("key"), vo4);
                }
            }
            dslMap.remove("query");
            String totalResponseBody = this.elasticsearchService.executeDsl(executeDTO.getDslMap(), executeDTO.getMethod(), executeDTO.getEndpoint());
            try {
                totalEsSearchResult = (EsSearchResult)JsonUtils.createObjectMapper().readValue(totalResponseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (JsonProcessingException e) {
                throw new BusinessException("Elasticsearch DSL search responseBody Json Processing Exception", (Throwable)e);
            }
            long totalLogCount = Optional.ofNullable(totalEsSearchResult.getHits()).map(HitsResult::getTotal).map(Total::getValue).orElse(0L);
            if (LogTypeEnum.ESP_LOG.equals((Object)anEnum)) {
                totalAppCountVO.setEspLog(Long.valueOf(totalLogCount));
            }
            if (LogTypeEnum.DEV_LOG.equals((Object)anEnum)) {
                totalAppCountVO.setDevLog(Long.valueOf(totalLogCount));
            }
            if (LogTypeEnum.OP_LOG.equals((Object)anEnum)) {
                totalAppCountVO.setOpLog(Long.valueOf(totalLogCount));
            }
            if (LogTypeEnum.EVENT_LOG.equals((Object)anEnum)) {
                totalAppCountVO.setEventLog(Long.valueOf(totalLogCount));
            }
            if ((aggregations = totalEsSearchResult.getAggregations()) == null) continue;
            Map groupByField = (Map)aggregations.get("group_by_field");
            List buckets = (List)groupByField.get("buckets");
            for (Map bucket : buckets) {
                LogCountVO totalCountVO = esAppMap.getOrDefault(bucket.get("key"), new LogCountVO());
                Integer docCount = (Integer)bucket.get("doc_count");
                if (LogTypeEnum.DEV_LOG.equals((Object)anEnum)) {
                    totalCountVO.setDevLog(Long.valueOf(docCount.intValue()));
                }
                if (LogTypeEnum.OP_LOG.equals((Object)anEnum)) {
                    totalCountVO.setOpLog(Long.valueOf(docCount.intValue()));
                }
                if (LogTypeEnum.EVENT_LOG.equals((Object)anEnum)) {
                    totalCountVO.setEventLog(Long.valueOf(docCount.intValue()));
                }
                totalCountVO.setTotal(Long.valueOf(Optional.ofNullable(totalCountVO.getTotal()).orElse(0L) + (long)docCount.intValue()));
                esAppMap.put((String)bucket.get("key"), totalCountVO);
            }
        }
        totalAppCountVO.setTotal(Long.valueOf(totalAppCountVO.getDevLog() + totalAppCountVO.getEventLog() + totalAppCountVO.getOpLog() + totalAppCountVO.getEspLog()));
        esAppMap.put("totalApp", totalAppCountVO);
        dbMap.put("elasticsearch", esAppMap);
        String indexStorageSpace = this.elasticsearchService.executeDsl((String)null, HttpMethod.GET.name(), "/_cat/indices?v&s=index");
        if (indexStorageSpace != null) {
            List indexStorageSpaceMap = AppSettingServiceImpl.getStorageSpaceMap((String)indexStorageSpace);
            dbMap.put("indexStorageSpace", indexStorageSpaceMap);
        }
        return dbMap;
    }

    private String findKeyByValue(Map<String, LogCountVO> map, LogCountVO value) {
        for (Map.Entry<String, LogCountVO> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    private static List<Map<String, String>> getStorageSpaceMap(String indexStorageSpace) {
        ArrayList<Map<String, String>> indexStorageSpaceMap = new ArrayList<Map<String, String>>();
        String[] split = indexStorageSpace.split("\n");
        if (split.length > 1) {
            String[] keyArray = split[0].split("\\s+");
            for (int i = 1; i < split.length; ++i) {
                LinkedHashMap<String, String> splitMap = new LinkedHashMap<String, String>();
                String[] fieldsArray = split[i].split("\\s+");
                for (int j = 0; j < fieldsArray.length; ++j) {
                    String key = keyArray[j].replace(".", "_");
                    splitMap.put(key, fieldsArray[j]);
                }
                indexStorageSpaceMap.add(splitMap);
            }
        }
        return indexStorageSpaceMap;
    }

    private void createInboxIndexByKey(String collectionName, List<IndexInfo> indexInfos, String key) {
        boolean noneIndex = indexInfos.stream().noneMatch(indexInfo -> indexInfo.getIndexFields().stream().allMatch(indexField -> indexField.getKey().equals(key)));
        if (noneIndex) {
            this.createInboxIndex(key, collectionName);
        }
    }

    private boolean createInboxIndex(String indexKey, String collectionName) {
        boolean scuess = true;
        try {
            Index index = new Index();
            index.on(indexKey, Sort.Direction.ASC);
            this.mongoTemplate.indexOps(collectionName).ensureIndex((IndexDefinition)index);
        }
        catch (Exception ex) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25 collectionName={}, indexKey={}", new Object[]{collectionName, indexKey, ex});
            scuess = false;
        }
        return scuess;
    }
}

