/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.service.esp.log.impl;

import com.digiwin.dap.middleware.commons.util.FreemarkerUtils;
import com.digiwin.dap.middleware.lmc.domain.esplog.CreateEspLogDTO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EaiLogVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspErrorInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogAggregationDTO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogChainInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogDetailsVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogIncludeChainInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogResponseCodeTabInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogReturnSummaryTabInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogServiceRequestSummaryTabInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspLogTabInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspRequestInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspServiceInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspSolutionInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspVisualInspectionInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.EspVisualInspectionLineInfo;
import com.digiwin.dap.middleware.lmc.domain.esplog.PageEspLogIncludeChainInfoVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.PageEspLogVO;
import com.digiwin.dap.middleware.lmc.domain.esplog.PageQueryEspLogDTO;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspEaiLogsLogs;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspEaiLogsResponse;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspSolutionRequest;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspStateCodeResponse;
import com.digiwin.dap.middleware.lmc.entity.esplog.EspLog;
import com.digiwin.dap.middleware.lmc.service.esp.log.IEspLogService;
import com.digiwin.dap.middleware.lmc.service.messaging.impl.KafkaMessagePublisher;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsPageSearchResponse;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsSearchResponse;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.lmc.support.remote.IEspService;
import com.digiwin.dap.middleware.lmc.support.remote.thirdparty.RemotePinpiontService;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.digiwin.dap.middleware.lmc.util.compression.algorithm.ICompressionAlgorithm;
import com.digiwin.dap.middleware.util.DateUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EspLogServiceElasticsearchImpl
implements IEspLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EspLogServiceElasticsearchImpl.class);
    private static final String HEADER_DIGI_HOST = "digi-host";
    private static final String HEADER_DIGI_SERVICE = "digi-service";
    private static final String HEADER_DIGI_CODE = "digi-code";
    private static final String HEADER_DIGI_MESSAGE = "digi-message";
    private static final String HEADER_DIGI_SRV_CODE = "digi-srvcode";
    private static final String HEADER_DIGI_SRV_VER = "digi-srvver";
    private static final String HEADER_DIGI_TYPE = "digi-type";
    private static final String HEADER_DIGI_DAP_SERVICE_CHAIN_INFO = "digi-dap-service-chain-info";
    private static final String HEADER_DIGI_DAP_SERVICE_CHAIN_TARGET_ID = "digi-dap-service-chain-target-id";
    private static final String HEADER_DIGI_CALLBACK_DAP_SERVICE_CHAIN_INFO = "digi-callback-dap-service-chain-info";
    private static final String DECENTRALIZATION_STATE_CODE = "D00";
    private static final String CLIENT_STATE_CODE = "0C4,0F4";
    private static final String IS_SYNC = "sync";
    @Autowired
    private IElasticsearchService elasticsearchService;
    @Autowired(required=false)
    private KafkaMessagePublisher messagePublisher;
    @Autowired
    private RemotePinpiontService remotePinpiontService;
    @Value(value="${spring.kafka.topic.esp-log}")
    private String topic;
    @Value(value="${spring.kafka.max.request.size}")
    private Long maxRequestSize;
    @Value(value="${dap.middleware.dev.mmc.uri:}")
    private String devMmcUri;
    @Autowired
    @Qualifier(value="gzipCompressionAlgorithm")
    private ICompressionAlgorithm compressionAlgorithm;
    @Autowired
    private IEspService espService;

    public void batchSaveEspLog(List<CreateEspLogDTO> dtoList) {
        if (dtoList == null || dtoList.isEmpty()) {
            return;
        }
        List espLogList = dtoList.stream().map(arg_0 -> this.buildEspLog(arg_0)).collect(Collectors.toList());
        this.elasticsearchService.bulkIndex(espLogList);
    }

    public void saveEspLog(CreateEspLogDTO dto) {
        boolean isPublisherKafka;
        if (dto == null) {
            return;
        }
        EspLog espLog = this.buildEspLog(dto);
        boolean bl = isPublisherKafka = null != this.messagePublisher && espLog.getMessageSize() != null && espLog.getMessageSize().multiply(new BigDecimal("1024")).longValue() < this.maxRequestSize;
        if (isPublisherKafka) {
            this.messagePublisher.publish(JsonUtils.writeValueAsString((Object)dto), this.topic, "");
            return;
        }
        this.elasticsearchService.index((Document)espLog);
    }

    public void asyncSaveEspLog(CreateEspLogDTO dto) {
        this.elasticsearchService.asyncIndex((Document)this.buildEspLog(dto));
    }

    public PageData<PageEspLogVO> queryEspLogEsForPage(PageQueryEspLogDTO dto) {
        if (dto == null) {
            return new PageData();
        }
        ArrayList<Object> queryBuilderList = new ArrayList<Object>();
        if (StringUtils.hasLength((String)dto.getRequestId())) {
            queryBuilderList.add(QueryBuilders.termQuery((String)"reqId", (String)StringUtils.trimAllWhitespace((String)dto.getRequestId())));
        } else {
            if (StringUtils.hasLength((String)dto.getStartTime()) && StringUtils.hasLength((String)dto.getEndTime())) {
                queryBuilderList.add(QueryBuilders.rangeQuery((String)"platformTime").gte((Object)(dto.getStartTime() + ".000")).lte((Object)(dto.getEndTime() + ".999")));
            }
            if (StringUtils.hasLength((String)dto.getTenantId())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"tenantId", (String)dto.getTenantId()));
            }
            if (StringUtils.hasLength((String)dto.getRequest())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"request", (String)dto.getRequest()));
            }
            if (StringUtils.hasLength((String)dto.getRequestApIp())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"requestApIp", (String)dto.getRequestApIp()));
            }
            if (StringUtils.hasLength((String)dto.getRequestApId())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"requestApId", (String)dto.getRequestApId()));
            }
            if (StringUtils.hasLength((String)dto.getRequestApUid())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"requestApUid", (String)dto.getRequestApUid()));
            }
            if (StringUtils.hasLength((String)dto.getService())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"service", (String)dto.getService()));
            }
            if (StringUtils.hasLength((String)dto.getServiceApIp())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"serviceApIp", (String)dto.getServiceApIp()));
            }
            if (StringUtils.hasLength((String)dto.getServiceApId())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"serviceApId", (String)dto.getServiceApId()));
            }
            if (StringUtils.hasLength((String)dto.getServiceApUid())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"serviceApUid", (String)dto.getServiceApUid()));
            }
            if (StringUtils.hasLength((String)dto.getServiceName())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"serviceName", (String)dto.getServiceName()));
            }
            if (StringUtils.hasLength((String)dto.getServiceDescription())) {
                queryBuilderList.add(QueryBuilders.wildcardQuery((String)"serviceDescription", (String)("*" + dto.getServiceDescription() + "*")));
            }
            if (StringUtils.hasLength((String)dto.getStateCode())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"stateCode", (String)dto.getStateCode()));
            }
            if (StringUtils.hasLength((String)dto.getDataKey())) {
                queryBuilderList.add(QueryBuilders.wildcardQuery((String)"dataKey", (String)("*" + dto.getDataKey() + "*")));
            }
            if (StringUtils.hasLength((String)dto.getState())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"state", (String)dto.getState()));
            }
            if (StringUtils.hasLength((String)dto.getPinpointId())) {
                queryBuilderList.add(QueryBuilders.termQuery((String)"pinpointId", (String)dto.getPinpointId()));
            }
        }
        ArrayList<SortBuilder> sorts = new ArrayList<SortBuilder>();
        if (StringUtils.hasLength((String)dto.getOrderField()) && StringUtils.hasLength((String)dto.getOrderType())) {
            sorts.add(SortBuilders.fieldSort((String)dto.getOrderField()).order(SortOrder.fromString((String)dto.getOrderType())));
        } else {
            sorts.add(SortBuilders.fieldSort((String)"platformTime").order(SortOrder.DESC));
        }
        String[] excludeFields = new String[]{"compressedMessage"};
        EsPageSearchResponse esPageSearchResponse = this.elasticsearchService.pageSearch(queryBuilderList, sorts, dto.getPageNum(), dto.getPageSize(), Boolean.valueOf(true), excludeFields, EspLog.class);
        if (CollectionUtils.isEmpty((Collection)esPageSearchResponse.getDataList())) {
            return new PageData();
        }
        List espStateCodeResponseList = this.espService.getStateCodes();
        HashMap espStateCodeMap = !CollectionUtils.isEmpty((Collection)espStateCodeResponseList) ? espStateCodeResponseList.stream().collect(Collectors.toMap(EspStateCodeResponse::getCode, x -> x, (a, b) -> b)) : new HashMap();
        List pageEspLogVOList = esPageSearchResponse.getDataList().stream().map(x -> this.buildEspLogVO(x, espStateCodeMap)).collect(Collectors.toList());
        PageData pageData = new PageData();
        pageData.setTotal(esPageSearchResponse.getTotal().longValue());
        pageData.setList(pageEspLogVOList);
        return pageData;
    }

    public EspLogDetailsVO listEspLogByReqId(String redId) {
        Integer middlewareServiceTime1;
        EspLogDetailsVO espLogDetailsVO = new EspLogDetailsVO();
        ArrayList<TermQueryBuilder> queryBuilderList = new ArrayList<TermQueryBuilder>();
        queryBuilderList.add(QueryBuilders.termQuery((String)"reqId", (String)redId));
        EsSearchResponse esSearchResponse = this.elasticsearchService.listSearch(queryBuilderList, null, EspLog.class);
        if (Objects.isNull(esSearchResponse) || CollectionUtils.isEmpty((Collection)esSearchResponse.getDataList())) {
            return null;
        }
        List espLogList = esSearchResponse.getDataList().stream().sorted(Comparator.comparingInt(EspLog::getLogDisplayPriority)).collect(Collectors.toList());
        List espStateCodeResponseList = this.espService.getStateCodes();
        HashMap espStateCodeMap = !CollectionUtils.isEmpty((Collection)espStateCodeResponseList) ? espStateCodeResponseList.stream().collect(Collectors.toMap(EspStateCodeResponse::getCode, x -> x, (a, b) -> b)) : new HashMap();
        List stateCodeList = espLogList.stream().map(EspLog::getStateCode).collect(Collectors.toList());
        espLogDetailsVO.setStateCodeList(stateCodeList);
        List logDisplayPriorityList = espLogList.stream().map(EspLog::getLogDisplayPriority).collect(Collectors.toList());
        boolean isDecentralization = !CollectionUtils.isEmpty(stateCodeList) && stateCodeList.contains(DECENTRALIZATION_STATE_CODE);
        boolean isSync = IS_SYNC.equals(this.analyzeRequestHeaderFromMessage(new String(this.compressionAlgorithm.unCompress(((EspLog)espLogList.get(0)).getCompressedMessage()), StandardCharsets.UTF_8), HEADER_DIGI_TYPE));
        espLogDetailsVO.setUrl(this.devMmcUri + "/logger-manager-center/esp-logger?requestId=" + redId);
        ArrayList<EspLogTabInfoVO> espLogTabInfoVOS = new ArrayList<EspLogTabInfoVO>();
        for (EspLog espLog2 : espLogList) {
            EspLogTabInfoVO espLogTabInfoVO = new EspLogTabInfoVO(espLog2.getStateCode(), espLog2.getStepNumber());
            String message = new String(this.compressionAlgorithm.unCompress(espLog2.getCompressedMessage()), StandardCharsets.UTF_8);
            String digiHost = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_HOST);
            String digiService = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_SERVICE);
            String digiCode = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_CODE);
            String digiMessage = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_MESSAGE);
            String digiSrvCode = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_SRV_CODE);
            String digiSrvVer = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_SRV_VER);
            if (StringUtils.hasLength((String)digiHost) && StringUtils.hasLength((String)digiService)) {
                EspLogServiceRequestSummaryTabInfoVO espLogServiceRequestSummaryTabInfoVO = new EspLogServiceRequestSummaryTabInfoVO();
                espLogServiceRequestSummaryTabInfoVO.setEspRequestInfo(new EspRequestInfoVO(JsonUtils.readValue((String)digiHost, HashMap.class)));
                espLogServiceRequestSummaryTabInfoVO.setEspServiceInfo(new EspServiceInfoVO(JsonUtils.readValue((String)digiService, HashMap.class)));
                espLogTabInfoVO.setServiceRequestSummary(espLogServiceRequestSummaryTabInfoVO);
            }
            if (StringUtils.hasLength((String)digiCode) && StringUtils.hasLength((String)digiMessage)) {
                EspLogReturnSummaryTabInfoVO espLogReturnSummaryTabInfoVO = new EspLogReturnSummaryTabInfoVO(espLog2.getStateCode(), espLog2.getStepNumber());
                espLogReturnSummaryTabInfoVO.setCode(digiCode);
                espLogReturnSummaryTabInfoVO.setMessage(new String(Base64.getDecoder().decode(digiMessage.getBytes(StandardCharsets.UTF_8))));
                espLogTabInfoVO.setReturnSummary(espLogReturnSummaryTabInfoVO);
            }
            if (StringUtils.hasLength((String)digiSrvCode)) {
                EspLogResponseCodeTabInfoVO espLogResponseCodeTabInfoVO = new EspLogResponseCodeTabInfoVO();
                espLogResponseCodeTabInfoVO.setSrvCode(digiSrvCode);
                espLogResponseCodeTabInfoVO.setSrvVer(digiSrvVer);
                espLogTabInfoVO.setResponseCode(espLogResponseCodeTabInfoVO);
            }
            espLogTabInfoVOS.add(espLogTabInfoVO);
        }
        if (isDecentralization) {
            EspLog espLog1 = espLogList.stream().filter(e -> DECENTRALIZATION_STATE_CODE.equals(e.getStateCode())).findFirst().orElse(null);
            EspLog espLog2 = espLogList.stream().filter(e -> "019".equals(e.getStateCode()) || "016".equals(e.getStateCode()) || "0E9".equals(e.getStateCode()) || "0E6".equals(e.getStateCode())).findFirst().orElse(null);
            Integer rightServiceTime = this.calculateServiceTime(espLog1, espLog2);
            Integer leftServiceTime = null;
            if (!isSync) {
                EspLog espLog3 = espLogList.stream().filter(e -> "0EG".equals(e.getStateCode())).findFirst().orElse(null);
                EspLog espLog4 = espLogList.stream().filter(e -> "0EA".equals(e.getStateCode()) || "0EB".equals(e.getStateCode())).findFirst().orElse(null);
                leftServiceTime = this.calculateServiceTime(espLog3, espLog4);
            }
            EspVisualInspectionInfoVO espVisualInspectionInfoVO = new EspVisualInspectionInfoVO();
            espVisualInspectionInfoVO.setRequestAp(Objects.isNull(espLog1) ? null : espLog1.getRequestAp());
            espVisualInspectionInfoVO.setServiceAp(Objects.isNull(espLog2) ? null : espLog2.getServiceAp());
            espVisualInspectionInfoVO.setServiceName(Objects.isNull(espLog2) ? null : espLog2.getServiceName());
            espVisualInspectionInfoVO.setDecentralizationFlag(Boolean.valueOf(isDecentralization));
            espVisualInspectionInfoVO.setSyncFlag(Boolean.valueOf(isSync));
            espVisualInspectionInfoVO.setLogDisplayPriorityList(logDisplayPriorityList);
            espVisualInspectionInfoVO.setRightServiceTime(rightServiceTime);
            espVisualInspectionInfoVO.setLeftServiceTime(leftServiceTime);
            espVisualInspectionInfoVO.setClientFlag(Boolean.valueOf(false));
            espLogDetailsVO.setVisualInspection(espVisualInspectionInfoVO);
            espLogDetailsVO.setEspLogTabList(espLogTabInfoVOS);
            return espLogDetailsVO;
        }
        EspVisualInspectionInfoVO espVisualInspectionInfoVO = new EspVisualInspectionInfoVO();
        espVisualInspectionInfoVO.setLogDisplayPriorityList(logDisplayPriorityList);
        List<EspLog> espLogErrorList = espLogList.stream().filter(e -> "1".equals(e.getState()) || "2".equals(e.getState())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(espLogErrorList)) {
            EspSolutionRequest espSolutionRequest = new EspSolutionRequest();
            espSolutionRequest.setStateCodeList(espLogErrorList.stream().map(EspLog::getStateCode).distinct().collect(Collectors.toList()));
            List espSolutionResponseList = this.espService.getSolution(espSolutionRequest);
            if (!CollectionUtils.isEmpty((Collection)espSolutionResponseList)) {
                ArrayList solutionInfoList = new ArrayList();
                espSolutionResponseList.forEach(espSolutionResponse -> {
                    EspSolutionInfoVO espSolutionInfoVO = new EspSolutionInfoVO();
                    espSolutionInfoVO.setSolutionEnList(espSolutionResponse.getSolutionEn());
                    espSolutionInfoVO.setSolutionZhCnList(espSolutionResponse.getSolutionZhCn());
                    espSolutionInfoVO.setSolutionZhTwList(espSolutionResponse.getSolutionZhTw());
                    if (!CollectionUtils.isEmpty((Collection)espSolutionResponse.getSolutionEn())) {
                        espSolutionInfoVO.setExceptionDescriptionEn(espStateCodeMap.getOrDefault(espSolutionResponse.getStateCode(), new EspStateCodeResponse()).getDescriptionEn());
                        espSolutionInfoVO.setExceptionDescriptionZhCn(espStateCodeMap.getOrDefault(espSolutionResponse.getStateCode(), new EspStateCodeResponse()).getDescriptionZhCn());
                        espSolutionInfoVO.setExceptionDescriptionZhTw(espStateCodeMap.getOrDefault(espSolutionResponse.getStateCode(), new EspStateCodeResponse()).getDescriptionZhTw());
                    }
                    espSolutionInfoVO.setStateCode(espSolutionResponse.getStateCode());
                    solutionInfoList.add(espSolutionInfoVO);
                });
                espVisualInspectionInfoVO.setSolutionInfoList(solutionInfoList);
            }
            espLogErrorList.forEach(espLog -> {
                String message = new String(this.compressionAlgorithm.unCompress(espLog.getCompressedMessage()), StandardCharsets.UTF_8);
                String responseJsonStr = this.analyzeRequestHeaderFromMessage(message, null);
                if (responseJsonStr.contains("execution")) {
                    try {
                        JsonNode responseJson = JsonUtils.createObjectMapper().readTree(responseJsonStr);
                        JsonNode stdData = responseJson.get("std_data");
                        JsonNode execution = stdData.get("execution");
                        EspErrorInfoVO espErrorInfoVO = new EspErrorInfoVO();
                        espErrorInfoVO.setErrorCode(execution.get("code").asText());
                        espErrorInfoVO.setDescription(execution.get("description").asText());
                        espErrorInfoVO.setSqlCode(execution.get("sql_code").asText());
                        espErrorInfoVO.setServiceName(espLog.getServiceName());
                        espVisualInspectionInfoVO.setErrorInfo(espErrorInfoVO);
                    }
                    catch (Exception e) {
                        LOGGER.error("json\u5bf9\u8c61\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                    }
                }
            });
        }
        if (isSync) {
            middlewareServiceTime1 = espLogList.size() >= 2 ? this.calculateServiceTime((EspLog)espLogList.get(0), (EspLog)espLogList.get(1)) : null;
            Integer middlewareServiceTime2 = espLogList.size() >= 4 ? this.calculateServiceTime((EspLog)espLogList.get(2), (EspLog)espLogList.get(3)) : null;
            Integer rightServiceTime = espLogList.size() >= 4 ? this.calculateServiceTime((EspLog)espLogList.get(1), (EspLog)espLogList.get(2)) : null;
            espVisualInspectionInfoVO.setMiddlewareServiceTime1(middlewareServiceTime1);
            espVisualInspectionInfoVO.setMiddlewareServiceTime2(middlewareServiceTime2);
            espVisualInspectionInfoVO.setRightServiceTime(rightServiceTime);
        } else {
            middlewareServiceTime1 = espLogList.size() >= 4 ? Integer.valueOf(this.calculateServiceTime((EspLog)espLogList.get(0), (EspLog)espLogList.get(1)) + this.calculateServiceTime((EspLog)espLogList.get(2), (EspLog)espLogList.get(3))) : null;
            Integer rightServiceTime = espLogList.size() >= 3 ? this.calculateServiceTime((EspLog)espLogList.get(1), (EspLog)espLogList.get(2)) : null;
            Integer middlewareServiceTime2 = espLogList.size() >= 8 ? Integer.valueOf(this.calculateServiceTime((EspLog)espLogList.get(4), (EspLog)espLogList.get(5)) + this.calculateServiceTime((EspLog)espLogList.get(6), (EspLog)espLogList.get(7))) : null;
            Integer leftServiceTime = espLogList.size() >= 7 ? this.calculateServiceTime((EspLog)espLogList.get(5), (EspLog)espLogList.get(6)) : null;
            espVisualInspectionInfoVO.setMiddlewareServiceTime1(middlewareServiceTime1);
            espVisualInspectionInfoVO.setMiddlewareServiceTime2(middlewareServiceTime2);
            espVisualInspectionInfoVO.setRightServiceTime(rightServiceTime);
            espVisualInspectionInfoVO.setLeftServiceTime(leftServiceTime);
        }
        ArrayList<EspVisualInspectionLineInfo> espVisualInspectionLineInfos = new ArrayList<EspVisualInspectionLineInfo>();
        Map<String, List<EspLog>> listMapByStepNumber = espLogList.stream().collect(Collectors.groupingBy(EspLog::getStepNumber));
        espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("1", this.getStateByStepNumber("1", listMapByStepNumber), this.getStateCodeByStepNumber("1", listMapByStepNumber)));
        espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("2", this.getStateByStepNumber("2", listMapByStepNumber), this.getStateCodeByStepNumber("2", listMapByStepNumber)));
        espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("3", this.getStateByStepNumber("3", listMapByStepNumber), this.getStateCodeByStepNumber("3", listMapByStepNumber)));
        espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("4", this.getStateByStepNumber("4", listMapByStepNumber), this.getStateCodeByStepNumber("4", listMapByStepNumber)));
        if (!isSync) {
            espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("5", this.getStateByStepNumber("5", listMapByStepNumber), this.getStateCodeByStepNumber("5", listMapByStepNumber)));
            espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("6", this.getStateByStepNumber("6", listMapByStepNumber), this.getStateCodeByStepNumber("6", listMapByStepNumber)));
            espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("7", this.getStateByStepNumber("7", listMapByStepNumber), this.getStateCodeByStepNumber("7", listMapByStepNumber)));
            espVisualInspectionLineInfos.add(new EspVisualInspectionLineInfo("8", this.getStateByStepNumber("8", listMapByStepNumber), this.getStateCodeByStepNumber("8", listMapByStepNumber)));
        }
        espVisualInspectionInfoVO.setLineInfoList(espVisualInspectionLineInfos);
        espVisualInspectionInfoVO.setRequestAp(((EspLog)espLogList.get(espLogList.size() - 1)).getRequestAp());
        espVisualInspectionInfoVO.setServiceAp(((EspLog)espLogList.get(espLogList.size() - 1)).getServiceAp());
        espVisualInspectionInfoVO.setServiceName(((EspLog)espLogList.get(espLogList.size() - 1)).getServiceName());
        espVisualInspectionInfoVO.setMiddleware("EAI Middleware");
        espVisualInspectionInfoVO.setDecentralizationFlag(Boolean.valueOf(false));
        espVisualInspectionInfoVO.setSyncFlag(Boolean.valueOf(isSync));
        espVisualInspectionInfoVO.setClientFlag(Boolean.valueOf(stateCodeList.stream().anyMatch(Arrays.asList(CLIENT_STATE_CODE.split(","))::contains)));
        espLogDetailsVO.setVisualInspection(espVisualInspectionInfoVO);
        espLogDetailsVO.setEspLogTabList(espLogTabInfoVOS);
        return espLogDetailsVO;
    }

    public String queryRequestMessage(String reqId, String stepNumber, String stateCode, Boolean format) {
        ArrayList<TermQueryBuilder> queryBuilderList = new ArrayList<TermQueryBuilder>();
        queryBuilderList.add(QueryBuilders.termQuery((String)"reqId", (String)reqId));
        EsSearchResponse esSearchResponse = this.elasticsearchService.listSearch(queryBuilderList, null, EspLog.class);
        if (Objects.isNull(esSearchResponse) || CollectionUtils.isEmpty((Collection)esSearchResponse.getDataList())) {
            return null;
        }
        List espLogList = esSearchResponse.getDataList().stream().sorted(Comparator.comparingInt(EspLog::getLogDisplayPriority)).collect(Collectors.toList());
        EspLog espLog = espLogList.stream().filter(x -> Objects.equals(x.getStateCode(), stateCode) && Objects.equals(x.getStepNumber(), stepNumber)).findFirst().orElse(null);
        if (Objects.isNull(espLog)) {
            return null;
        }
        String requestMessage = new String(this.compressionAlgorithm.unCompress(espLog.getCompressedMessage()), StandardCharsets.UTF_8);
        return format != false ? this.formatRequestMessage(requestMessage) : requestMessage;
    }

    public PageData<EaiLogVO> searchEaiLogs(String reqId, String tenantId) {
        EspEaiLogsResponse espEaiLogsResponse = this.espService.getEaiLogs(reqId, tenantId);
        if (Objects.isNull(espEaiLogsResponse) || CollectionUtils.isEmpty((Collection)espEaiLogsResponse.getLogs())) {
            return new PageData();
        }
        Map<Object, Object> espStateCodeMap = new HashMap();
        List espStateCodeResponseList = this.espService.getStateCodes();
        if (!CollectionUtils.isEmpty((Collection)espStateCodeResponseList)) {
            espStateCodeMap = espStateCodeResponseList.stream().collect(Collectors.toMap(EspStateCodeResponse::getCode, x -> x, (a, b) -> b));
        }
        HashMap finalEspStateCodeMap = espStateCodeMap;
        List eaiLogVOList = espEaiLogsResponse.getLogs().stream().map(x -> this.buildEaiLogVO(x, finalEspStateCodeMap)).collect(Collectors.toList());
        PageData pageData = new PageData();
        pageData.setTotal((long)espEaiLogsResponse.getLogs().size());
        pageData.setList(eaiLogVOList);
        return pageData;
    }

    public EspLogIncludeChainInfoVO searchEspLogIncludeChainInfoByPinpointId(String pinpointId) {
        EspLogIncludeChainInfoVO espLogIncludeChainInfoVO = new EspLogIncludeChainInfoVO();
        ArrayList<TermQueryBuilder> queryBuilderList = new ArrayList<TermQueryBuilder>();
        queryBuilderList.add(QueryBuilders.termQuery((String)"pinpointId", (String)pinpointId));
        EsSearchResponse esSearchResponse = this.elasticsearchService.listSearch(queryBuilderList, null, EspLog.class);
        if (Objects.isNull(esSearchResponse) || CollectionUtils.isEmpty((Collection)esSearchResponse.getDataList())) {
            return null;
        }
        List espStateCodeResponseList = this.espService.getStateCodes();
        HashMap espStateCodeMap = !CollectionUtils.isEmpty((Collection)espStateCodeResponseList) ? espStateCodeResponseList.stream().collect(Collectors.toMap(EspStateCodeResponse::getCode, x -> x, (a, b) -> b)) : new HashMap();
        List espLogList = esSearchResponse.getDataList().stream().sorted(Comparator.comparingInt(EspLog::getLogDisplayPriority)).collect(Collectors.toList());
        Map<String, List<EspLog>> espLogListMapByReqId = espLogList.stream().collect(Collectors.groupingBy(EspLog::getReqId));
        ArrayList<EspLogChainInfoVO> logChainInfoList = new ArrayList<EspLogChainInfoVO>();
        for (Map.Entry<String, List<EspLog>> entry : espLogListMapByReqId.entrySet()) {
            List<EspLog> espLogs = entry.getValue();
            List stateCodeList = espLogs.stream().map(EspLog::getStateCode).collect(Collectors.toList());
            boolean isDecentralization = !CollectionUtils.isEmpty(stateCodeList) && stateCodeList.contains(DECENTRALIZATION_STATE_CODE);
            boolean isSync = IS_SYNC.equals(this.analyzeRequestHeaderFromMessage(new String(this.compressionAlgorithm.unCompress(espLogs.get(0).getCompressedMessage()), StandardCharsets.UTF_8), HEADER_DIGI_TYPE));
            for (EspLog espLog : espLogs) {
                if (Objects.isNull(espLog)) continue;
                EspLogChainInfoVO espLogChainInfoVO = this.buildEspLogChainInfoVO(espLog);
                String message = new String(this.compressionAlgorithm.unCompress(espLog.getCompressedMessage()), StandardCharsets.UTF_8);
                String digiDapServiceChainInfo = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_DAP_SERVICE_CHAIN_INFO);
                String digiDapServiceChainTargetId = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_DAP_SERVICE_CHAIN_TARGET_ID);
                String digiCallbackDapServiceChainInfo = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_CALLBACK_DAP_SERVICE_CHAIN_INFO);
                espLogChainInfoVO.setDigiDapServiceChainInfo(digiDapServiceChainInfo);
                espLogChainInfoVO.setDecentralizationFlag(Boolean.valueOf(isDecentralization));
                espLogChainInfoVO.setSyncFlag(Boolean.valueOf(isSync));
                espLogChainInfoVO.setDigiDapServiceChainTargetId(digiDapServiceChainTargetId);
                espLogChainInfoVO.setDigiCallbackDapServiceChainInfo(digiCallbackDapServiceChainInfo);
                espLogChainInfoVO.setOperation(espLog.getOperation());
                espLogChainInfoVO.setLogDisplayPriority(espLog.getLogDisplayPriority());
                if (!CollectionUtils.isEmpty(espStateCodeMap)) {
                    espLogChainInfoVO.setStateCodeValueZhCn(espStateCodeMap.getOrDefault(espLog.getStateCode(), new EspStateCodeResponse()).getDescriptionZhCn());
                    espLogChainInfoVO.setStateCodeValueZhTw(espStateCodeMap.getOrDefault(espLog.getStateCode(), new EspStateCodeResponse()).getDescriptionZhTw());
                    espLogChainInfoVO.setStateCodeValueEn(espStateCodeMap.getOrDefault(espLog.getStateCode(), new EspStateCodeResponse()).getDescriptionEn());
                }
                espLogChainInfoVO.setRequestAp(espLog.getRequestAp());
                logChainInfoList.add(espLogChainInfoVO);
            }
        }
        espLogIncludeChainInfoVO.setLogChainInfoList(logChainInfoList);
        return espLogIncludeChainInfoVO;
    }

    public PageData<PageEspLogIncludeChainInfoVO> pageEspLogIncludeChainInfo(PageQueryEspLogDTO dto) {
        ArrayList<RangeQueryBuilder> queryBuilderList = new ArrayList<RangeQueryBuilder>();
        queryBuilderList.add(QueryBuilders.rangeQuery((String)"platformTime").gte((Object)(dto.getStartTime() + ".000")).lte((Object)(dto.getEndTime() + ".999")));
        ArrayList<SortBuilder> sorts = new ArrayList<SortBuilder>();
        sorts.add(SortBuilders.fieldSort((String)"platformTime").order(SortOrder.DESC));
        EsPageSearchResponse esPageSearchResponse = this.elasticsearchService.pageSearch(queryBuilderList, sorts, dto.getPageNum(), dto.getPageSize(), Boolean.valueOf(true), null, EspLog.class);
        if (CollectionUtils.isEmpty((Collection)esPageSearchResponse.getDataList())) {
            return new PageData();
        }
        List pageEspLogIncludeChainInfoVOS = esPageSearchResponse.getDataList().stream().map(arg_0 -> this.buildPageEspLogIncludeChainInfoVO(arg_0)).collect(Collectors.toList());
        PageData pageData = new PageData();
        pageData.setTotal(esPageSearchResponse.getTotal().longValue());
        pageData.setList(pageEspLogIncludeChainInfoVOS);
        return pageData;
    }

    public String aggregationEspLog(EspLogAggregationDTO espLogAggregationDTO) {
        String endPoint = "/lmc-esp-log-alias/_search";
        String dsl = FreemarkerUtils.processFile((String)"lmc_esplog_aggregation_template.ftl", (Object)espLogAggregationDTO);
        String response = this.elasticsearchService.executeDsl(dsl, HttpMethod.POST.name(), endPoint);
        JSONObject jsonObject = new JSONObject(response);
        return jsonObject.get("aggregations").toString();
    }

    private Integer calculateServiceTime(EspLog start, EspLog end) {
        if (Objects.isNull(start) || Objects.isNull(end)) {
            return null;
        }
        long serviceTime = DateUtils.parse((String)end.getPlatformTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS").getTime() - DateUtils.parse((String)start.getPlatformTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS").getTime();
        return (int)serviceTime;
    }

    private EspLog buildEspLog(CreateEspLogDTO dto) {
        if (dto == null) {
            return null;
        }
        EspLog espLog = new EspLog();
        espLog.setReqId(dto.getReqId());
        espLog.setStateCode(dto.getStateCode());
        espLog.setStepNumber(dto.getStepNumber());
        espLog.setState(dto.getState());
        espLog.setRequest(dto.getRequest());
        espLog.setRequestAp(dto.getRequestAp());
        espLog.setRequestApVersion(dto.getRequestApVersion());
        espLog.setRequestApIp(dto.getRequestApIp());
        espLog.setRequestApId(dto.getRequestApId());
        espLog.setRequestApUid(dto.getRequestApUid());
        espLog.setRequestApUser(dto.getRequestApUser());
        espLog.setRequestTimestamp(dto.getRequestTimestamp());
        espLog.setService(dto.getService());
        espLog.setServiceApUid(dto.getServiceApUid());
        espLog.setServiceApId(dto.getServiceApId());
        espLog.setServiceApIp(dto.getServiceApIp());
        espLog.setServiceAp(dto.getServiceAp());
        espLog.setServiceName(dto.getServiceName());
        espLog.setServiceDescription(dto.getServiceDescription());
        espLog.setServiceVersion(dto.getServiceVersion());
        if (dto.getMessageSize() != null) {
            espLog.setMessageSize(new BigDecimal(dto.getMessageSize()));
        }
        if (Objects.nonNull(dto.getPlatformTime())) {
            espLog.setPlatformTime(DateUtils.format((Date)new Date(dto.getPlatformTime()), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        }
        if (Objects.nonNull(dto.getStandardTime())) {
            espLog.setStandardTime(DateUtils.format((Date)new Date(dto.getStandardTime()), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        }
        espLog.setDataKey(dto.getDataKey());
        espLog.setOperation(dto.getOperation());
        espLog.setUnionApIp(dto.getUnionApIp());
        espLog.setLogDisplayPriority(dto.getLogDisplayPriority());
        espLog.setMsgFormat(dto.getMsgFormat());
        espLog.setReqUnionIp(dto.getReqUnionIp());
        espLog.setTenantId(dto.getTenantId());
        espLog.setTs(dto.getTs());
        espLog.setAppId(dto.getAppId());
        espLog.setCompressedMessage(dto.getCompressedMessage());
        espLog.setPinpointId(dto.getPinpointId());
        return espLog;
    }

    private EaiLogVO buildEaiLogVO(EspEaiLogsLogs espEaiLogsLogs, Map<String, EspStateCodeResponse> espStateCodeMap) {
        if (espEaiLogsLogs == null) {
            return null;
        }
        EaiLogVO eaiLogVO = new EaiLogVO();
        if (Objects.nonNull(espEaiLogsLogs.getPlatformTime())) {
            eaiLogVO.setPlatformTime(DateUtils.format((Date)new Date(espEaiLogsLogs.getPlatformTime()), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        }
        eaiLogVO.setReqId(espEaiLogsLogs.getReqId());
        eaiLogVO.setStateCode(espEaiLogsLogs.getStateCode());
        if (!CollectionUtils.isEmpty(espStateCodeMap)) {
            eaiLogVO.setStateCodeValueZhCn(espStateCodeMap.getOrDefault(espEaiLogsLogs.getStateCode(), new EspStateCodeResponse()).getDescriptionZhCn());
            eaiLogVO.setStateCodeValueZhTw(espStateCodeMap.getOrDefault(espEaiLogsLogs.getStateCode(), new EspStateCodeResponse()).getDescriptionZhTw());
            eaiLogVO.setStateCodeValueEn(espStateCodeMap.getOrDefault(espEaiLogsLogs.getStateCode(), new EspStateCodeResponse()).getDescriptionEn());
        }
        eaiLogVO.setRequest(espEaiLogsLogs.getRequestAp());
        eaiLogVO.setRequestApUser(espEaiLogsLogs.getRequestApUser());
        eaiLogVO.setServiceAp(espEaiLogsLogs.getServiceAp());
        eaiLogVO.setServiceName(espEaiLogsLogs.getServiceName());
        eaiLogVO.setServiceDescription(espEaiLogsLogs.getServiceDescription());
        eaiLogVO.setMessageSize(StringUtils.hasLength((String)espEaiLogsLogs.getMessageSize()) ? new BigDecimal(espEaiLogsLogs.getMessageSize()) : null);
        eaiLogVO.setDataKey(espEaiLogsLogs.getDataKey());
        eaiLogVO.setTenantId(espEaiLogsLogs.getTenantId());
        eaiLogVO.setLogDisplayPriority(espEaiLogsLogs.getLogDisplayPriority());
        String requestMessage = new String(this.compressionAlgorithm.unCompress(espEaiLogsLogs.getCompressedMessage()), StandardCharsets.UTF_8);
        eaiLogVO.setRequestMessageInfo(requestMessage);
        eaiLogVO.setFormatRequestMessageInfo(this.formatRequestMessage(requestMessage));
        return eaiLogVO;
    }

    private PageEspLogVO buildEspLogVO(EspLog espLog, Map<String, EspStateCodeResponse> espStateCodeMap) {
        if (espLog == null) {
            return null;
        }
        PageEspLogVO pageEspLogVO = new PageEspLogVO();
        pageEspLogVO.setPlatformTime(espLog.getPlatformTime());
        pageEspLogVO.setReqId(espLog.getReqId());
        pageEspLogVO.setStateCode(espLog.getStateCode());
        if (!CollectionUtils.isEmpty(espStateCodeMap)) {
            pageEspLogVO.setStateCodeValueZhCn(espStateCodeMap.getOrDefault(espLog.getStateCode(), new EspStateCodeResponse()).getDescriptionZhCn());
            pageEspLogVO.setStateCodeValueZhTw(espStateCodeMap.getOrDefault(espLog.getStateCode(), new EspStateCodeResponse()).getDescriptionZhTw());
            pageEspLogVO.setStateCodeValueEn(espStateCodeMap.getOrDefault(espLog.getStateCode(), new EspStateCodeResponse()).getDescriptionEn());
        }
        pageEspLogVO.setState(espLog.getState());
        pageEspLogVO.setRequest(espLog.getRequest());
        pageEspLogVO.setRequestApUser(espLog.getRequestApUser());
        pageEspLogVO.setServiceAp(espLog.getService());
        pageEspLogVO.setServiceName(espLog.getServiceName());
        pageEspLogVO.setServiceDescription(espLog.getServiceDescription());
        pageEspLogVO.setMessageSize(espLog.getMessageSize());
        pageEspLogVO.setDataKey(espLog.getDataKey());
        pageEspLogVO.setTenantId(espLog.getTenantId());
        pageEspLogVO.setLogDisplayPriority(espLog.getLogDisplayPriority());
        pageEspLogVO.setStepNumber(espLog.getStepNumber());
        pageEspLogVO.setPinpointId(espLog.getPinpointId());
        if (StringUtils.hasLength((String)espLog.getPinpointId())) {
            pageEspLogVO.setPinpointUrl(this.remotePinpiontService.getPinpointUrl(espLog.getPinpointId()));
        }
        return pageEspLogVO;
    }

    private PageEspLogIncludeChainInfoVO buildPageEspLogIncludeChainInfoVO(EspLog espLog) {
        if (espLog == null) {
            return null;
        }
        PageEspLogIncludeChainInfoVO pageEspLogIncludeChainInfoVO = new PageEspLogIncludeChainInfoVO();
        pageEspLogIncludeChainInfoVO.setPlatformTime(espLog.getPlatformTime());
        pageEspLogIncludeChainInfoVO.setReqId(espLog.getReqId());
        pageEspLogIncludeChainInfoVO.setStateCode(espLog.getStateCode());
        pageEspLogIncludeChainInfoVO.setState(espLog.getState());
        pageEspLogIncludeChainInfoVO.setRequest(espLog.getRequest());
        pageEspLogIncludeChainInfoVO.setRequestApUser(espLog.getRequestApUser());
        pageEspLogIncludeChainInfoVO.setServiceAp(espLog.getService());
        pageEspLogIncludeChainInfoVO.setServiceName(espLog.getServiceName());
        pageEspLogIncludeChainInfoVO.setServiceDescription(espLog.getServiceDescription());
        pageEspLogIncludeChainInfoVO.setMessageSize(espLog.getMessageSize());
        pageEspLogIncludeChainInfoVO.setDataKey(espLog.getDataKey());
        pageEspLogIncludeChainInfoVO.setTenantId(espLog.getTenantId());
        pageEspLogIncludeChainInfoVO.setLogDisplayPriority(espLog.getLogDisplayPriority());
        pageEspLogIncludeChainInfoVO.setStepNumber(espLog.getStepNumber());
        pageEspLogIncludeChainInfoVO.setPinpointId(espLog.getPinpointId());
        String message = new String(this.compressionAlgorithm.unCompress(espLog.getCompressedMessage()), StandardCharsets.UTF_8);
        String digiDapServiceChainInfo = this.analyzeRequestHeaderFromMessage(message, HEADER_DIGI_DAP_SERVICE_CHAIN_INFO);
        pageEspLogIncludeChainInfoVO.setDigiDapServiceChainInfo(digiDapServiceChainInfo);
        return pageEspLogIncludeChainInfoVO;
    }

    private EspLogChainInfoVO buildEspLogChainInfoVO(EspLog espLog) {
        if (espLog == null) {
            return null;
        }
        EspLogChainInfoVO espLogChainInfoVO = new EspLogChainInfoVO();
        espLogChainInfoVO.setPlatformTime(espLog.getPlatformTime());
        espLogChainInfoVO.setReqId(espLog.getReqId());
        espLogChainInfoVO.setStateCode(espLog.getStateCode());
        espLogChainInfoVO.setState(espLog.getState());
        espLogChainInfoVO.setServiceAp(espLog.getService());
        espLogChainInfoVO.setServiceName(espLog.getServiceName());
        espLogChainInfoVO.setPinpointId(espLog.getPinpointId());
        return espLogChainInfoVO;
    }

    private String analyzeRequestHeaderFromMessage(String message, String key) {
        String[] messageArr;
        if (!StringUtils.hasLength((String)message)) {
            return null;
        }
        StringBuffer body = new StringBuffer();
        for (String s : messageArr = message.split("\n")) {
            if (s.startsWith("digi-")) {
                String headerKey = s.substring(0, s.indexOf(": "));
                String headerValue = s.substring(s.indexOf(": ") + 2).trim();
                if (!Objects.nonNull(key) || !key.equals(headerKey)) continue;
                return headerValue;
            }
            if (!s.trim().startsWith("{") || !Objects.isNull(key)) continue;
            body.append(s).append("\n");
        }
        return body.toString();
    }

    private String formatRequestMessage(String requestMessage) {
        if (!StringUtils.hasLength((String)requestMessage)) {
            return requestMessage;
        }
        CharSequence[] tPlainMsgs = requestMessage.split("(?:\\r?\\n){2}|(?:\\n?\\r){2}");
        int tSize = tPlainMsgs.length;
        if (0 == tSize) {
            return requestMessage;
        }
        String tPlainMsg = tPlainMsgs[tSize - 1];
        try {
            String tPrettyJson;
            JsonNode responseJson = JsonUtils.createObjectMapper().readTree(tPlainMsg);
            tPlainMsgs[tSize - 1] = tPrettyJson = responseJson.toPrettyString();
        }
        catch (Exception e) {
            return requestMessage;
        }
        return String.join((CharSequence)"\n", tPlainMsgs);
    }

    private String getStateByStepNumber(String stepNumber, Map<String, List<EspLog>> listMapByStepNumber) {
        if (CollectionUtils.isEmpty(listMapByStepNumber)) {
            return null;
        }
        List<EspLog> espLogList = listMapByStepNumber.get(stepNumber);
        if (CollectionUtils.isEmpty(espLogList)) {
            return null;
        }
        return espLogList.get(0).getState();
    }

    private String getStateCodeByStepNumber(String stepNumber, Map<String, List<EspLog>> listMapByStepNumber) {
        if (CollectionUtils.isEmpty(listMapByStepNumber)) {
            return null;
        }
        List<EspLog> espLogList = listMapByStepNumber.get(stepNumber);
        if (CollectionUtils.isEmpty(espLogList)) {
            return null;
        }
        return espLogList.get(0).getStateCode();
    }
}

