/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.service.excel.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.service.excel.ExcelService;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExcelServiceImpl
implements ExcelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelServiceImpl.class);
    private static final String CLASSPATH_TEMPLATE_CN = "classpath:/static/templates/%s_export_template_CN.xlsx";
    private static final String CLASSPATH_TEMPLATE_TW = "classpath:/static/templates/%s_export_template_TW.xlsx";
    @Autowired
    private EnvProperties envProperties;

    public void exportCore(List resultList, String filePrefix, Class clz, HttpServletResponse response) throws IOException {
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return;
        }
        InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? new DefaultResourceLoader().getResource(String.format(CLASSPATH_TEMPLATE_CN, filePrefix)).getInputStream() : new DefaultResourceLoader().getResource(String.format(CLASSPATH_TEMPLATE_TW, filePrefix)).getInputStream();
        String fileName = String.format("%s_export_%s", filePrefix, DateConstant.DATE_TIME_FORMATTER_SMALL.format(LocalDateTime.now()) + ".xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        response.addHeader("Access-Control-Expose-Headers", "Content-disposition");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), (Class)clz).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(resultList);
    }

    public void exportTxt(HttpServletResponse response, String text, String fileName) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/plain");
        response.addHeader("Content-disposition", "attachment;filename=" + this.encodeFileNameOrDefault(fileName, "logs-from-" + DateConstant.DATE_TIME_FORMATTER_SMALL.format(LocalDateTime.now())) + ".txt");
        response.addHeader("Access-Control-Expose-Headers", "Content-disposition");
        try (ServletOutputStream outputStream = response.getOutputStream();
             BufferedOutputStream buff = new BufferedOutputStream((OutputStream)outputStream);){
            buff.write(text.getBytes(StandardCharsets.UTF_8));
            buff.flush();
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51falogs\u6587\u4ef6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
    }

    private String encodeFileNameOrDefault(String cnName, String defaultName) {
        try {
            cnName = new String(cnName.getBytes("gb2312"), StandardCharsets.ISO_8859_1);
        }
        catch (Exception e) {
            cnName = defaultName;
        }
        return cnName;
    }
}

