/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.service.messaging.impl;

import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.service.messaging.PacketSizeRejectStrategy;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DirectEsWritePacketSizeRejectStrategy
implements PacketSizeRejectStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectEsWritePacketSizeRejectStrategy.class);
    @Autowired
    private IElasticsearchService elasticsearchService;

    public void reject(String payload, String esSuffixIndex) {
        if (null == payload || esSuffixIndex == null) {
            LOGGER.warn("\u3010reject\u7b56\u7565\u3011\u505c\u6b62\u8fdb\u884c\uff0c\u503c\u4e3a\u7a7a\uff1aesSuffixIndex={}, payload={}", (Object)esSuffixIndex, (Object)payload);
            return;
        }
        LogTypeEnum logTypeEnum = LogTypeEnum.getLogTypeByContainsSuffix((String)esSuffixIndex);
        if (logTypeEnum == null) {
            LOGGER.warn("\u3010reject\u7b56\u7565\u3011\u505c\u6b62\u8fdb\u884c\u3002\u672a\u77e5\u7684esSuffixIndex={}", (Object)esSuffixIndex);
            return;
        }
        try {
            Object source = JsonUtils.createObjectMapper().readValue(payload, logTypeEnum.getaClass());
            if (Objects.nonNull(source)) {
                this.elasticsearchService.index((Document)source);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010reject\u7b56\u7565\u3011elasticsearchService.save error", (Throwable)e);
        }
    }
}

