/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.service.messaging.impl;

import com.digiwin.dap.middleware.lmc.service.messaging.MessagePublisher;
import com.digiwin.dap.middleware.lmc.service.messaging.PacketSizeRejectStrategy;
import com.digiwin.dap.middleware.lmc.service.messaging.impl.ByteArrayPacketSizeCalculator;
import com.digiwin.dap.middleware.lmc.support.helper.AsycHelper;
import com.digiwin.dap.middleware.lmc.support.helper.RetryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('spring.kafka.server'))}")
public class KafkaMessagePublisher
implements MessagePublisher<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaMessagePublisher.class);
    @Autowired
    @Qualifier(value="kafkaSender")
    private KafkaTemplate kafkaTemplate;
    @Autowired
    private RetryHelper retryHelper;
    @Autowired
    private AsycHelper asycHelper;
    @Autowired
    private PacketSizeRejectStrategy rejectStrategy;
    @Autowired
    private ByteArrayPacketSizeCalculator packetSizeCalculator;
    @Value(value="${spring.kafka.max.request.size}")
    private Long maxRequestSize;

    public void publish(String payload, String topicName, String esSuffixIndex) {
        if (!StringUtils.hasLength((String)payload)) {
            return;
        }
        Long calculated = this.packetSizeCalculator.calculate(payload.getBytes());
        if (calculated > this.maxRequestSize) {
            this.rejectStrategy.reject(payload, esSuffixIndex);
            return;
        }
        this.kafkaTemplate.send(topicName, (Object)payload.getBytes()).addCallback((ListenableFutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ PacketSizeRejectStrategy access$000(KafkaMessagePublisher x0) {
        return x0.rejectStrategy;
    }
}

