/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.alert;

import com.digiwin.dap.middleware.lmc.constant.enums.MailTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.AlertVo;
import com.digiwin.dap.middleware.lmc.support.RateLimiterHelper;
import com.digiwin.dap.middleware.lmc.support.alert.AlertMaker;
import com.digiwin.dap.middleware.lmc.support.remote.EmcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.emc.uri'))}")
public class MailAlertMaker
implements AlertMaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAlertMaker.class);
    @Autowired
    private EmcService emcService;
    @Autowired
    private RateLimiterHelper rateLimiterHelper;

    public void alert(AlertVo alertVo) {
        try {
            this.rateLimiterHelper.mailFlowCtl(() -> {
                this.emcService.sendMessageEmail(MailTypeEnum.LMC_ALERT_EMAIL.name(), (Object)alertVo);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("\u3010MailAlertMaker\u3011", (Throwable)e);
        }
    }
}

