/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.aspect;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.lmc.constant.enums.DataSourceEnum;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.CommonVO;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.remote.FieldValue;
import com.digiwin.dap.middleware.lmc.support.aspect.DataPolicy;
import com.digiwin.dap.middleware.lmc.support.remote.IamService;
import com.digiwin.dap.middleware.util.EnvUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.mongodb.BasicDBList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class DataPolicyAspect {
    @Autowired
    private IamService iamService;
    @Autowired
    private EnvProperties envProperties;
    private static final List<String> OPERATOR = Arrays.asList("and", "or");
    private static final List<String> INTERNAL_APP_LIST = Arrays.asList("dev", "devConsole", "ISV", "DigiwinCloud", "Athena");
    private static final List<String> INTERNAL_MANAGEMENT_LIST = Arrays.asList("BOSS", "MMC", "devOM", "troubleshoot");

    @Pointcut(value="@annotation(com.digiwin.dap.middleware.lmc.support.aspect.DataPolicy)")
    public void dataPolicyPointCut() {
    }

    @Before(value="dataPolicyPointCut()")
    public void doBefore(JoinPoint point) {
        this.handleDataPolicy(point);
    }

    protected void handleDataPolicy(JoinPoint joinPoint) {
        if (Boolean.FALSE.equals(this.envProperties.getDataPolicy())) {
            return;
        }
        DataPolicy controllerDataScope = this.getAnnotationLog(joinPoint);
        if (controllerDataScope == null) {
            return;
        }
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        String iamUri = null;
        if (authoredUser == null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String userToken = (String)request.getAttribute("digi-middleware-source-auth-user-token");
            DeployAreaEnum deployAreaEnum = (DeployAreaEnum)request.getAttribute("digi-middleware-source-deploy-area");
            if (StringUtils.hasLength((String)userToken) && deployAreaEnum != null) {
                iamUri = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum);
                authoredUser = this.iamService.getUserInfo(userToken, iamUri);
            }
        }
        this.dataPolicyFilter(joinPoint, authoredUser, iamUri, controllerDataScope.dataSource(), Arrays.asList(controllerDataScope.logType()));
    }

    public void dataPolicyFilter(JoinPoint joinPoint, AuthoredUser authoredUser, String iamUri, DataSourceEnum dataSourceEnum, List<LogTypeEnum> logTypeEnums) {
        Object params = joinPoint.getArgs()[0];
        String sysId = UserUtils.getSysId();
        if (authoredUser == null || ObjectUtils.isEmpty((Object)authoredUser.getTenantId())) {
            this.notDataPolicy(dataSourceEnum, params);
            return;
        }
        List internalAppList = Optional.ofNullable(this.envProperties.getInternalApp()).filter(x -> !ObjectUtils.isEmpty((Object)x)).map(x -> Arrays.asList(this.envProperties.getInternalApp().split(String.valueOf(';')))).orElse(INTERNAL_APP_LIST);
        List internalManagementList = Optional.ofNullable(this.envProperties.getInternalManagementApp()).filter(x -> !ObjectUtils.isEmpty((Object)x)).map(x -> Arrays.asList(this.envProperties.getInternalManagementApp().split(String.valueOf(';')))).orElse(INTERNAL_MANAGEMENT_LIST);
        String hostTenantId = Optional.ofNullable(this.envProperties.getHostTenantId()).filter(x -> !ObjectUtils.isEmpty((Object)x)).orElse("99990000");
        List athenaAppList = Optional.ofNullable(this.envProperties.getAthenaApp()).map(x -> Arrays.asList(x.split(String.valueOf(';')))).orElse(Collections.emptyList());
        if (internalManagementList.contains(sysId)) {
            if (hostTenantId.equals(authoredUser.getTenantId())) {
                Map map = this.iamService.getRowPermission(authoredUser.getToken(), iamUri);
                if (CollectionUtils.isEmpty((Map)map)) {
                    this.notDataPolicy(dataSourceEnum, params);
                } else {
                    Boolean superadmin = (Boolean)map.get("superadmin");
                    if (Boolean.TRUE.equals(superadmin)) {
                        return;
                    }
                    Object rowPermission = map.get("rowPermission");
                    if (!(rowPermission instanceof Map) || CollectionUtils.isEmpty((Map)((Map)rowPermission))) {
                        this.notDataPolicy(dataSourceEnum, params);
                        return;
                    }
                    Object obj = this.getSql(rowPermission, null, dataSourceEnum);
                    if (obj == null) {
                        this.notDataPolicy(dataSourceEnum, params);
                        return;
                    }
                    if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
                        if (params instanceof Page) {
                            Page page = (Page)params;
                            Query query = page.queryFilter();
                            if (!query.getQueryObject().containsKey((Object)"$and")) {
                                query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[0]));
                            }
                            BasicDBList basicDBList = (BasicDBList)query.getQueryObject().get((Object)"$and", BasicDBList.class);
                            basicDBList.add((Object)((Criteria)obj).getCriteriaObject());
                        }
                    } else if (DataSourceEnum.ES_API.equals((Object)dataSourceEnum) && params instanceof Map) {
                        Map queryMap = (Map)params;
                        Map queryConditionMap = (Map)queryMap.get("query");
                        Map boolMap = (Map)queryConditionMap.get("bool");
                        List filterList = (List)boolMap.computeIfAbsent("filter", k -> new ArrayList());
                        filterList.add((Map)obj);
                    }
                }
            } else {
                this.notDataPolicy(dataSourceEnum, params);
            }
        } else if (logTypeEnums.contains(LogTypeEnum.DEV_LOG)) {
            List voList = this.iamService.getCurrentTenantDevApp(authoredUser.getToken(), iamUri);
            List appIdList = voList.stream().map(CommonVO::getId).collect(Collectors.toList());
            appIdList.addAll(athenaAppList);
            appIdList = appIdList.stream().distinct().filter(StringUtils::hasLength).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(appIdList)) {
                this.notDataPolicy(dataSourceEnum, params);
                return;
            }
            if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
                if (params instanceof Page) {
                    Page page = (Page)params;
                    Query query = page.queryFilter();
                    if (!query.getQueryObject().containsKey((Object)"$and")) {
                        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[0]));
                    }
                    BasicDBList basicDBList = (BasicDBList)query.getQueryObject().get((Object)"$and", BasicDBList.class);
                    basicDBList.add((Object)Criteria.where((String)"appId").in(appIdList).getCriteriaObject());
                }
            } else if (DataSourceEnum.ES_API.equals((Object)dataSourceEnum) && params instanceof Map) {
                Map queryMap = (Map)params;
                Object query = queryMap.get("query");
                Map query1 = (Map)query;
                Object bool = query1.get("bool");
                Map boolMap = (Map)bool;
                List filterList = (List)boolMap.computeIfAbsent("filter", k -> new ArrayList());
                filterList.add(Collections.singletonMap("terms", Collections.singletonMap("appId", appIdList)));
            }
        } else if (logTypeEnums.contains(LogTypeEnum.OP_LOG)) {
            if (internalAppList.contains(sysId)) {
                if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
                    if (params instanceof Page) {
                        Page page = (Page)params;
                        Query query = page.queryFilter();
                        if (!query.getQueryObject().containsKey((Object)"$and")) {
                            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[0]));
                        }
                        BasicDBList basicDBList = (BasicDBList)query.getQueryObject().get((Object)"$and", BasicDBList.class);
                        basicDBList.add((Object)Criteria.where((String)"tenantId").in(Collections.singletonList(authoredUser.getTenantId())).getCriteriaObject());
                        basicDBList.add((Object)Criteria.where((String)"appId").in((Collection)internalAppList.stream().flatMap(x -> Stream.of(x, x.toLowerCase())).collect(Collectors.toSet())).getCriteriaObject());
                    }
                } else if (DataSourceEnum.ES_API.equals((Object)dataSourceEnum) && params instanceof Map) {
                    Map queryMap = (Map)params;
                    Map queryConditionMap = (Map)queryMap.get("query");
                    Map boolMap = (Map)queryConditionMap.get("bool");
                    List filterList = (List)boolMap.computeIfAbsent("filter", k -> new ArrayList());
                    Object must = boolMap.get("must");
                    ArrayList<Map<String, Map<String, List<Map<String, Map<String, String>>>>>> mustList = must == null ? new ArrayList<Map<String, Map<String, List<Map<String, Map<String, String>>>>>>() : (ArrayList<Map<String, Map<String, List<Map<String, Map<String, String>>>>>>)must;
                    mustList.add(Collections.singletonMap("bool", Collections.singletonMap("must", Collections.singletonList(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", authoredUser.getTenantId()))))));
                    filterList.add(Collections.singletonMap("terms", Collections.singletonMap("appId", internalAppList.stream().flatMap(x -> Stream.of(x, x.toLowerCase())).collect(Collectors.toSet()))));
                }
            } else {
                List voList = this.iamService.getCurrentTenantDevApp(authoredUser.getToken(), iamUri);
                List appIdList = voList.stream().map(CommonVO::getId).collect(Collectors.toList());
                if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
                    if (params instanceof Page) {
                        Page page = (Page)params;
                        Query query = page.queryFilter();
                        if (!query.getQueryObject().containsKey((Object)"$and")) {
                            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[0]));
                        }
                        BasicDBList basicDBList = (BasicDBList)query.getQueryObject().get((Object)"$and", BasicDBList.class);
                        Criteria orCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"appId").in(appIdList), Criteria.where((String)"tenantId").in(Collections.singletonList(authoredUser.getTenantId()))});
                        basicDBList.add((Object)orCriteria.getCriteriaObject());
                    }
                } else if (DataSourceEnum.ES_API.equals((Object)dataSourceEnum) && params instanceof Map) {
                    Map queryMap = (Map)params;
                    Object query = queryMap.get("query");
                    Map query1 = (Map)query;
                    Object bool = query1.get("bool");
                    Map boolMap = (Map)bool;
                    Object must = boolMap.get("must");
                    ArrayList<Map<String, Map<String, List<Map>>>> mustList = must == null ? new ArrayList<Map<String, Map<String, List<Map>>>>() : (ArrayList<Map<String, Map<String, List<Map>>>>)must;
                    mustList.add(Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("terms", Collections.singletonMap("appId", appIdList)), Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", authoredUser.getTenantId()))))));
                }
            }
        } else if (logTypeEnums.contains(LogTypeEnum.EVENT_LOG)) {
            List voList = this.iamService.getCurrentTenantDevApp(authoredUser.getToken(), iamUri);
            List appIdList = voList.stream().map(CommonVO::getId).collect(Collectors.toList());
            if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
                if (params instanceof Page) {
                    Page page = (Page)params;
                    Query query = page.queryFilter();
                    if (!query.getQueryObject().containsKey((Object)"$and")) {
                        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[0]));
                    }
                    String appId = (String)query.getQueryObject().get((Object)"appId", String.class);
                    BasicDBList basicDBList = (BasicDBList)query.getQueryObject().get((Object)"$and", BasicDBList.class);
                    Criteria criteria = "IAM".equals(appId) ? Criteria.where((String)"tenantId").in(Collections.singletonList(authoredUser.getTenantId())) : new Criteria().orOperator(new Criteria[]{Criteria.where((String)"appId").in(appIdList), Criteria.where((String)"tenantId").in(Collections.singletonList(authoredUser.getTenantId()))});
                    basicDBList.add((Object)criteria.getCriteriaObject());
                }
            } else if (DataSourceEnum.ES_API.equals((Object)dataSourceEnum) && params instanceof Map) {
                ArrayList<Map<String, Map<String, List<Map<String, Map<String, String>>>>>> mustList;
                Map queryMap = (Map)params;
                Object query = queryMap.get("query");
                Map query1 = (Map)query;
                Object bool = query1.get("bool");
                Map boolMap = (Map)bool;
                List filterList = (List)boolMap.computeIfAbsent("filter", k -> new ArrayList());
                boolean iamApp = filterList.stream().anyMatch(x -> {
                    Object appId;
                    Object term = x.get("term");
                    return term instanceof Map && "IAM".equals(appId = ((Map)term).get("appId"));
                });
                Object must = boolMap.get("must");
                if (must == null) {
                    mustList = new ArrayList<Map<String, Map<String, List<Map<String, Map<String, String>>>>>>();
                    boolMap.put("must", mustList);
                } else {
                    mustList = (ArrayList<Map<String, Map<String, List<Map<String, Map<String, String>>>>>>)must;
                }
                if (iamApp) {
                    mustList.add(Collections.singletonMap("bool", Collections.singletonMap("must", Collections.singletonList(Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", authoredUser.getTenantId()))))));
                    return;
                }
                mustList.add(Collections.singletonMap("bool", Collections.singletonMap("should", Arrays.asList(Collections.singletonMap("terms", Collections.singletonMap("appId", appIdList)), Collections.singletonMap("match_phrase", Collections.singletonMap("tenantId", authoredUser.getTenantId()))))));
            }
        }
    }

    private Object getSql(Object object, String operator, DataSourceEnum dataSourceEnum) {
        if (null == object) {
            return null;
        }
        if (object instanceof Map) {
            Map rowPermissionMap = (Map)object;
            if (rowPermissionMap.isEmpty()) {
                return null;
            }
            FieldValue fieldValue = new FieldValue(rowPermissionMap);
            if (OPERATOR.contains(fieldValue.getFilterType())) {
                return this.getSql(fieldValue.getFilterValue(), fieldValue.getFilterType(), dataSourceEnum);
            }
            return fieldValue.getCondition(dataSourceEnum);
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object o : list) {
                Object sql = this.getSql(o, null, dataSourceEnum);
                if (sql == null) continue;
                values.add(sql);
            }
            int size = values.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                return values.get(0);
            }
            if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
                if ("or".equals(operator)) {
                    return new Criteria().orOperator(values.toArray(new Criteria[0]));
                }
                if ("and".equals(operator)) {
                    return new Criteria().andOperator(values.toArray(new Criteria[0]));
                }
            } else if (DataSourceEnum.ES_API.equals((Object)dataSourceEnum)) {
                if ("or".equals(operator)) {
                    return Collections.singletonMap("bool", Collections.singletonMap("should", values));
                }
                if ("and".equals(operator)) {
                    return Collections.singletonMap("bool", Collections.singletonMap("must", values));
                }
            }
        }
        return null;
    }

    private void notDataPolicy(DataSourceEnum dataSourceEnum, Object params) {
        String uuidKey = UUID.randomUUID().toString();
        if (DataSourceEnum.MONGODB.equals((Object)dataSourceEnum)) {
            if (params instanceof Page) {
                Query query = ((Page)params).queryFilter();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)uuidKey).is((Object)uuidKey));
            }
        } else if (DataSourceEnum.ES_API.equals((Object)dataSourceEnum) && params instanceof Map) {
            Map queryMap = (Map)params;
            Map queryConditionMap = (Map)queryMap.get("query");
            Map boolMap = (Map)queryConditionMap.get("bool");
            List filterList = (List)boolMap.computeIfAbsent("filter", k -> new ArrayList());
            filterList.add(Collections.singletonMap("terms", Collections.singletonMap("appId", Collections.singletonList(uuidKey))));
        }
    }

    private DataPolicy getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(DataPolicy.class);
        }
        return null;
    }
}

