/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.cache;

import com.digiwin.dap.middleware.lmc.support.cache.MongoLockV2;
import com.digiwin.dap.middleware.util.DateUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MongoDistributedLockV2 {
    private static final Logger logger = LoggerFactory.getLogger(MongoDistributedLockV2.class);
    private static final String INDEX_NAME = "mongo_distributed_lock";
    @Autowired
    private MongoTemplate mongoTemplate;

    @PostConstruct
    public void init() {
        List indexes = this.mongoTemplate.indexOps("mongo_distributed_lock").getIndexInfo();
        if (indexes.size() > 0) {
            return;
        }
        ArrayList<IndexModel> indexModels = new ArrayList<IndexModel>();
        BasicDBObject index1 = new BasicDBObject();
        index1.put((Object)"expireTime", (Object)1);
        IndexOptions indexOptions = new IndexOptions();
        indexOptions.background(true);
        indexOptions.name("expireTime");
        indexOptions.expireAfter(Long.valueOf(0L), TimeUnit.SECONDS);
        indexModels.add(new IndexModel((Bson)index1, indexOptions));
        this.mongoTemplate.getCollection("mongo_distributed_lock").createIndexes(indexModels);
    }

    public boolean getLock(String key, long expire) {
        String owner = MongoDistributedLockV2.getLocalHostIpName();
        MongoLockV2 mongoLock = new MongoLockV2();
        mongoLock.setId(key);
        mongoLock.setExpireTime(DateUtils.toDate((LocalDateTime)LocalDateTime.now().plusSeconds(expire)));
        mongoLock.setCreateTime(DateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        mongoLock.setOwner(owner);
        try {
            this.mongoTemplate.insert((Object)mongoLock, "mongo_distributed_lock");
            logger.info("\u5206\u5e03\u5f0f\u9501\uff1aowner={} \u83b7\u53d6\u9501 {} \u6210\u529f", (Object)owner, (Object)key);
            return true;
        }
        catch (Exception e) {
            logger.error("\u5206\u5e03\u5f0f\u9501\uff1aowner={} \u83b7\u53d6\u9501 {} \u5931\u8d25", new Object[]{owner, key, e});
            return false;
        }
    }

    public boolean releaseLock(String key) {
        String owner = MongoDistributedLockV2.getLocalHostIpName();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)key).and("owner").is((Object)owner));
        try {
            DeleteResult deleteResult = this.mongoTemplate.remove(query, "mongo_distributed_lock");
            if (deleteResult.getDeletedCount() > 0L) {
                logger.info("\u5206\u5e03\u5f0f\u9501\uff1aowner={} \u91ca\u653e\u9501 {} \u6210\u529f", (Object)owner, (Object)key);
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u5206\u5e03\u5f0f\u9501\uff1aowner={} \u91ca\u653e\u9501 {} \u5931\u8d25!", new Object[]{owner, key, e});
        }
        return false;
    }

    public static String getLocalHostIpName() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String ip = addr.getHostAddress().toString();
        String hostName = addr.getHostName().toString();
        String result = hostName != null && hostName != "" ? hostName : ip;
        return result;
    }
}

