/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.elasticsearch;

import com.digiwin.dap.middleware.commons.util.FreemarkerUtils;
import com.digiwin.dap.middleware.lmc.config.ElasticsearchConfiguration;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.IElasticsearchIndexStrategy;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.InitElasticsearchIndexTemplate;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexLifeCycle;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexStrategy;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexTemplate;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.digiwin.dap.middleware.util.DateUtils;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBean(name={"elasticsearchConfig"})
public class InitElasticsearchIndexTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitElasticsearchIndexTemplate.class);
    private static final String INDEX_MAPPINGS_NODE = "indexParam.mappings";
    private static final String LIFECYCLE_POLICY_TEMPLATE_PATH = "lmc_ilm_template.ftl";
    private static final String INDEX_SETTINGS_TEMPLATE = "lmc_index_settings_template.ftl";
    private static final String INDEX_ALIAS_TEMPLATE = "lmc_index_alias_template.ftl";
    private static final String LIFECYCLE_POLICY_NAME = "%s-ilm";
    @Autowired
    private IElasticsearchService elasticsearchService;
    @Autowired
    private ElasticsearchConfiguration elasticsearchConfiguration;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void initIndexTemplate() {
        Reflections reflections = new Reflections("com.digiwin.dap.middleware.lmc", new Scanner[0]);
        Set implClass = reflections.getSubTypesOf(Document.class);
        if (implClass.isEmpty()) {
            LOGGER.warn("\u672a\u627e\u5230\u521d\u59cb\u5316\u914d\u7f6e\u7c7b.");
            return;
        }
        LOGGER.info("\u521d\u59cb\u5316\u7d22\u5f15\u6570\u91cf{}.", (Object)implClass.size());
        for (Class c : implClass) {
            try {
                boolean isExistIndexTemplate;
                LOGGER.info("\u521d\u59cb\u5316{}\u7d22\u5f15.", (Object)c.toString());
                ElasticsearchIndexStrategy elasticsearchIndexStrategy = c.getAnnotation(ElasticsearchIndexStrategy.class);
                ElasticsearchIndexTemplate elasticsearchIndexTemplate = c.getAnnotation(ElasticsearchIndexTemplate.class);
                ElasticsearchIndexLifeCycle elasticsearchIndexLifeCycle = c.getAnnotation(ElasticsearchIndexLifeCycle.class);
                if (Objects.isNull(elasticsearchIndexStrategy)) continue;
                String lifecyclePolicyName = null;
                if (Objects.nonNull(elasticsearchIndexLifeCycle) && Objects.nonNull(elasticsearchIndexTemplate)) {
                    lifecyclePolicyName = String.format(LIFECYCLE_POLICY_NAME, elasticsearchIndexStrategy.indexName());
                    1 lifecyclePolicyParams = new /* Unavailable Anonymous Inner Class!! */;
                    LOGGER.info("\u7d22\u5f15\u751f\u547d\u5468\u671f\u7b56\u7565\u53c2\u6570:{}", (Object)JsonUtils.writeValueAsString((Object)lifecyclePolicyParams));
                    String ilm = FreemarkerUtils.processFile((String)LIFECYCLE_POLICY_TEMPLATE_PATH, (Object)lifecyclePolicyParams);
                    this.elasticsearchService.createIndexLifecyclePolicy(lifecyclePolicyName, ilm);
                    LOGGER.info("\u7d22\u5f15\u751f\u547d\u5468\u671f\u7b56\u7565\u521b\u5efa\u6210\u529f,\u7b56\u7565\u540d\u79f0:{},\u7b56\u7565\u53c2\u6570:{},\u7b56\u7565:{}.", new Object[]{lifecyclePolicyName, JsonUtils.writeValueAsString((Object)lifecyclePolicyParams), ilm});
                }
                JSONObject mappingJson = JsonUtils.getJsonByNode((String)INDEX_MAPPINGS_NODE, (JSONObject)JsonUtils.convertJsonFileToJson((String)elasticsearchIndexStrategy.mappingPath()));
                if (elasticsearchIndexStrategy.mappingSize() && this.elasticsearchConfiguration.getMappingSize().booleanValue()) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("enabled", true);
                    mappingJson.put("_size", (Object)jsonObject);
                }
                String mapping = mappingJson.toString();
                2 settingDataModel = new /* Unavailable Anonymous Inner Class!! */;
                if (Objects.nonNull(elasticsearchIndexLifeCycle)) {
                    settingDataModel.put("lifecycle_name", lifecyclePolicyName);
                    settingDataModel.put("lifecycle_rollover_alias", elasticsearchIndexLifeCycle.lifecycleRolloverAlias());
                    settingDataModel.put("lifecycle_enable", true);
                }
                String setting = FreemarkerUtils.processFile((String)INDEX_SETTINGS_TEMPLATE, (Object)settingDataModel);
                3 aliasDataModel = new /* Unavailable Anonymous Inner Class!! */;
                if (Objects.nonNull(elasticsearchIndexLifeCycle)) {
                    aliasDataModel.put("lifecycle_rollover_alias", elasticsearchIndexLifeCycle.lifecycleRolloverAlias());
                    aliasDataModel.put("lifecycle_enable", true);
                }
                String alias = FreemarkerUtils.processFile((String)INDEX_ALIAS_TEMPLATE, (Object)aliasDataModel);
                if (!elasticsearchIndexStrategy.autoCreate() || Objects.nonNull(elasticsearchIndexLifeCycle)) {
                    String writeIndexName = this.elasticsearchService.queryWriteIndex(elasticsearchIndexLifeCycle.lifecycleRolloverAlias());
                    String indexNameSuffix = ((IElasticsearchIndexStrategy)elasticsearchIndexStrategy.elasticsearchIndexStrategy().newInstance()).indexNameSuffix(null);
                    String indexName = "<" + elasticsearchIndexStrategy.indexName();
                    if (StringUtils.hasLength((String)indexNameSuffix)) {
                        indexName = indexName + "-" + indexNameSuffix;
                    }
                    indexName = indexName + "-{now/d{YYYYMMdd|+08:00}}-000001>";
                    String time = DateUtils.format((Date)new Date(), (String)"YYYYMMdd");
                    if (!StringUtils.hasLength((String)writeIndexName)) {
                        this.elasticsearchService.createIndex(indexName, setting, mapping, alias);
                        LOGGER.info("\u7d22\u5f15{}\u521b\u5efa\u6210\u529f.", (Object)indexName);
                    }
                }
                if (isExistIndexTemplate = this.elasticsearchService.existIndexTemplate(elasticsearchIndexTemplate.templateName())) {
                    if (elasticsearchIndexTemplate.forceUpdate()) {
                        this.elasticsearchService.deleteIndexTemplate(elasticsearchIndexTemplate.templateName());
                        LOGGER.info("\u7d22\u5f15\u6a21\u677f{}\u5df2\u5b58\u5728,\u4e14\u8bbe\u7f6e\u4e3a\u5f3a\u5236\u66f4\u65b0,\u5df2\u5220\u9664\u5f53\u524d\u7d22\u5f15\u6a21\u677f.", (Object)elasticsearchIndexTemplate.templateName());
                    } else {
                        LOGGER.info("\u7d22\u5f15\u6a21\u677f{}\u5df2\u5b58\u5728.", (Object)elasticsearchIndexTemplate.templateName());
                        continue;
                    }
                }
                this.elasticsearchService.putIndexTemplate(elasticsearchIndexTemplate.templateName(), elasticsearchIndexStrategy.aliasName(), Long.valueOf(elasticsearchIndexTemplate.priority()), Long.valueOf(elasticsearchIndexTemplate.version()), elasticsearchIndexTemplate.indexPatterns(), mapping, setting);
                LOGGER.info("\u7d22\u5f15\u6a21\u677f{}\u521b\u5efa\u6210\u529f.", (Object)elasticsearchIndexTemplate.templateName());
            }
            catch (Exception e) {
                LOGGER.error("\u521d\u59cb\u5316{}\u7d22\u5f15\u5f02\u5e38.", (Object)c.toString(), (Object)e);
            }
        }
    }

    static /* synthetic */ Environment access$000(InitElasticsearchIndexTemplate x0) {
        return x0.environment;
    }
}

