/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.elasticsearch.service.impl;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.config.ElasticsearchConfiguration;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.IElasticsearchIndexStrategy;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexLifeCycle;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.annotation.ElasticsearchIndexStrategy;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsPageSearchResponse;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsSearchResponse;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsSearchResult;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsStatisticsDiskUsageResponse;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.EsStatisticsDiskUsageResult;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Hit;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.HitsResult;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Total;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.impl.ElasticsearchServiceImpl;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.ContentTooLongException;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indexlifecycle.GetLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.GetLifecyclePolicyResponse;
import org.elasticsearch.client.indexlifecycle.LifecyclePolicy;
import org.elasticsearch.client.indexlifecycle.LifecyclePolicyMetadata;
import org.elasticsearch.client.indices.ComposableIndexTemplateExistRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.DeleteComposableIndexTemplateRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.PutComposableIndexTemplateRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortBuilder;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ElasticsearchServiceImpl
implements IElasticsearchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchServiceImpl.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    private static final String INDEX_MAPPINGS_NODE = "indexParam.mappings";
    public static final String ALIAS_METADATA = "{index}-alias";
    @Autowired(required=false)
    @Qualifier(value="lmcRestHighLevelClient")
    private RestHighLevelClient restHighLevelClient;
    @Autowired(required=false)
    @Qualifier(value="lmcEsActionListener")
    private ActionListener actionListener;
    @Autowired
    private ElasticsearchConfiguration elasticsearchConfiguration;

    public void putIndexTemplate(String templateName, String aliasName, Long priority, Long version, String[] indexPatterns, String mapping, String setting) {
        AcknowledgedResponse acknowledgedResponse;
        try {
            PutComposableIndexTemplateRequest putComposableIndexTemplateRequest = new PutComposableIndexTemplateRequest();
            putComposableIndexTemplateRequest.name(templateName);
            putComposableIndexTemplateRequest.create(false);
            HashMap<String, AliasMetadata> aliases = new HashMap<String, AliasMetadata>();
            AliasMetadata indexAlias = AliasMetadata.builder((String)aliasName).build();
            AliasMetadata placeholderAlias = AliasMetadata.builder((String)ALIAS_METADATA).build();
            aliases.put("indexAlias", indexAlias);
            aliases.put(ALIAS_METADATA, placeholderAlias);
            CompressedXContent mappings = new CompressedXContent(mapping);
            Settings settings = Settings.builder().loadFromSource(setting, XContentType.JSON).build();
            Template template = new Template(settings, mappings, aliases);
            ComposableIndexTemplate composableIndexTemplate = new ComposableIndexTemplate(Arrays.asList(indexPatterns), template, null, priority, version, null);
            putComposableIndexTemplateRequest.indexTemplate(composableIndexTemplate);
            acknowledgedResponse = this.restHighLevelClient.indices().putIndexTemplate(putComposableIndexTemplateRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Create index template exception.", (Throwable)e);
        }
        if (!acknowledgedResponse.isAcknowledged()) {
            throw new BusinessException("Failed to create index template.");
        }
    }

    public void deleteIndexTemplate(String templateName) {
        AcknowledgedResponse acknowledgedResponse;
        if (!this.existIndexTemplate(templateName)) {
            LOGGER.warn("Index template {} not exist.", (Object)templateName);
            return;
        }
        DeleteComposableIndexTemplateRequest deleteComposableIndexTemplateRequest = new DeleteComposableIndexTemplateRequest(templateName);
        try {
            acknowledgedResponse = this.restHighLevelClient.indices().deleteIndexTemplate(deleteComposableIndexTemplateRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Delete index template exception.", (Throwable)e);
        }
        if (!acknowledgedResponse.isAcknowledged()) {
            throw new BusinessException("Failed to delete index template.");
        }
    }

    public boolean existIndexTemplate(String indexTemplateName) {
        ComposableIndexTemplateExistRequest composableIndexTemplateExistRequest = new ComposableIndexTemplateExistRequest(indexTemplateName);
        try {
            return this.restHighLevelClient.indices().existsIndexTemplate(composableIndexTemplateExistRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Determine whether the es index template exists exception!", (Throwable)e);
        }
    }

    public boolean existIndex(String indexName) {
        GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{indexName});
        try {
            return this.restHighLevelClient.indices().exists(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Determine whether the es index exists exception!", (Throwable)e);
        }
    }

    public void deleteIndex(String ... indexName) {
        AcknowledgedResponse acknowledgedResponse;
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        try {
            acknowledgedResponse = this.restHighLevelClient.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Delete index exception.", (Throwable)e);
        }
        if (!acknowledgedResponse.isAcknowledged()) {
            throw new BusinessException("Failed to delete index.");
        }
    }

    public String createIndex(String indexName, String aliasName, String filePath) {
        CreateIndexResponse response;
        if (!StringUtils.hasLength((String)indexName) || !StringUtils.hasLength((String)filePath)) {
            throw new BusinessException("Illegal parameter.");
        }
        if (!filePath.endsWith(".json")) {
            throw new BusinessException("The format of the index template file is illegal.");
        }
        JSONObject jsonObject = com.digiwin.dap.middleware.lmc.util.JsonUtils.convertJsonFileToJson((String)filePath);
        if (null == jsonObject) {
            throw new BusinessException("Index template file parsing exception.");
        }
        LOGGER.info("Create index,index name:{},index template:{}", (Object)indexName, (Object)jsonObject);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        createIndexRequest.mapping(com.digiwin.dap.middleware.lmc.util.JsonUtils.getJsonByNode((String)INDEX_MAPPINGS_NODE, (JSONObject)jsonObject).toString(), XContentType.JSON);
        if (StringUtils.hasLength((String)aliasName)) {
            createIndexRequest.alias(new Alias(aliasName));
        }
        try {
            response = this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Create index exception.", (Throwable)e);
        }
        if (!response.isAcknowledged()) {
            throw new BusinessException("Create index failed.");
        }
        return response.index();
    }

    public String createIndex(String indexName, String settings, String mappings, String alias) {
        CreateIndexResponse response;
        if (!(StringUtils.hasLength((String)indexName) && StringUtils.hasLength((String)settings) && StringUtils.hasLength((String)mappings) && StringUtils.hasLength((String)alias))) {
            throw new BusinessException("Illegal parameter!");
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        createIndexRequest.settings(settings, XContentType.JSON);
        createIndexRequest.mapping(mappings, XContentType.JSON);
        createIndexRequest.aliases(alias, XContentType.JSON);
        try {
            response = this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Create index exception.", (Throwable)e);
        }
        if (!response.isAcknowledged()) {
            throw new BusinessException("Create index failed.");
        }
        return response.index();
    }

    public void bulkIndex(List<? extends Document> dataList) {
        BulkResponse bulkResponse;
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        ElasticsearchIndexLifeCycle elasticsearchIndexLifeCycle = dataList.get(0).getClass().getAnnotation(ElasticsearchIndexLifeCycle.class);
        BulkRequest bulkRequest = new BulkRequest();
        dataList.forEach(x -> {
            IndexRequest indexRequest = new IndexRequest();
            if (Objects.nonNull(elasticsearchIndexLifeCycle)) {
                indexRequest.index(elasticsearchIndexLifeCycle.lifecycleRolloverAlias());
            } else {
                indexRequest.index(this.indexName(x.getClass(), x));
            }
            indexRequest.id(x.documentId()).opType(DocWriteRequest.OpType.INDEX).source(com.digiwin.dap.middleware.lmc.util.JsonUtils.writeValueAsString((Object)x), XContentType.JSON);
            bulkRequest.add(indexRequest);
        });
        try {
            bulkResponse = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Batch save document exception.", (Throwable)e);
        }
        if (bulkResponse.hasFailures()) {
            throw new BusinessException(bulkResponse.buildFailureMessage());
        }
    }

    public void asyncBulkIndex(List<? extends Document> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        ElasticsearchIndexLifeCycle elasticsearchIndexLifeCycle = dataList.get(0).getClass().getAnnotation(ElasticsearchIndexLifeCycle.class);
        BulkRequest bulkRequest = new BulkRequest();
        dataList.forEach(x -> {
            IndexRequest indexRequest = new IndexRequest();
            if (Objects.nonNull(elasticsearchIndexLifeCycle)) {
                indexRequest.index(elasticsearchIndexLifeCycle.lifecycleRolloverAlias());
            } else {
                indexRequest.index(this.indexName(x.getClass(), x));
            }
            indexRequest.id(x.documentId()).opType(DocWriteRequest.OpType.INDEX).source(com.digiwin.dap.middleware.lmc.util.JsonUtils.writeValueAsString((Object)x), XContentType.JSON);
            bulkRequest.add(indexRequest);
        });
        try {
            this.restHighLevelClient.bulkAsync(bulkRequest, RequestOptions.DEFAULT, this.actionListener);
        }
        catch (Exception e) {
            throw new BusinessException("Batch save document exception.", (Throwable)e);
        }
    }

    public <T extends Document> void index(T source) {
        IndexResponse indexResponse;
        if (Objects.isNull(source)) {
            LOGGER.warn("document is null!");
            return;
        }
        IndexRequest indexRequest = new IndexRequest();
        ElasticsearchIndexLifeCycle elasticsearchIndexLifeCycle = source.getClass().getAnnotation(ElasticsearchIndexLifeCycle.class);
        if (Objects.nonNull(elasticsearchIndexLifeCycle)) {
            indexRequest.index(elasticsearchIndexLifeCycle.lifecycleRolloverAlias());
        } else {
            indexRequest.index(this.indexName(source.getClass(), source));
        }
        indexRequest.source(com.digiwin.dap.middleware.lmc.util.JsonUtils.writeValueAsString(source), XContentType.JSON);
        String id = source.documentId();
        indexRequest.id(id);
        indexRequest.opType(DocWriteRequest.OpType.INDEX);
        try {
            indexResponse = this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Save document exception.", (Throwable)e);
        }
        if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
            LOGGER.info("index update id= {}", (Object)id);
        }
    }

    public <T extends Document> void asyncIndex(T source) {
        IndexRequest indexRequest = new IndexRequest();
        ElasticsearchIndexLifeCycle elasticsearchIndexLifeCycle = source.getClass().getAnnotation(ElasticsearchIndexLifeCycle.class);
        if (Objects.nonNull(elasticsearchIndexLifeCycle)) {
            indexRequest.index(elasticsearchIndexLifeCycle.lifecycleRolloverAlias());
        } else {
            indexRequest.index(this.indexName(source.getClass(), source));
        }
        indexRequest.source(com.digiwin.dap.middleware.lmc.util.JsonUtils.writeValueAsString(source), XContentType.JSON);
        indexRequest.id(source.documentId());
        indexRequest.opType(DocWriteRequest.OpType.INDEX);
        try {
            this.restHighLevelClient.indexAsync(indexRequest, RequestOptions.DEFAULT, this.actionListener);
        }
        catch (Exception e) {
            throw new BusinessException("Async Save document exception.", (Throwable)e);
        }
    }

    public String executeDsl(String dsl, String method, String endpoint) {
        if (StringUtils.hasLength((String)dsl)) {
            LOGGER.info("Elasticsearch\u67e5\u8be2 DSL = {}", (Object)dsl);
        }
        try {
            Request request = new Request(method, endpoint);
            Optional.ofNullable(dsl).ifPresent(arg_0 -> ((Request)request).setJsonEntity(arg_0));
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ResponseException e) {
            throw new BusinessException((Throwable)e);
        }
        catch (Exception e) {
            throw new BusinessException("Dsl execution exception.", (Throwable)e);
        }
    }

    public String executeDsl(Map<String, Object> dslMap, String method, String endpoint) {
        String query;
        if (dslMap == null) {
            query = null;
        } else {
            try {
                query = objectMapper.writeValueAsString(dslMap);
            }
            catch (JsonProcessingException e) {
                throw new BusinessException("dslMap\u8f6c\u5316String\u5931\u8d25", (Throwable)e);
            }
        }
        return this.executeDsl(query, method, endpoint);
    }

    public <T extends Document> EsPageSearchResponse<T> pageSearch(List<QueryBuilder> queryBuilderList, List<SortBuilder<?>> sorts, Integer pageNum, Integer pageSize, Boolean trackTotalHits, String[] excludeFields, Class<T> clazz) {
        SearchResponse searchResponse;
        SearchRequest searchRequest = new SearchRequest(new String[]{this.aliasName(clazz)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isEmpty(queryBuilderList)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            for (QueryBuilder queryBuilder : queryBuilderList) {
                boolBuilder.must(queryBuilder);
            }
        }
        searchSourceBuilder.query((QueryBuilder)boolBuilder);
        if (!CollectionUtils.isEmpty(sorts)) {
            searchSourceBuilder.sort(sorts);
        }
        if (Objects.nonNull(pageNum) && Objects.nonNull(pageSize)) {
            int from = (pageNum - 1) * pageSize;
            searchSourceBuilder.from(from);
        }
        if (Objects.nonNull(pageSize)) {
            searchSourceBuilder.size(pageSize.intValue());
        }
        searchSourceBuilder.trackTotalHits(trackTotalHits.booleanValue());
        if (Objects.nonNull(excludeFields) && excludeFields.length > 0) {
            FetchSourceContext fetchSourceContext = new FetchSourceContext(true, null, excludeFields);
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Search exception!", (Throwable)e);
        }
        if (searchResponse.status() != RestStatus.OK) {
            throw new BusinessException("Search failed!");
        }
        SearchHits searchHits = searchResponse.getHits();
        if (Objects.isNull(searchHits)) {
            return EsPageSearchResponse.success();
        }
        return new EsPageSearchResponse(this.deserializeSearchHits(clazz, searchHits.getHits()), Long.valueOf(searchResponse.getHits().getTotalHits().value));
    }

    public <T extends Document> EsPageSearchResponse<T> searchAfterPageSearch(String indices, List<QueryBuilder> queryBuilderList, List<SortBuilder<?>> sorts, Object[] lastSortValues, Integer pageSize, Class<T> clazz) {
        SearchResponse searchResponse;
        SearchRequest searchRequest = new SearchRequest(new String[]{indices});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isEmpty(queryBuilderList)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            for (QueryBuilder queryBuilder : queryBuilderList) {
                boolBuilder.must(queryBuilder);
            }
            searchSourceBuilder.query((QueryBuilder)boolBuilder);
        }
        if (!CollectionUtils.isEmpty(sorts) && Objects.nonNull(lastSortValues)) {
            searchSourceBuilder.sort(sorts);
        }
        if (Objects.nonNull(lastSortValues) && ((Object[])lastSortValues).length > 0) {
            searchSourceBuilder.searchAfter(lastSortValues);
        }
        searchSourceBuilder.size(pageSize.intValue());
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Search exception!", (Throwable)e);
        }
        SearchHits hits = searchResponse.getHits();
        lastSortValues = hits.getHits().length > 0 ? hits.getAt(hits.getHits().length - 1).getSortValues() : null;
        SearchHits searchHits = searchResponse.getHits();
        if (Objects.isNull(searchHits)) {
            return EsPageSearchResponse.success();
        }
        return new EsPageSearchResponse(this.deserializeSearchHits(clazz, searchHits.getHits()), Long.valueOf(searchResponse.getHits().getTotalHits().value), lastSortValues);
    }

    public <T extends Document> EsPageSearchResponse<T> count(String indices, List<QueryBuilder> queryBuilderList, List<SortBuilder<?>> sorts, Object[] lastSortValues, Integer pageSize, Class<T> clazz) {
        SearchResponse searchResponse;
        SearchRequest searchRequest = new SearchRequest(new String[]{indices});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isEmpty(queryBuilderList)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            for (QueryBuilder queryBuilder : queryBuilderList) {
                boolBuilder.must(queryBuilder);
            }
            searchSourceBuilder.query((QueryBuilder)boolBuilder);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"age_terms").field("age"));
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new BusinessException("Search exception!", (Throwable)e);
        }
        SearchHits hits = searchResponse.getHits();
        lastSortValues = hits.getHits().length > 0 ? hits.getAt(hits.getHits().length - 1).getSortValues() : null;
        SearchHits searchHits = searchResponse.getHits();
        if (Objects.isNull(searchHits)) {
            return EsPageSearchResponse.success();
        }
        return new EsPageSearchResponse(this.deserializeSearchHits(clazz, searchHits.getHits()), Long.valueOf(searchResponse.getHits().getTotalHits().value), lastSortValues);
    }

    public <T> PageData<T> pageSearch(Map<String, Object> dslMap, String[] indices, TypeReference<EsSearchResult<T>> typeReference) {
        EsSearchResult esSearchResult;
        String responseBody;
        Response response;
        String query;
        dslMap.put("track_total_hits", true);
        try {
            query = objectMapper.writeValueAsString(dslMap);
            LOGGER.info("Elasticsearch\u67e5\u8be2 DSL = {}", (Object)query);
        }
        catch (JsonProcessingException e) {
            throw new BusinessException("queryMap\u8f6c\u5316String\u5931\u8d25", (Throwable)e);
        }
        Request request = new Request(HttpMethod.POST.name(), String.join((CharSequence)",", indices) + "/_search");
        request.setJsonEntity(query);
        try {
            response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ContentTooLongException e) {
            String errMsg = "\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff1a";
            boolean contains100M = Optional.ofNullable(e.getMessage()).map(x -> x.contains("[104857600]")).orElse(false);
            if (contains100M) {
                errMsg = "\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc7\u9650\u5236100M\uff1a";
            }
            throw new BusinessException(errMsg + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BusinessException("Elasticsearch DSL search exception!", (Throwable)e);
        }
        if (response.getStatusLine().getStatusCode() != RestStatus.OK.getStatus()) {
            LOGGER.error("Elasticsearch DSL search exception: statusCode={}, responseBody={}", (Object)response.getStatusLine().getStatusCode(), (Object)responseBody);
            return PageData.zero();
        }
        try {
            esSearchResult = (EsSearchResult)objectMapper.readValue(responseBody, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new BusinessException("Elasticsearch DSL search responseBody Json Processing Exception", (Throwable)e);
        }
        return PageData.data((long)Optional.of(esSearchResult.getHits()).map(HitsResult::getTotal).map(Total::getValue).orElse(0L), Optional.of(esSearchResult.getHits()).map(HitsResult::getHits).map(x -> x.stream().map(Hit::get_source).collect(Collectors.toList())).orElse(Collections.emptyList()));
    }

    public <T extends Document> EsSearchResponse<T> listSearch(List<QueryBuilder> queryBuilderList, String[] excludeFields, Class<T> clazz) {
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.aliasName(clazz)});
        searchRequest.scroll(scroll);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (CollectionUtils.isEmpty(queryBuilderList)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            for (QueryBuilder queryBuilder : queryBuilderList) {
                searchSourceBuilder.query(queryBuilder);
                searchRequest.source().query(queryBuilder);
            }
        }
        searchRequest.source(searchSourceBuilder);
        if (Objects.nonNull(excludeFields) && excludeFields.length > 0) {
            FetchSourceContext fetchSourceContext = new FetchSourceContext(true, null, excludeFields);
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        searchRequest.source(searchSourceBuilder);
        ArrayList<SearchHit[]> searchHitsList = new ArrayList<SearchHit[]>();
        String scrollId = "";
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            scrollId = searchResponse.getScrollId();
            SearchHit[] searchHits = searchResponse.getHits().getHits();
            searchHitsList.add(searchHits);
            while (searchHits != null && searchHits.length > 0) {
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(scroll);
                searchResponse = this.restHighLevelClient.scroll(scrollRequest, RequestOptions.DEFAULT);
                scrollId = searchResponse.getScrollId();
                searchHits = searchResponse.getHits().getHits();
                searchHitsList.add(searchHits);
            }
        }
        catch (Exception e) {
            throw new BusinessException("Search exception", (Throwable)e);
        }
        finally {
            if (StringUtils.hasLength((String)scrollId)) {
                try {
                    ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                    clearScrollRequest.addScrollId(scrollId);
                    this.restHighLevelClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                }
                catch (Exception e) {
                    LOGGER.error("clearScroll exception", (Throwable)e);
                }
            }
        }
        SearchHit[] combinedArray = (SearchHit[])searchHitsList.stream().flatMap(Arrays::stream).toArray(SearchHit[]::new);
        return new EsSearchResponse(this.deserializeSearchHits(clazz, combinedArray));
    }

    public String createIndexLifecyclePolicy(String policyName, String indexLifecyclePolicy) {
        Request request = new Request("PUT", "/_ilm/policy/" + policyName);
        request.setJsonEntity(indexLifecyclePolicy);
        try {
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new BusinessException("createIndexLifecyclePolicy failed!");
            }
        }
        catch (Exception e) {
            throw new BusinessException("createIndexLifecyclePolicy exception!", (Throwable)e);
        }
        return policyName;
    }

    public boolean existIndexLifecyclePolicy(String policyName) {
        Request getPolicyRequest = new Request("GET", "/_ilm/policy/" + policyName);
        try {
            GetLifecyclePolicyRequest getLifecyclePolicyRequest = new GetLifecyclePolicyRequest(new String[]{policyName});
            GetLifecyclePolicyResponse getLifecyclePolicyResponse = this.restHighLevelClient.indexLifecycle().getLifecyclePolicy(getLifecyclePolicyRequest, RequestOptions.DEFAULT);
            ImmutableOpenMap policies = getLifecyclePolicyResponse.getPolicies();
            return policies.containsKey((Object)policyName);
        }
        catch (Exception e) {
            LOGGER.error("existIndexLifecyclePolicy error", (Throwable)e);
            return false;
        }
    }

    public String getIndexLifecyclePolicy(String policyName) {
        try {
            GetLifecyclePolicyRequest getLifecyclePolicyRequest = new GetLifecyclePolicyRequest(new String[]{policyName});
            GetLifecyclePolicyResponse getLifecyclePolicyResponse = this.restHighLevelClient.indexLifecycle().getLifecyclePolicy(getLifecyclePolicyRequest, RequestOptions.DEFAULT);
            ImmutableOpenMap policies = getLifecyclePolicyResponse.getPolicies();
            LifecyclePolicyMetadata myPolicyMetadata = (LifecyclePolicyMetadata)policies.get((Object)policyName);
            LifecyclePolicy myPolicy = myPolicyMetadata.getPolicy();
            return com.digiwin.dap.middleware.lmc.util.JsonUtils.writeValueAsString((Object)myPolicy);
        }
        catch (Exception e) {
            LOGGER.error("existIndexLifecyclePolicy error", (Throwable)e);
            return null;
        }
    }

    public String queryWriteIndex(String indices) {
        try {
            GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{indices});
            GetIndexResponse getIndexResponse = this.restHighLevelClient.indices().get(getIndexRequest, RequestOptions.DEFAULT);
            Map aliases = getIndexResponse.getAliases();
            if (CollectionUtils.isEmpty((Map)aliases)) {
                return null;
            }
            for (Map.Entry entry : aliases.entrySet()) {
                String indexName = (String)entry.getKey();
                List aliasMetadataList = (List)entry.getValue();
                for (AliasMetadata aliasMetadata : aliasMetadataList) {
                    if (!Objects.nonNull(aliasMetadata.writeIndex()) || !aliasMetadata.writeIndex().booleanValue()) continue;
                    return indexName;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("isExistIsWriteIndex error", (Throwable)e);
            return null;
        }
    }

    public void updateWriteIndex(String indexName, String aliasName) {
        try {
            IndicesAliasesRequest request = new IndicesAliasesRequest();
            IndicesAliasesRequest.AliasActions aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexName).alias(aliasName).writeIndex(Boolean.valueOf(false));
            request.addAliasAction(aliasAction);
            this.restHighLevelClient.indices().updateAliases(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOGGER.error("isExistIsWriteIndex error", (Throwable)e);
        }
    }

    public <T extends Document> EsStatisticsDiskUsageResponse statisticsDiskUsageByConditions(String groupByField, Class<T> clazz) {
        String aliasName = this.aliasName(clazz);
        EsStatisticsDiskUsageResponse esStatisticsDiskUsageResponse = new EsStatisticsDiskUsageResponse(aliasName, groupByField);
        SearchRequest request = new SearchRequest(new String[]{aliasName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(0);
        sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        sourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_conditions").field(groupByField)).size(9999).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"total_disk_usage").field("_size")));
        request.source(sourceBuilder);
        try {
            SearchResponse response = this.restHighLevelClient.search(request, RequestOptions.DEFAULT);
            ArrayList<EsStatisticsDiskUsageResult> diskUsageList = new ArrayList<EsStatisticsDiskUsageResult>();
            Terms groupByTerms = (Terms)response.getAggregations().get("group_by_conditions");
            for (Terms.Bucket bucket : groupByTerms.getBuckets()) {
                Sum sum = (Sum)bucket.getAggregations().get("total_disk_usage");
                BigDecimal sumBigDecimal = new BigDecimal(Double.toString(sum.getValue()));
                EsStatisticsDiskUsageResult esStatisticsDiskUsageResult = new EsStatisticsDiskUsageResult();
                esStatisticsDiskUsageResult.setKey(bucket.getKeyAsString());
                esStatisticsDiskUsageResult.setDocCount(bucket.getDocCount());
                esStatisticsDiskUsageResult.setDiskUsage(sumBigDecimal.longValue());
                diskUsageList.add(esStatisticsDiskUsageResult);
            }
            esStatisticsDiskUsageResponse.setDiskUsageList(diskUsageList);
        }
        catch (Exception e) {
            throw new BusinessException("statisticsDiskUsageByConditions exception!", (Throwable)e);
        }
        return esStatisticsDiskUsageResponse;
    }

    public void deleteByQueryAsync(QueryBuilder queryBuilder, String ... indices) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(indices);
        ((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)request.setRefresh(false)).setAbortOnVersionConflict(false)).setSlices(0)).setBatchSize(8000).setScroll(TimeValue.timeValueMinutes((long)30L))).setQuery(queryBuilder);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.restHighLevelClient.deleteByQueryAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
    }

    private String aliasName(Class<? extends Document> clazz) {
        ElasticsearchIndexStrategy elasticsearchIndexStrategy = clazz.getAnnotation(ElasticsearchIndexStrategy.class);
        return elasticsearchIndexStrategy.aliasName();
    }

    private String indexName(Class<? extends Document> clazz, Document document) {
        ElasticsearchIndexStrategy elasticsearchIndexStrategy = clazz.getAnnotation(ElasticsearchIndexStrategy.class);
        String indexNameSuffix = "";
        try {
            IElasticsearchIndexStrategy iElasticsearchIndexStrategy = (IElasticsearchIndexStrategy)elasticsearchIndexStrategy.elasticsearchIndexStrategy().newInstance();
            indexNameSuffix = iElasticsearchIndexStrategy.indexNameSuffix(document);
        }
        catch (Exception e) {
            LOGGER.error("ElasticsearchIndexStrategy exception.", (Throwable)e);
        }
        if (StringUtils.hasLength((String)indexNameSuffix)) {
            return elasticsearchIndexStrategy.indexName() + "-" + indexNameSuffix;
        }
        return elasticsearchIndexStrategy.indexName();
    }

    private <T extends Document> List<T> deserializeSearchHits(Class<T> clazz, SearchHit[] searchHits) {
        ArrayList<Document> dataList = new ArrayList<Document>();
        if (null == searchHits || searchHits.length <= 0) {
            return dataList;
        }
        try {
            for (SearchHit searchHit : searchHits) {
                dataList.add((Document)((Document)clazz.newInstance()).deserialization(searchHit.getId(), searchHit.getSourceAsMap()));
            }
        }
        catch (Exception e) {
            throw new BusinessException("Deserialization exception!", (Throwable)e);
        }
        return dataList;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

