/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.exception;

import com.digiwin.dap.middleware.lmc.support.exception.ListenerExecuteStateHolder;
import com.digiwin.dap.middleware.lmc.support.helper.AlertHelper;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LmcCommonErrorHandler
implements CommonErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmcCommonErrorHandler.class);
    @Autowired
    private AlertHelper alertHelper;

    public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        this.alert("handleOtherException", thrownException, consumer, container);
    }

    public void handleRecord(Exception thrownException, ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, MessageListenerContainer container) {
        String payload = LmcCommonErrorHandler.getPayload((MessageListenerContainer)container);
        this.alertHelper.doAlert("handleRecord\u544a\u8b66,state" + ListenerExecuteStateHolder.get(), (Throwable)thrownException, payload);
    }

    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        String payload = LmcCommonErrorHandler.getPayload((MessageListenerContainer)container);
        this.alertHelper.doAlert("handleRemaining\u544a\u8b66,state" + ListenerExecuteStateHolder.get(), (Throwable)thrownException, payload);
    }

    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        LOGGER.info("\u3010handleBatch\u3011:", (Throwable)thrownException);
        this.alert("handleBatch", thrownException, consumer, container);
    }

    private void alert(String alertPrefix, Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container) {
        String payload = LmcCommonErrorHandler.getPayload((MessageListenerContainer)container);
        if (ListenerExecuteStateHolder.isPayloadsSent()) {
            try {
                consumer.commitSync();
            }
            catch (Exception e) {
                this.alertHelper.doAlert(String.format("%s\u544a\u8b66,state:%s", alertPrefix, ListenerExecuteStateHolder.get()), (Throwable)thrownException, payload);
            }
        } else {
            this.alertHelper.doAlert(String.format("%s\u544a\u8b66,state:%s", alertPrefix, ListenerExecuteStateHolder.get()), (Throwable)thrownException, payload);
        }
    }

    private static String getPayload(MessageListenerContainer container) {
        String payload = "";
        if (!CollectionUtils.isEmpty((Collection)container.getAssignedPartitions())) {
            payload = JsonUtils.objToJson((Object)LmcCommonErrorHandler.getTp((Collection)container.getAssignedPartitions()));
        }
        return payload;
    }

    public boolean isAckAfterHandle() {
        return false;
    }

    public void setAckAfterHandle(boolean ack) {
    }

    public void onPartitionsAssigned(Consumer<?, ?> consumer, Collection<TopicPartition> partitions) {
        String stringBuilder = LmcCommonErrorHandler.getTp(partitions);
        LOGGER.info("\u3010onPartitionsAssigned\u3011TP:{};state:{}", (Object)stringBuilder, (Object)ListenerExecuteStateHolder.get());
    }

    private static String getTp(Collection<TopicPartition> partitions) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TopicPartition partition : partitions) {
            stringBuilder.append(partition.toString()).append(",");
        }
        return stringBuilder.toString();
    }

    public void onPartitionsAssigned(Consumer<?, ?> consumer, Collection<TopicPartition> partitions, Runnable publishPause) {
        this.onPartitionsAssigned(consumer, partitions);
    }
}

